/*
 * Decompiled with CFR 0.152.
 */
package de.pianoman911.playerculling.core.commands.builtin;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import de.pianoman911.playerculling.core.commands.PlayerCullingCommand;
import de.pianoman911.playerculling.core.culling.CullContainer;
import de.pianoman911.playerculling.core.culling.CullShip;
import de.pianoman911.playerculling.platformcommon.platform.command.PlatformCommandSourceStack;
import de.pianoman911.playerculling.platformcommon.platform.entity.PlatformPlayer;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;

public class PlayerCullingContainerViewCommand {
    private PlayerCullingContainerViewCommand() {
    }

    public static LiteralArgumentBuilder<PlatformCommandSourceStack> getNode(CullShip ship) {
        Set<PlatformPlayer> players = Collections.newSetFromMap(new WeakHashMap());
        Collection<CullContainerBar> bars = PlayerCullingContainerViewCommand.runPerformance(ship, players);
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)PlayerCullingCommand.literal("viewcontainers").requires(ctx -> ctx.getSender() instanceof PlatformPlayer && ctx.getSender().hasPermission("playerculling.command.viewcontainers"))).executes(ctx -> {
            PlatformPlayer sender = (PlatformPlayer)((PlatformCommandSourceStack)ctx.getSource()).getSender();
            if (players.add(sender)) {
                for (CullContainerBar bar : bars) {
                    sender.showBossBar(bar.bossBar());
                }
                sender.sendMessage((Component)Component.text((String)"Enabled container view mode.", (TextColor)NamedTextColor.GREEN));
            } else {
                players.remove(sender);
                for (CullContainerBar bar : bars) {
                    sender.hideBossBar(bar.bossBar());
                }
                sender.sendMessage((Component)Component.text((String)"Disabled container view mode.", (TextColor)NamedTextColor.RED));
            }
            return 1;
        });
    }

    private static Collection<CullContainerBar> runPerformance(CullShip ship, final Set<PlatformPlayer> players) {
        Int2ObjectArrayMap bossBars = new Int2ObjectArrayMap();
        ship.getPlatform().runTaskRepeatingAsync(new Runnable(){
            private final IntSet oldContainers = new IntArraySet();
            private int counter;
            final /* synthetic */ Int2ObjectMap val$bossBars;
            final /* synthetic */ CullShip val$ship;
            {
                this.val$bossBars = int2ObjectMap;
                this.val$ship = cullShip;
            }

            @Override
            public void run() {
                if (players.isEmpty()) {
                    return;
                }
                ++this.counter;
                if (this.counter > 4) {
                    this.counter = 0;
                }
                this.oldContainers.addAll((IntCollection)this.val$bossBars.keySet());
                for (CullContainer container : this.val$ship.getContainers()) {
                    this.val$bossBars.computeIfAbsent(container.getContainerId(), __ -> {
                        BossBar bar = BossBar.bossBar((Component)Component.text((String)("Container " + container.getContainerId() + " - " + container.getAverageCullTime() + " - " + container.getLastRayStepCount() + " RaySteps/Tick")), (float)0.0f, (BossBar.Color)BossBar.Color.GREEN, (BossBar.Overlay)BossBar.Overlay.NOTCHED_10);
                        for (PlatformPlayer player : players) {
                            player.showBossBar(bar);
                        }
                        return new CullContainerBar(bar, container);
                    });
                    this.oldContainers.remove(container.getContainerId());
                }
                if (!this.oldContainers.isEmpty()) {
                    IntIterator intIterator = this.oldContainers.iterator();
                    while (intIterator.hasNext()) {
                        int oldContainer = (Integer)intIterator.next();
                        CullContainerBar bar = (CullContainerBar)this.val$bossBars.remove(oldContainer);
                        for (PlatformPlayer player : players) {
                            player.hideBossBar(bar.bossBar());
                        }
                    }
                    this.oldContainers.clear();
                }
                for (CullContainerBar cull : this.val$bossBars.values()) {
                    BossBar bossBar = cull.bossBar();
                    if (cull.container().getParkReason() != CullContainer.ParkReason.TIME_LEFT) {
                        float percentage = (float)cull.container().getTtl() / (float)this.val$ship.getConfig().getDelegate().scheduler.getContainerTtlMs();
                        if (percentage < 0.0f) {
                            percentage = this.counter > 2 ? 0.0f : 1.0f;
                        }
                        bossBar.overlay(BossBar.Overlay.PROGRESS);
                        bossBar.progress(Math.min(1.0f, Math.max(0.0f, percentage)));
                        bossBar.name((Component)Component.text((String)("Container " + cull.container().getContainerId() + " - Parked - TTL: " + cull.container().getTtl() / 1000L + "s")));
                        bossBar.color(BossBar.Color.BLUE);
                        continue;
                    }
                    float averageCullTime = (float)((double)cull.container().getAverageCullTime() / 1000000.0);
                    float percentage = averageCullTime / (float)this.val$ship.getConfig().getDelegate().scheduler.maxCullTime;
                    bossBar.name((Component)Component.text((String)("Container " + cull.container().getContainerId() + " - " + String.format("%.2f", Float.valueOf(averageCullTime)) + "ms - " + cull.container().getPlayerCount() + " players - " + cull.container().getLastRayStepCount() + " RaySteps/Tick")));
                    bossBar.progress(Math.min(1.0f, Math.max(0.0f, percentage)));
                    bossBar.color(percentage > 0.85f ? BossBar.Color.RED : (percentage > 0.65f ? BossBar.Color.YELLOW : BossBar.Color.GREEN));
                    bossBar.overlay(BossBar.Overlay.NOTCHED_10);
                }
            }
        }, 0L, 250L);
        return bossBars.values();
    }

    private record CullContainerBar(BossBar bossBar, CullContainer container) {
    }
}

