/*
 * Decompiled with CFR 0.152.
 */
package de.pianoman911.playerculling.core.commands.builtin;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import de.pianoman911.playerculling.core.commands.PlayerCullingCommand;
import de.pianoman911.playerculling.core.culling.CullShip;
import de.pianoman911.playerculling.platformcommon.cache.OcclusionChunkCache;
import de.pianoman911.playerculling.platformcommon.platform.command.PlatformCommandSender;
import de.pianoman911.playerculling.platformcommon.platform.command.PlatformCommandSourceStack;
import de.pianoman911.playerculling.platformcommon.platform.entity.PlatformEntity;
import de.pianoman911.playerculling.platformcommon.platform.world.PlatformWorld;
import de.pianoman911.playerculling.platformcommon.util.ConcurrentLongCache;
import de.pianoman911.playerculling.platformcommon.util.StringUtil;
import java.util.Objects;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;

public final class PlayerCullingChunkCacheCommand {
    private PlayerCullingChunkCacheCommand() {
    }

    public static LiteralArgumentBuilder<PlatformCommandSourceStack> getNode(CullShip ship) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)PlayerCullingCommand.literal("chunkcache").requires(ctx -> ctx.getExecutor() != null && ctx.getSender().hasPermission("playerculling.command.chunkcache"))).executes(ctx -> PlayerCullingChunkCacheCommand.execute(((PlatformCommandSourceStack)ctx.getSource()).getSender(), Objects.requireNonNull(((PlatformCommandSourceStack)ctx.getSource()).getExecutor()), ship));
    }

    private static int execute(PlatformCommandSender sender, PlatformEntity executor, CullShip ship) {
        sender.sendMessage(Component.text((String)"Chunks stored: ", (TextColor)NamedTextColor.GREEN).append((Component)Component.text((int)executor.getWorld().getOcclusionWorldCache().getChunkCache().size(), (TextColor)NamedTextColor.WHITE)));
        for (PlatformWorld world : ship.getPlatform().getWorlds()) {
            ConcurrentLongCache<OcclusionChunkCache> cache = world.getOcclusionWorldCache().getChunkCache();
            OcclusionChunkCache current = null;
            if (executor.getWorld() == world) {
                int x = executor.getPosition().getFloorX() >> 4;
                int z = executor.getPosition().getFloorZ() >> 4;
                for (OcclusionChunkCache chunk : cache) {
                    if (chunk.getX() != x || chunk.getZ() != z) continue;
                    current = chunk;
                    break;
                }
            }
            sender.sendMessage(((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.text((String)"Chunks stored in world ", (TextColor)NamedTextColor.GREEN).append((Component)Component.text((String)world.getName(), (TextColor)NamedTextColor.WHITE))).append((Component)Component.text((String)": ", (TextColor)NamedTextColor.GREEN))).append((Component)Component.text((int)cache.size(), (TextColor)NamedTextColor.WHITE))).append((Component)Component.text((String)", current chunk cached: ", (TextColor)NamedTextColor.GREEN))).append((Component)Component.text((current != null ? 1 : 0) != 0, (TextColor)NamedTextColor.WHITE))).append((Component)(current == null ? Component.empty() : ((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.text((String)" (Height: ", (TextColor)NamedTextColor.GREEN).append((Component)Component.text((int)current.getHeight(), (TextColor)NamedTextColor.WHITE))).append((Component)Component.text((String)" ; From ", (TextColor)NamedTextColor.GREEN))).append((Component)Component.text((int)current.getMinY(), (TextColor)NamedTextColor.WHITE))).append((Component)Component.text((String)"Y to ", (TextColor)NamedTextColor.GREEN))).append((Component)Component.text((int)current.getMaxY(), (TextColor)NamedTextColor.WHITE))).append((Component)Component.text((String)"Y) Bytes: ", (TextColor)NamedTextColor.GREEN))).append((Component)Component.text((String)StringUtil.toNumInUnits(current.byteSize()), (TextColor)NamedTextColor.WHITE)))));
        }
        return 1;
    }
}

