/*
 * Decompiled with CFR 0.152.
 */
package dev.booky.betterview.platform;

import dev.booky.betterview.common.BetterViewManager;
import dev.booky.betterview.common.hooks.BetterViewHook;
import dev.booky.betterview.common.hooks.LevelHook;
import dev.booky.betterview.common.hooks.PlayerHook;
import dev.booky.betterview.nms.PaperNmsInterface;
import dev.booky.betterview.platform.PaperLevel;
import dev.booky.betterview.platform.PaperPlayer;
import io.netty.channel.Channel;
import java.util.UUID;
import net.kyori.adventure.key.Key;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NullMarked
public class PaperBetterView
implements BetterViewHook {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"BetterView");
    private final BetterViewManager manager;

    public PaperBetterView(BetterViewManager manager) {
        this.manager = manager;
    }

    @Override
    public long getNanosPerServerTick() {
        return PaperNmsInterface.SERVICE.getNanosPerServerTick();
    }

    @Override
    public LevelHook constructLevel(String worldName) {
        World world = Bukkit.getWorld((Key)Key.key((String)worldName));
        if (world == null) {
            throw new IllegalStateException("Can't find level with name " + worldName);
        }
        return new PaperLevel(this.manager, world);
    }

    @Override
    public @Nullable PlayerHook constructPlayer(UUID playerId) {
        Player player = Bukkit.getPlayer((UUID)playerId);
        if (player == null) {
            throw new IllegalStateException("Can't find player with uuid " + String.valueOf(playerId));
        }
        Channel channel = PaperNmsInterface.SERVICE.getNettyChannel(player);
        if (!PaperNmsInterface.SERVICE.isInjected(channel)) {
            if (!PaperNmsInterface.SERVICE.isFakeChannel(channel)) {
                LOGGER.warn("Failed to inject into player {} (channel {})", (Object)playerId, (Object)PaperNmsInterface.SERVICE.getNettyChannel(player));
            }
            return null;
        }
        return new PaperPlayer(this.manager, player);
    }
}

