/*
 * Decompiled with CFR 0.152.
 */
package dev.booky.betterview.nms.v1219;

import com.destroystokyo.paper.util.SneakyThrow;
import dev.booky.betterview.common.antixray.AntiXrayProcessor;
import dev.booky.betterview.common.util.BetterViewUtil;
import dev.booky.betterview.nms.ReflectionUtil;
import dev.booky.betterview.nms.v1219.LightWriter;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.lang.invoke.MethodHandle;
import java.util.Arrays;
import net.minecraft.SharedConstants;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.VarInt;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.EmptyLevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.PalettedContainer;
import net.minecraft.world.level.levelgen.Heightmap;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public final class ChunkWriter {
    static final Heightmap.Types[] SENDABLE_HEIGHTMAP_TYPES = (Heightmap.Types[])Arrays.stream(Heightmap.Types.values()).filter(Heightmap.Types::sendToClient).toArray(Heightmap.Types[]::new);
    static final int[] SENDABLE_HEIGHTMAP_TYPE_IDS = Arrays.stream(SENDABLE_HEIGHTMAP_TYPES).mapToInt(Enum::ordinal).toArray();
    private static final MethodHandle GET_NON_EMPTY_BLOCK_COUNT = ReflectionUtil.getGetter(LevelChunkSection.class, Short.TYPE, 0);

    private ChunkWriter() {
    }

    private static boolean isEmpty(ChunkAccess chunk) {
        if (chunk instanceof EmptyLevelChunk) {
            return true;
        }
        for (LevelChunkSection section : chunk.getSections()) {
            if (section == null || section.hasOnlyAir()) continue;
            return false;
        }
        return true;
    }

    public static long[] @Nullable [] extractHeightmapsData(ChunkAccess chunk) {
        long @Nullable [][] heightmapsData = new long[SENDABLE_HEIGHTMAP_TYPES.length][];
        for (Heightmap.Types type : SENDABLE_HEIGHTMAP_TYPES) {
            if (!chunk.hasPrimedHeightmap(type)) continue;
            heightmapsData[i] = chunk.getOrCreateHeightmapUnprimed(type).getRawData();
        }
        return heightmapsData;
    }

    public static ByteBuf writeFullOrEmpty(ChunkAccess chunk, @Nullable AntiXrayProcessor antiXray) {
        if (ChunkWriter.isEmpty(chunk)) {
            return Unpooled.EMPTY_BUFFER;
        }
        long[] @Nullable [] heightmapsData = ChunkWriter.extractHeightmapsData(chunk);
        byte[][] blockLight = LightWriter.convertStarlightToBytes(chunk.starlight$getBlockNibbles(), false);
        byte[][] skyLight = LightWriter.convertStarlightToBytes(chunk.starlight$getSkyNibbles(), true);
        return ChunkWriter.writeFull(chunk.locX, chunk.locZ, antiXray, chunk.getMinSectionY(), heightmapsData, chunk.getSections(), blockLight, skyLight);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuf writeFull(int chunkX, int chunkZ, @Nullable AntiXrayProcessor antiXray, int minSectionY, long[] @Nullable [] heightmapsData, LevelChunkSection[] sections, byte[][] blockLight, byte @Nullable [][] skyLight) {
        ByteBuf buf = BetterViewUtil.ALLOC.buffer();
        try {
            buf.writeByte(44);
            buf.writeInt(chunkX);
            buf.writeInt(chunkZ);
            ChunkWriter.writeFullBody(buf, antiXray, minSectionY, heightmapsData, sections, blockLight, skyLight);
            ByteBuf byteBuf = buf.retain();
            return byteBuf;
        }
        finally {
            buf.release();
        }
    }

    private static void writeHeightmaps(ByteBuf buf, long[] @Nullable [] heightmapsData) {
        int i;
        int heightmapsLen = heightmapsData.length;
        int heightmapsCount = 0;
        for (i = 0; i < heightmapsLen; ++i) {
            if (heightmapsData[i] == null) continue;
            ++heightmapsCount;
        }
        VarInt.write((ByteBuf)buf, (int)heightmapsCount);
        for (i = 0; i < heightmapsLen; ++i) {
            long[] data = heightmapsData[i];
            if (data == null) continue;
            VarInt.write((ByteBuf)buf, (int)SENDABLE_HEIGHTMAP_TYPE_IDS[i]);
            FriendlyByteBuf.writeLongArray((ByteBuf)buf, (long[])data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFullBody(ByteBuf buf, @Nullable AntiXrayProcessor antiXray, int minSectionY, long[] @Nullable [] heightmapsData, LevelChunkSection[] sections, byte[][] blockLight, byte @Nullable [][] skyLight) {
        ChunkWriter.writeHeightmaps(buf, heightmapsData);
        if (antiXray != null) {
            ByteBuf subBuf = BetterViewUtil.ALLOC.buffer();
            try {
                FriendlyByteBuf friendlyBuf = new FriendlyByteBuf(subBuf);
                int len = sections.length;
                for (int i = 0; i < len; ++i) {
                    ChunkWriter.writeSection(friendlyBuf, sections[i], antiXray, i + minSectionY);
                }
                VarInt.write((ByteBuf)buf, (int)subBuf.readableBytes());
                buf.writeBytes(subBuf);
            }
            finally {
                subBuf.release();
            }
        } else {
            int serializedSize = 0;
            int len = sections.length;
            for (int i = 0; i < len; ++i) {
                LevelChunkSection section = sections[i];
                serializedSize += section.getSerializedSize();
                if (SharedConstants.getProtocolVersion() != 770) continue;
                serializedSize -= VarInt.getByteSize((int)section.states.data.storage().getRaw().length) + VarInt.getByteSize((int)((PalettedContainer)section.getBiomes()).data.storage().getRaw().length);
            }
            VarInt.write((ByteBuf)buf, (int)serializedSize);
            int expectedWriterIndex = buf.writerIndex() + serializedSize;
            FriendlyByteBuf friendlyBuf = new FriendlyByteBuf(buf);
            int len2 = sections.length;
            for (int i = 0; i < len2; ++i) {
                sections[i].write(friendlyBuf, null, 0);
            }
            if (buf.writerIndex() != expectedWriterIndex) {
                throw new IllegalStateException("Expected writer index to be at " + expectedWriterIndex + ", got " + buf.writerIndex());
            }
        }
        VarInt.write((ByteBuf)buf, (int)0);
        LightWriter.writeLightData(buf, blockLight, skyLight);
    }

    private static void writeSection(FriendlyByteBuf buf, LevelChunkSection section, AntiXrayProcessor antiXray, int sectionY) {
        try {
            buf.writeShort((int)GET_NON_EMPTY_BLOCK_COUNT.invoke(section));
        }
        catch (Throwable throwable) {
            SneakyThrow.sneaky((Throwable)throwable);
        }
        int preReaderIndex = buf.readerIndex();
        int preWriterIndex = buf.writerIndex();
        section.states.write(buf, null, 0);
        buf.readerIndex(preWriterIndex);
        antiXray.process((ByteBuf)buf, sectionY, false);
        buf.readerIndex(preReaderIndex);
        section.getBiomes().write(buf, null, 0);
    }
}

