/*
 * Decompiled with CFR 0.152.
 */
package dev.booky.betterview.nms.v12111;

import ca.spottedleaf.moonrise.common.util.WorldUtil;
import ca.spottedleaf.moonrise.patches.starlight.util.SaveUtil;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import dev.booky.betterview.common.antixray.AntiXrayProcessor;
import dev.booky.betterview.nms.v12111.ChunkWriter;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Optional;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.PalettedContainer;
import net.minecraft.world.level.chunk.PalettedContainerFactory;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public final class ChunkTagTransformer {
    private static final long[][] EMPTY_LONG_2D_ARRAY = new long[0][];

    private ChunkTagTransformer() {
    }

    public static boolean isChunkLit(CompoundTag tag) {
        Optional statusName = tag.getString("Status");
        if (statusName.isEmpty()) {
            return false;
        }
        ChunkStatus status = ChunkStatus.byName((String)((String)statusName.get()));
        if (!status.isOrAfter(ChunkStatus.LIGHT)) {
            return false;
        }
        if (tag.get("isLightOn") == null) {
            return false;
        }
        Optional lightVersion = tag.getInt("starlight.light_version");
        return lightVersion.isPresent() && (Integer)lightVersion.get() == SaveUtil.getLightVersion();
    }

    private static boolean extractChunkData(ServerLevel level, CompoundTag chunkTag, ChunkPos pos, LevelChunkSection[] sections, byte[][] blockLight, byte @Nullable [][] skyLight) {
        PalettedContainerFactory factory = level.palettedContainerFactory();
        Codec biomeCodec = factory.biomeContainerRWCodec();
        Codec blockCodec = factory.blockStatesContainerCodec();
        ListTag sectionTags = chunkTag.getListOrEmpty("sections");
        int minLightSection = WorldUtil.getMinLightSection((LevelHeightAccessor)level);
        boolean onlyAir = true;
        for (int i = 0; i < sectionTags.size(); ++i) {
            ByteArrayTag lightTag;
            Tag tag;
            CompoundTag sectionTag = (CompoundTag)sectionTags.getCompound(i).orElseThrow();
            byte sectionY = (Byte)sectionTag.getByte("Y").orElseThrow();
            int sectionIndex = level.getSectionIndexFromSectionY((int)sectionY);
            if (sectionIndex >= 0 && sectionIndex < sections.length) {
                LevelChunkSection section;
                PalettedContainer palettedContainer;
                PalettedContainer palettedContainer2;
                Tag tag2 = sectionTag.get("block_states");
                if (tag2 instanceof CompoundTag) {
                    CompoundTag blockStatesTag = (CompoundTag)tag2;
                    palettedContainer2 = (PalettedContainer)blockCodec.parse((DynamicOps)NbtOps.INSTANCE, (Object)blockStatesTag).getOrThrow();
                } else {
                    palettedContainer2 = factory.createForBlockStates();
                }
                PalettedContainer blocks = palettedContainer2;
                Tag tag3 = sectionTag.get("biomes");
                if (tag3 instanceof CompoundTag) {
                    CompoundTag biomesTag = (CompoundTag)tag3;
                    palettedContainer = (PalettedContainer)biomeCodec.parse((DynamicOps)NbtOps.INSTANCE, (Object)biomesTag).getOrThrow();
                } else {
                    palettedContainer = factory.createForBiomes();
                }
                PalettedContainer biomes = palettedContainer;
                sections[sectionIndex] = section = new LevelChunkSection(blocks, biomes);
                if (!section.hasOnlyAir()) {
                    onlyAir = false;
                }
            }
            if ((tag = sectionTag.get("BlockLight")) instanceof ByteArrayTag) {
                lightTag = (ByteArrayTag)tag;
                blockLight[sectionY - minLightSection] = lightTag.getAsByteArray();
            }
            if (skyLight == null || !((tag = sectionTag.get("SkyLight")) instanceof ByteArrayTag)) continue;
            lightTag = (ByteArrayTag)tag;
            skyLight[sectionY - minLightSection] = lightTag.getAsByteArray();
        }
        return onlyAir;
    }

    private static long[] @Nullable [] extractHeightmapsData(CompoundTag chunkTag) {
        CompoundTag heightmaps = chunkTag.getCompoundOrEmpty("Heightmaps");
        if (heightmaps.isEmpty()) {
            return EMPTY_LONG_2D_ARRAY;
        }
        long @Nullable [][] heightmapsData = new long[ChunkWriter.SENDABLE_HEIGHTMAP_TYPES.length][];
        int len = ChunkWriter.SENDABLE_HEIGHTMAP_TYPES.length;
        for (int i = 0; i < len; ++i) {
            String key = ChunkWriter.SENDABLE_HEIGHTMAP_TYPES[i].getSerializationKey();
            Tag tag = heightmaps.get(key);
            if (!(tag instanceof LongArrayTag)) continue;
            LongArrayTag tag2 = (LongArrayTag)tag;
            heightmapsData[i] = tag2.getAsLongArray();
        }
        return heightmapsData;
    }

    public static ByteBuf transformToBytesOrEmpty(ServerLevel level, CompoundTag chunkTag, @Nullable AntiXrayProcessor antiXray, ChunkPos pos) {
        byte[][] skyLight;
        byte[][] blockLight;
        LevelChunkSection[] sections = new LevelChunkSection[level.getSectionsCount()];
        boolean onlyAir = ChunkTagTransformer.extractChunkData(level, chunkTag, pos, sections, blockLight = new byte[WorldUtil.getTotalLightSections((LevelHeightAccessor)level)][], skyLight = level.dimensionType().hasSkyLight() ? new byte[blockLight.length][] : null);
        if (onlyAir) {
            return Unpooled.EMPTY_BUFFER;
        }
        long[] @Nullable [] heightmapsData = ChunkTagTransformer.extractHeightmapsData(chunkTag);
        return ChunkWriter.writeFull(pos.x, pos.z, antiXray, level.getMinSectionY(), heightmapsData, sections, blockLight, skyLight);
    }
}

