/*
 * Decompiled with CFR 0.152.
 */
package dev.booky.betterview.common.util;

import java.util.Objects;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class McChunkPos {
    private final int posX;
    private final int posZ;
    private final long key;

    public McChunkPos(int posX, int posZ, long key) {
        this.posX = posX;
        this.posZ = posZ;
        this.key = key;
    }

    public McChunkPos(int posX, int posZ) {
        this.posX = posX;
        this.posZ = posZ;
        this.key = McChunkPos.getChunkKey(posX, posZ);
    }

    public McChunkPos(long key) {
        this.posX = McChunkPos.getChunkX(key);
        this.posZ = McChunkPos.getChunkZ(key);
        this.key = key;
    }

    public static long getChunkKey(int posX, int posZ) {
        return (long)posZ << 32 | (long)posX & 0xFFFFFFFFL;
    }

    public static int getChunkX(long key) {
        return (int)key;
    }

    public static int getChunkZ(long key) {
        return (int)(key >>> 32);
    }

    public int distanceSquared(McChunkPos other) {
        int diffX = this.posX - other.posX;
        int diffZ = this.posZ - other.posZ;
        return diffX * diffX + diffZ * diffZ;
    }

    public int getX() {
        return this.posX;
    }

    public int getZ() {
        return this.posZ;
    }

    public long getKey() {
        return this.key;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof McChunkPos)) {
            return false;
        }
        McChunkPos that = (McChunkPos)obj;
        return this.key == that.key;
    }

    public int hashCode() {
        return Objects.hash(this.posX, this.posZ);
    }

    public String toString() {
        return "Chunk[" + this.posX + ";" + this.posZ + "]";
    }
}

