/*
 * Decompiled with CFR 0.152.
 */
package dev.booky.betterview.common.util;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.github.benmanes.caffeine.cache.Ticker;
import dev.booky.betterview.common.ChunkCacheEntry;
import dev.booky.betterview.common.hooks.LevelHook;
import dev.booky.betterview.common.util.McChunkPos;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.buffer.UnpooledByteBufAllocator;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class BetterViewUtil {
    private static final boolean ALLOC_UNPOOLED = Boolean.getBoolean("betterview.alloc.unpooled");
    private static final boolean ALLOC_HEAP = Boolean.getBoolean("betterview.alloc.heap");
    public static final ByteBufAllocator ALLOC = ALLOC_UNPOOLED ? new UnpooledByteBufAllocator(!ALLOC_HEAP) : new PooledByteBufAllocator(!ALLOC_HEAP);
    public static final int MC_MAX_DIMENSION_SIZE = 30000000;
    public static final int MC_MAX_DIMENSION_SIZE_CHUNKS = 480000000;

    private BetterViewUtil() {
    }

    public static LoadingCache<McChunkPos, ChunkCacheEntry> buildCache(LevelHook level) {
        return Caffeine.newBuilder().expireAfterWrite(level.getConfig().getCacheDuration()).ticker(Ticker.systemTicker()).removalListener((key, val, cause) -> {
            if (val != null) {
                val.release();
            }
        }).build(pos -> new ChunkCacheEntry(level, (McChunkPos)pos));
    }

    public static boolean isWithinRange(int posX, int posZ, int viewDistance) {
        int viewDistanceSqrt;
        long distZ;
        int absZ;
        int absX = Math.abs(posX);
        int squareDist = Math.max(absX, absZ = Math.abs(posZ));
        if (squareDist > viewDistance + 1) {
            return false;
        }
        long distX = Math.max(0, absX - 2);
        long distXZSqrt = distX * distX + (distZ = (long)Math.max(0, absZ - 2)) * distZ;
        return distXZSqrt < (long)(viewDistanceSqrt = viewDistance * viewDistance);
    }

    public static ByteBuf encodeChunkPos(long chunkKey) {
        return Unpooled.wrappedBuffer((byte[])new byte[]{(byte)(chunkKey >> 56), (byte)(chunkKey >> 48), (byte)(chunkKey >> 40), (byte)(chunkKey >> 32), (byte)(chunkKey >> 24), (byte)(chunkKey >> 16), (byte)(chunkKey >> 8), (byte)chunkKey});
    }

    public static ByteBuf encodeChunkPos(int chunkX, int chunkZ) {
        return Unpooled.wrappedBuffer((byte[])new byte[]{(byte)(chunkX >> 24), (byte)(chunkX >> 16), (byte)(chunkX >> 8), (byte)chunkX, (byte)(chunkZ >> 24), (byte)(chunkZ >> 16), (byte)(chunkZ >> 8), (byte)chunkZ});
    }
}

