/*
 * Decompiled with CFR 0.152.
 */
package dev.booky.betterview.common.config;

import dev.booky.betterview.common.antixray.ReplacementStrategy;
import java.time.Duration;
import java.util.List;
import net.kyori.adventure.key.Key;
import org.jspecify.annotations.NullMarked;
import org.spongepowered.configurate.objectmapping.ConfigSerializable;
import org.spongepowered.configurate.objectmapping.meta.Comment;

@NullMarked
@ConfigSerializable
public class BvLevelConfig {
    @Comment(value="Whether the extended view distance is enabled for this dimension or not")
    private boolean enabled = true;
    @Comment(value="How many new chunks can be generated for this level in one tick")
    private int chunkGenerationLimit = 2;
    @Comment(value="How many chunks can be queued per player at once")
    private int chunkQueueSize = 16;
    @Comment(value="The maximum extended view distance for this level")
    private int viewDistance = 32;
    @Comment(value="The cache duration for all extended chunks, after which they will be re-build")
    private Duration cacheDuration = Duration.ofMinutes(5L);
    @Comment(value="Configuration options for a lightweight anti-xray applied to extended chunks")
    private AntiXrayConfig antiXray = new AntiXrayConfig();

    public boolean isEnabled() {
        return this.enabled;
    }

    public int getChunkGenerationLimit() {
        return this.chunkGenerationLimit;
    }

    public int getChunkQueueSize() {
        return this.chunkQueueSize;
    }

    public int getViewDistance() {
        return this.viewDistance;
    }

    public Duration getCacheDuration() {
        return this.cacheDuration;
    }

    public AntiXrayConfig getAntiXray() {
        return this.antiXray;
    }

    @ConfigSerializable
    public static final class AntiXrayConfig {
        @Comment(value="Whether or not anti-xray is enabled for extended chunks")
        private boolean enabled = false;
        @Comment(value="The anti-xray engine mode, recommended to be left at \"HIDE\" as this\nanti-xray doesn't check whether a block is exposed or not")
        private EngineMode engineMode = EngineMode.HIDE;
        @Comment(value="The blocks to hide or obfuscate")
        private List<Key> hiddenBlocks = List.of(Key.key((String)"stone"), Key.key((String)"deepslate"), Key.key((String)"netherrack"), Key.key((String)"end_stone"), Key.key((String)"diamond_ore"), Key.key((String)"deepslate_diamond_ore"), Key.key((String)"iron_ore"), Key.key((String)"deepslate_iron_ore"), Key.key((String)"coal_ore"), Key.key((String)"deepslate_coal_ore"), Key.key((String)"emerald_ore"), Key.key((String)"deepslate_emerald_ore"), Key.key((String)"copper_ore"), Key.key((String)"deepslate_copper_ore"), Key.key((String)"redstone_ore"), Key.key((String)"deepslate_redstone_ore"), Key.key((String)"gold_ore"), Key.key((String)"deepslate_gold_ore"), Key.key((String)"lapis_ore"), Key.key((String)"deepslate_lapis_ore"), Key.key((String)"nether_gold_ore"), Key.key((String)"nether_quartz_ore"), Key.key((String)"ancient_debris"), Key.key((String)"raw_copper_block"), Key.key((String)"raw_iron_block"));

        public boolean isEnabled() {
            return this.enabled;
        }

        public EngineMode getEngineMode() {
            return this.engineMode;
        }

        public List<Key> getHiddenBlocks() {
            return this.hiddenBlocks;
        }

        public static enum EngineMode {
            HIDE(ReplacementStrategy::replaceStaticZero),
            OBFUSCATE(ReplacementStrategy::replaceRandom),
            OBFUSCATE_LAYER(ReplacementStrategy::replaceRandomLayered);

            private final ReplacementStrategy.Ctor strategy;

            private EngineMode(ReplacementStrategy.Ctor strategy) {
                this.strategy = strategy;
            }

            public ReplacementStrategy.Ctor getStrategy() {
                return this.strategy;
            }
        }
    }
}

