/*
 * Decompiled with CFR 0.152.
 */
package dev.booky.betterview.common;

import dev.booky.betterview.common.BetterViewPlayer;
import dev.booky.betterview.common.ChunkCacheEntry;
import dev.booky.betterview.common.config.BvConfig;
import dev.booky.betterview.common.config.BvLevelConfig;
import dev.booky.betterview.common.config.loading.ConfigurateLoader;
import dev.booky.betterview.common.hooks.BetterViewHook;
import dev.booky.betterview.common.hooks.LevelHook;
import dev.booky.betterview.common.hooks.PlayerHook;
import dev.booky.betterview.common.util.McChunkPos;
import io.leangen.geantyref.TypeToken;
import io.netty.buffer.ByteBuf;
import io.netty.util.NettyRuntime;
import io.netty.util.internal.SystemPropertyUtil;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import net.kyori.adventure.key.Key;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NullMarked
public final class BetterViewManager {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"BetterView");
    static final int TICK_LENGTH_DIVISOR = 2;
    private final AtomicInteger generatedChunks = new AtomicInteger(0);
    private final BetterViewHook hook;
    private final Map<String, LevelHook> levels = new HashMap<String, LevelHook>();
    private final Map<UUID, PlayerHook> players = new HashMap<UUID, PlayerHook>();
    private final Path configPath;
    private BvConfig config;

    public BetterViewManager(Function<BetterViewManager, BetterViewHook> hookConstructor, Path configPath) {
        this.hook = hookConstructor.apply(this);
        this.configPath = configPath;
        this.config = this.loadConfig();
        this.saveConfig();
    }

    private BvConfig loadConfig() {
        return ConfigurateLoader.loadYaml(BvConfig.SERIALIZERS, this.configPath, new TypeToken<BvConfig>(this){}, BvConfig::new);
    }

    private void saveConfig() {
        ConfigurateLoader.saveYaml(BvConfig.SERIALIZERS, this.configPath, new TypeToken<BvConfig>(this){}, this.config);
    }

    public void onPostLoad() {
        this.config = this.loadConfig();
        for (LevelHook level : this.levels.values()) {
            this.config.getLevelConfig(level.getName());
        }
        this.saveConfig();
    }

    public void runTick() {
        BetterViewHook hook = this.hook;
        if (!this.config.getGlobalConfig().isEnabled()) {
            return;
        }
        ArrayList<PlayerHook> players = new ArrayList<PlayerHook>(this.players.values());
        if (players.isEmpty()) {
            return;
        }
        this.generatedChunks.set(0);
        for (LevelHook level : this.levels.values()) {
            level.resetChunkGeneration();
        }
        Collections.shuffle(players);
        int nettyThreadCount = Math.max(1, SystemPropertyUtil.getInt((String)"io.netty.eventLoopThreads", (int)(NettyRuntime.availableProcessors() * 2)));
        long tickLengthNanos = hook.getNanosPerServerTick() / 2L;
        long maxTimePerPlayerNanos = (long)nettyThreadCount * tickLengthNanos / (long)Math.max(nettyThreadCount, players.size());
        for (PlayerHook player : players) {
            LevelHook level = player.getLevel();
            McChunkPos chunkPos = player.getChunkPos();
            player.getNettyChannel().eventLoop().execute(() -> {
                try {
                    long deadline = System.nanoTime() + maxTimePerPlayerNanos;
                    this.tickPlayer(player, level, chunkPos, deadline);
                }
                catch (Throwable throwable) {
                    LOGGER.error("Error while ticking player {} in level {}", new Object[]{player, level, throwable});
                }
            });
        }
    }

    private void tickPlayer(PlayerHook player, LevelHook level, McChunkPos chunkPos, long deadline) {
        BetterViewPlayer bv = player.getBvPlayer();
        bv.move(level, chunkPos);
        if (!bv.preTick()) {
            return;
        }
        int chunksPerTick = this.config.getGlobalConfig().getChunkSendLimit();
        int chunkQueueSize = level.getConfig().getChunkQueueSize();
        do {
            McChunkPos nextChunk;
            bv.chunkQueue.removeIf(bv::checkQueueEntry);
            if (bv.chunkQueue.size() >= chunkQueueSize || (nextChunk = bv.pollChunkPos()) == null) break;
            CompletableFuture<@Nullable ByteBuf> future = ((ChunkCacheEntry)level.getChunkCache().get((Object)nextChunk)).get();
            BetterViewPlayer.ChunkQueueEntry queueEntry = new BetterViewPlayer.ChunkQueueEntry(nextChunk, future);
            bv.chunkQueue.add(queueEntry.retain());
        } while (chunksPerTick-- > 0 && deadline > System.nanoTime());
    }

    public boolean checkChunkGeneration() {
        return this.generatedChunks.getAndIncrement() <= this.config.getGlobalConfig().getChunkGenerationLimit();
    }

    public LevelHook getLevel(Key worldName) {
        return this.levels.computeIfAbsent(worldName.asString(), this.hook::constructLevel);
    }

    public void unregisterLevel(Key worldName) {
        this.levels.remove(worldName.asString());
    }

    public @Nullable PlayerHook getPlayerOrNull(UUID playerId) {
        return this.players.computeIfAbsent(playerId, this.hook::constructPlayer);
    }

    public PlayerHook getPlayer(UUID playerId) {
        PlayerHook player = this.getPlayerOrNull(playerId);
        if (player == null) {
            throw new IllegalStateException("Can't construct player " + String.valueOf(playerId));
        }
        return player;
    }

    public void unregisterPlayer(UUID playerId) {
        PlayerHook player = this.players.remove(playerId);
        player.getNettyChannel().eventLoop().execute(player.getBvPlayer()::release);
    }

    public BvLevelConfig getConfig(Key worldName) {
        return this.config.getLevelConfig(worldName);
    }

    public BvConfig getConfig() {
        return this.config;
    }
}

