/*
 * Decompiled with CFR 0.152.
 */
package dev.booky.betterview.nms.v1219;

import ca.spottedleaf.moonrise.patches.starlight.light.SWMRNibbleArray;
import com.destroystokyo.paper.util.SneakyThrow;
import io.netty.buffer.ByteBuf;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.VarInt;
import org.jetbrains.annotations.Contract;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public final class LightWriter {
    private static final MethodHandle GET_STORAGE_VISIBLE = (MethodHandle)Util.make(() -> {
        try {
            MethodHandles.Lookup lookup = MethodHandles.privateLookupIn(SWMRNibbleArray.class, MethodHandles.lookup());
            return lookup.findGetter(SWMRNibbleArray.class, "storageVisible", byte[].class);
        }
        catch (ReflectiveOperationException exception) {
            throw new RuntimeException("Error while looking for starlight data layer storage getter");
        }
    });

    private LightWriter() {
    }

    @Contract(value="_, false -> !null")
    public static byte @Nullable [][] convertStarlightToBytes(SWMRNibbleArray[] layers, boolean allowEmpty) {
        try {
            int layerCount = layers.length;
            byte[][] byteLayers = new byte[layerCount][];
            boolean converted = false;
            for (int i = 0; i < layerCount; ++i) {
                SWMRNibbleArray layer = layers[i];
                if (!layer.isInitialisedVisible()) continue;
                byteLayers[i] = GET_STORAGE_VISIBLE.invoke(layer);
                converted = true;
            }
            return (byte[][])(converted || !allowEmpty ? byteLayers : null);
        }
        catch (Throwable throwable) {
            SneakyThrow.sneaky((Throwable)throwable);
            throw new AssertionError();
        }
    }

    public static void writeLightData(ByteBuf buf, byte[][] blockLight, byte @Nullable [][] skyLight) {
        if (skyLight == null) {
            LightWriter.writeNoSkyLightData(buf, blockLight);
            return;
        }
        ArrayList<byte[]> skyData = new ArrayList<byte[]>(skyLight.length);
        BitSet notSkyEmpty = new BitSet();
        BitSet skyEmpty = new BitSet();
        int blockLightLen = blockLight.length;
        ArrayList<byte[]> blockData = new ArrayList<byte[]>(blockLightLen);
        BitSet notBlockEmpty = new BitSet();
        BitSet blockEmpty = new BitSet();
        for (int indexY = 0; indexY < blockLightLen; ++indexY) {
            byte[] sky = skyLight[indexY];
            if (sky == null) {
                skyEmpty.set(indexY);
            } else {
                notSkyEmpty.set(indexY);
                skyData.add(sky);
            }
            byte[] block = blockLight[indexY];
            if (block == null) {
                blockEmpty.set(indexY);
                continue;
            }
            notBlockEmpty.set(indexY);
            blockData.add(block);
        }
        LightWriter.writeBitSet(buf, notSkyEmpty.toLongArray());
        LightWriter.writeBitSet(buf, notBlockEmpty.toLongArray());
        LightWriter.writeBitSet(buf, skyEmpty.toLongArray());
        LightWriter.writeBitSet(buf, blockEmpty.toLongArray());
        LightWriter.writeByteArrayList(buf, skyData);
        LightWriter.writeByteArrayList(buf, blockData);
    }

    private static void writeNoSkyLightData(ByteBuf buf, byte[][] blockLight) {
        int blockLightLen = blockLight.length;
        ArrayList<byte[]> blockData = new ArrayList<byte[]>(blockLightLen);
        BitSet notBlockEmpty = new BitSet();
        BitSet blockEmpty = new BitSet();
        for (int indexY = 0; indexY < blockLightLen; ++indexY) {
            byte[] block = blockLight[indexY];
            if (block == null) {
                blockEmpty.set(indexY);
                continue;
            }
            notBlockEmpty.set(indexY);
            blockData.add(block);
        }
        buf.writeByte(0);
        LightWriter.writeBitSet(buf, notBlockEmpty.toLongArray());
        buf.writeByte(0);
        LightWriter.writeBitSet(buf, blockEmpty.toLongArray());
        buf.writeByte(0);
        LightWriter.writeByteArrayList(buf, blockData);
    }

    private static void writeBitSet(ByteBuf buf, long[] set) {
        int len = set.length;
        VarInt.write((ByteBuf)buf, (int)len);
        for (int i = 0; i < len; ++i) {
            buf.writeLong(set[i]);
        }
    }

    private static void writeByteArrayList(ByteBuf buf, List<byte[]> list) {
        int len = list.size();
        if (len == 0) {
            buf.writeByte(0);
        } else if (len == 1) {
            buf.writeByte(1);
            FriendlyByteBuf.writeByteArray((ByteBuf)buf, (byte[])list.getFirst());
        } else {
            VarInt.write((ByteBuf)buf, (int)len);
            for (int i = 0; i < len; ++i) {
                FriendlyByteBuf.writeByteArray((ByteBuf)buf, (byte[])list.get(i));
            }
        }
    }
}

