/*
 * Decompiled with CFR 0.152.
 */
package dev.booky.betterview.nms;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.VarHandle;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Objects;
import sun.misc.Unsafe;

public final class ReflectionUtil {
    private static final Unsafe THE_UNSAFE;
    private static final MethodHandles.Lookup TRUSTED_LOOKUP;

    public static MethodHandles.Lookup getTrustedLookup() {
        return TRUSTED_LOOKUP;
    }

    public static MethodHandle getMethod(Class<?> clazz, MethodType methodType, int offset) {
        return ReflectionUtil.getMethod(ReflectionUtil.lookupMethod(clazz, methodType, offset));
    }

    public static MethodHandle getMethod(Method method) {
        try {
            MethodType mtype = MethodType.methodType(method.getReturnType(), method.getParameterTypes());
            if (Modifier.isStatic(method.getModifiers())) {
                return TRUSTED_LOOKUP.findStatic(method.getDeclaringClass(), method.getName(), mtype);
            }
            return TRUSTED_LOOKUP.findVirtual(method.getDeclaringClass(), method.getName(), mtype);
        }
        catch (ReflectiveOperationException exception) {
            throw new RuntimeException(exception);
        }
    }

    public static VarHandle getField(Class<?> clazz, Class<?> type, int offset) {
        return ReflectionUtil.getField(ReflectionUtil.lookupField(clazz, type, offset));
    }

    public static VarHandle getField(Field field) {
        try {
            if (Modifier.isStatic(field.getModifiers())) {
                return TRUSTED_LOOKUP.findStaticVarHandle(field.getDeclaringClass(), field.getName(), field.getType());
            }
            return TRUSTED_LOOKUP.findVarHandle(field.getDeclaringClass(), field.getName(), field.getType());
        }
        catch (ReflectiveOperationException exception) {
            throw new RuntimeException(exception);
        }
    }

    public static MethodHandle getGetter(Class<?> clazz, Class<?> type, int offset) {
        return ReflectionUtil.getGetter(ReflectionUtil.lookupField(clazz, type, offset));
    }

    public static MethodHandle getGetter(Field field) {
        try {
            if (Modifier.isStatic(field.getModifiers())) {
                return TRUSTED_LOOKUP.findStaticGetter(field.getDeclaringClass(), field.getName(), field.getType());
            }
            return TRUSTED_LOOKUP.findGetter(field.getDeclaringClass(), field.getName(), field.getType());
        }
        catch (ReflectiveOperationException exception) {
            throw new RuntimeException(exception);
        }
    }

    public static MethodHandle getSetter(Class<?> clazz, Class<?> type, int offset) {
        return ReflectionUtil.getSetter(ReflectionUtil.lookupField(clazz, type, offset));
    }

    public static MethodHandle getSetter(Field field) {
        try {
            if (Modifier.isStatic(field.getModifiers())) {
                return TRUSTED_LOOKUP.findStaticSetter(field.getDeclaringClass(), field.getName(), field.getType());
            }
            return TRUSTED_LOOKUP.findSetter(field.getDeclaringClass(), field.getName(), field.getType());
        }
        catch (ReflectiveOperationException exception) {
            throw new RuntimeException(exception);
        }
    }

    private static Method lookupMethod(Class<?> clazz, MethodType methodType, int offset) {
        int i = 0;
        for (Method method : clazz.getDeclaredMethods()) {
            if (method.getReturnType() != methodType.returnType() || method.getParameterCount() != methodType.parameterCount() || !Arrays.equals(method.getParameterTypes(), methodType.parameterArray()) || i++ != offset) continue;
            return method;
        }
        throw new IllegalArgumentException("Can't find method " + String.valueOf(methodType) + " with offset " + offset + " in " + clazz.getName());
    }

    private static Field lookupField(Class<?> clazz, Class<?> type, int offset) {
        int i = 0;
        for (Field field : clazz.getDeclaredFields()) {
            if (field.getType() != type || i++ != offset) continue;
            return field;
        }
        throw new IllegalArgumentException("Can't find field " + String.valueOf(type) + " with offset " + offset + " in " + clazz.getName());
    }

    static {
        Unsafe unsafe = null;
        for (Field field : Unsafe.class.getDeclaredFields()) {
            if (field.getType() != Unsafe.class) continue;
            try {
                field.trySetAccessible();
                unsafe = (Unsafe)field.get(null);
                break;
            }
            catch (ReflectiveOperationException exception) {
                throw new RuntimeException(exception);
            }
        }
        THE_UNSAFE = Objects.requireNonNull(unsafe, "Can't find unsafe instance");
        try {
            MethodHandles.lookup();
            Field implLookupField = MethodHandles.Lookup.class.getDeclaredField("IMPL_LOOKUP");
            long implLookupFieldOffset = THE_UNSAFE.staticFieldOffset(implLookupField);
            TRUSTED_LOOKUP = (MethodHandles.Lookup)THE_UNSAFE.getObject(MethodHandles.Lookup.class, implLookupFieldOffset);
        }
        catch (ReflectiveOperationException exception) {
            throw new RuntimeException(exception);
        }
    }
}

