/*
 * Decompiled with CFR 0.152.
 */
package dev.booky.betterview.common.config.loading;

import io.leangen.geantyref.TypeToken;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Objects;
import java.util.function.Supplier;
import org.jspecify.annotations.NullMarked;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.ScopedConfigurationNode;
import org.spongepowered.configurate.loader.AbstractConfigurationLoader;
import org.spongepowered.configurate.serialize.TypeSerializerCollection;
import org.spongepowered.configurate.yaml.NodeStyle;
import org.spongepowered.configurate.yaml.YamlConfigurationLoader;

@NullMarked
public final class ConfigurateLoader {
    private ConfigurateLoader() {
    }

    private static AbstractConfigurationLoader.Builder<?, ?> constructYamlLoader() {
        return YamlConfigurationLoader.builder().indent(2).nodeStyle(NodeStyle.BLOCK);
    }

    private static AbstractConfigurationLoader<?> buildLoader(AbstractConfigurationLoader.Builder<?, ?> loader, TypeSerializerCollection serializers, Path configPath) {
        return loader.path(configPath).defaultOptions(opts -> opts.serializers(builder -> builder.registerAll(serializers))).build();
    }

    public static <T> T loadYaml(TypeSerializerCollection serializers, Path configPath, TypeToken<T> configType, Supplier<T> constructor) {
        return ConfigurateLoader.load(ConfigurateLoader.constructYamlLoader(), serializers, configPath, configType, constructor);
    }

    public static <T> T load(AbstractConfigurationLoader.Builder<?, ?> loader, TypeSerializerCollection serializers, Path configPath, TypeToken<T> configType, Supplier<T> constructor) {
        AbstractConfigurationLoader<?> builtLoader = ConfigurateLoader.buildLoader(loader, serializers, configPath);
        try {
            ScopedConfigurationNode node = (ScopedConfigurationNode)builtLoader.load();
            return (T)Objects.requireNonNullElseGet(node.get(configType), constructor);
        }
        catch (IOException exception) {
            throw new RuntimeException("Error while loading config " + String.valueOf(configType.getType()) + " from " + String.valueOf(configPath), exception);
        }
    }

    public static <T> void saveYaml(TypeSerializerCollection serializers, Path configPath, TypeToken<T> configType, T config) {
        ConfigurateLoader.save(ConfigurateLoader.constructYamlLoader(), serializers, configPath, configType, config);
    }

    public static <T> void save(AbstractConfigurationLoader.Builder<?, ?> loader, TypeSerializerCollection serializers, Path configPath, TypeToken<T> configType, T config) {
        AbstractConfigurationLoader<?> builtLoader = ConfigurateLoader.buildLoader(loader, serializers, configPath);
        ScopedConfigurationNode node = (ScopedConfigurationNode)builtLoader.createNode();
        try {
            node.set(configType, config);
            builtLoader.save((ConfigurationNode)node);
        }
        catch (IOException exception) {
            throw new RuntimeException("Error while saving config " + String.valueOf(configType) + " to " + String.valueOf(configPath), exception);
        }
    }
}

