/*
 * Decompiled with CFR 0.152.
 */
package dev.booky.betterview.common;

import dev.booky.betterview.common.hooks.LevelHook;
import dev.booky.betterview.common.util.McChunkPos;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.util.ReferenceCountUtil;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public final class ChunkCacheEntry {
    private final LevelHook level;
    private final McChunkPos pos;
    private volatile @Nullable CompletableFuture<@Nullable ByteBuf> future;
    private volatile boolean released = false;

    public ChunkCacheEntry(LevelHook level, McChunkPos pos) {
        this.level = level;
        this.pos = pos;
    }

    private CompletableFuture<@Nullable ByteBuf> tryGet() {
        LevelHook level = this.level;
        McChunkPos pos = this.pos;
        return level.getCachedChunkBuf(pos).thenCompose(chunkBuf -> {
            if (chunkBuf != null) {
                return CompletableFuture.completedFuture(chunkBuf);
            }
            return level.readChunk(pos).thenCompose(chunkTag -> {
                if (chunkTag != null && chunkTag.buffer() != null) {
                    return CompletableFuture.completedFuture(chunkTag.buffer());
                }
                if (chunkTag == null && level.isVoidWorld()) {
                    return CompletableFuture.completedFuture(Unpooled.EMPTY_BUFFER);
                }
                if (!level.checkChunkGeneration()) {
                    return CompletableFuture.completedFuture(null);
                }
                return level.loadChunk(pos.getX(), pos.getZ());
            });
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<@Nullable ByteBuf> get() {
        ChunkCacheEntry chunkCacheEntry = this;
        synchronized (chunkCacheEntry) {
            if (this.released) {
                throw new IllegalStateException("Can't get buffer for " + String.valueOf(this.pos) + " in " + String.valueOf(this.level.getName()) + ", cache entry has already been released");
            }
            CompletionStage<@Nullable Object> future = this.future;
            if (future != null) {
                return future;
            }
            this.future = future = ((CompletableFuture)CompletableFuture.completedFuture(null).thenComposeAsync(__ -> this.tryGet())).thenApply(buf -> {
                if (buf == null) {
                    ChunkCacheEntry chunkCacheEntry = this;
                    synchronized (chunkCacheEntry) {
                        this.future = null;
                    }
                }
                return buf;
            });
            return future;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        ChunkCacheEntry chunkCacheEntry = this;
        synchronized (chunkCacheEntry) {
            CompletableFuture<@Nullable ByteBuf> future = this.future;
            if (future != null) {
                future.thenAccept(ReferenceCountUtil::release);
            }
            this.future = null;
            this.released = true;
        }
    }
}

