/*
 * Decompiled with CFR 0.152.
 */
package dev.booky.betterview.common;

import dev.booky.betterview.common.hooks.LevelHook;
import dev.booky.betterview.common.hooks.PlayerHook;
import dev.booky.betterview.common.util.BetterViewUtil;
import dev.booky.betterview.common.util.BypassedPacket;
import dev.booky.betterview.common.util.ChunkIterationUtil;
import dev.booky.betterview.common.util.McChunkPos;
import io.netty.buffer.ByteBuf;
import io.netty.util.ReferenceCountUtil;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NullMarked
public final class BetterViewPlayer {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"BetterView");
    private static final long[] EMPTY_LONG_ARRAY = new long[0];
    private static final ChunkState[] EMPTY_CHUNK_STATE_ARRAY = new ChunkState[0];
    private Object networkDimension;
    public long[] chunksInDistance = EMPTY_LONG_ARRAY;
    public int iterationIndex;
    public ChunkState[] chunkStates = EMPTY_CHUNK_STATE_ARRAY;
    public PlayerHook player;
    public LevelHook level;
    public McChunkPos chunkPos;
    public final Queue<ChunkQueueEntry> chunkQueue = new ArrayDeque<ChunkQueueEntry>();
    public int distance;
    public int storageRadius;
    public int storageDiameter;
    public boolean enabled = false;
    public boolean initiated = false;

    public BetterViewPlayer(PlayerHook player) {
        this.player = player;
        this.level = player.getLevel();
        this.chunkPos = player.getChunkPos();
        this.networkDimension = this.level.dimension();
    }

    private static int calcIndex(int chunkX, int chunkZ, int storageDiameter) {
        return Math.floorMod(chunkX, storageDiameter) * storageDiameter + Math.floorMod(chunkZ, storageDiameter);
    }

    private boolean canStore(int chunkX, int chunkZ) {
        return Math.abs(chunkX - this.chunkPos.getX()) <= this.storageRadius && Math.abs(chunkZ - this.chunkPos.getZ()) <= this.storageRadius;
    }

    public void replacePlayer(PlayerHook player) {
        this.player = player;
    }

    private boolean canBeActivated(int clientDistance) {
        if (!this.initiated || !this.level.getConfig().isEnabled()) {
            return false;
        }
        if (clientDistance < 1) {
            return false;
        }
        return this.getServerViewDistance() < clientDistance;
    }

    public void tryTriggerStart() {
        if (!this.initiated) {
            this.chunkPos = this.player.getChunkPos();
            this.initiated = true;
        }
    }

    public void serverChunkAdd(int chunkX, int chunkZ) {
        if (!this.canStore(chunkX, chunkZ)) {
            LOGGER.error("Can't store server chunk {} {} state for {} at {} in {} with distance {}", new Object[]{chunkX, chunkZ, this.player, this.chunkPos, this.level, this.distance});
            return;
        }
        int chunkIndex = BetterViewPlayer.calcIndex(chunkX, chunkZ, this.storageDiameter);
        ChunkState state = this.chunkStates[chunkIndex];
        if (state.lifecycle == ChunkLifecycle.BV_QUEUED) {
            this.purgeQueue(chunkX, chunkZ);
        }
        state.set(chunkX, chunkZ, ChunkLifecycle.SERVER_LOADED);
    }

    public boolean serverChunkRemove(int chunkX, int chunkZ) {
        boolean insideCylinder = BetterViewUtil.isWithinRange(chunkX - this.chunkPos.getX(), chunkZ - this.chunkPos.getZ(), this.distance);
        if (!insideCylinder) {
            if (this.canStore(chunkX, chunkZ)) {
                int chunkIndex = BetterViewPlayer.calcIndex(chunkX, chunkZ, this.storageDiameter);
                this.chunkStates[chunkIndex].set(chunkX, chunkZ, ChunkLifecycle.UNLOADED);
            }
            return false;
        }
        int chunkIndex = BetterViewPlayer.calcIndex(chunkX, chunkZ, this.storageDiameter);
        this.chunkStates[chunkIndex].set(chunkX, chunkZ, ChunkLifecycle.BV_LOADED);
        return true;
    }

    public int getServerViewDistance() {
        return this.player.getSendViewDistance();
    }

    public int getClientViewDistance() {
        int requestedDistance = this.player.getRequestedViewDistance();
        int betterViewDistance = this.level.getConfig().getViewDistance();
        return Math.min(requestedDistance, betterViewDistance);
    }

    public void updateDistance(int newDistance) {
        this.distance = newDistance;
        this.storageRadius = Math.max(2, newDistance) + 3;
        this.storageDiameter = this.storageRadius * 2 + 1;
        this.chunksInDistance = ChunkIterationUtil.RADIUS_ITERATION_LIST[newDistance];
        this.iterationIndex = 0;
        ChunkState[] prevStates = this.chunkStates;
        int storageDiameter = this.storageDiameter;
        if (prevStates.length != storageDiameter * storageDiameter) {
            @MonotonicNonNull ChunkState[] newStates = new ChunkState[storageDiameter * storageDiameter];
            for (ChunkState state : prevStates) {
                if (!state.hasCoords() || !this.canStore(state.chunkX, state.chunkZ)) continue;
                int chunkIndex = BetterViewPlayer.calcIndex(state.chunkX, state.chunkZ, storageDiameter);
                newStates[chunkIndex] = state;
            }
            int len = storageDiameter * storageDiameter;
            for (int i = 0; i < len; ++i) {
                if (newStates[i] != null) continue;
                newStates[i] = new ChunkState();
            }
            this.chunkStates = newStates;
        }
        this.player.sendViewDistancePacket(newDistance);
    }

    public void move(LevelHook newLevel, McChunkPos newPos) {
        if (newLevel != this.level) {
            this.level = newLevel;
            if (this.enabled) {
                this.handleDimensionReset(null);
            }
            return;
        }
        McChunkPos previousPos = this.chunkPos;
        if (newPos.getKey() == previousPos.getKey()) {
            return;
        }
        this.chunkPos = newPos;
        this.iterationIndex = 0;
        if (this.enabled) {
            if (previousPos.distanceSquared(newPos) > this.distance * this.distance) {
                this.unloadBvChunks();
                this.disable();
                return;
            }
            int centerX = this.chunkPos.getX();
            int centerZ = this.chunkPos.getZ();
            for (ChunkState state : this.chunkStates) {
                int chunkZ;
                int chunkX;
                boolean keepLoaded;
                if (!state.hasCoords() || (keepLoaded = BetterViewUtil.isWithinRange((chunkX = state.chunkX) - centerX, (chunkZ = state.chunkZ) - centerZ, this.distance)) || !state.hasCoords()) continue;
                ChunkLifecycle lifecycle = state.lifecycle;
                state.set(0, 0, ChunkLifecycle.UNLOADED);
                if (lifecycle == ChunkLifecycle.BV_LOADED) {
                    this.player.sendChunkUnload(chunkX, chunkZ);
                    continue;
                }
                if (lifecycle != ChunkLifecycle.BV_QUEUED) continue;
                this.purgeQueue(chunkX, chunkZ);
            }
        }
    }

    public @Nullable McChunkPos pollChunkPos() {
        int centerX = this.chunkPos.getX();
        int centerZ = this.chunkPos.getZ();
        while (this.iterationIndex < this.chunksInDistance.length) {
            long chunkPos = this.chunksInDistance[this.iterationIndex++];
            int chunkX = McChunkPos.getChunkX(chunkPos) + centerX;
            int chunkZ = McChunkPos.getChunkZ(chunkPos) + centerZ;
            int chunkIndex = BetterViewPlayer.calcIndex(chunkX, chunkZ, this.storageDiameter);
            ChunkState state = this.chunkStates[chunkIndex];
            if (state.lifecycle != ChunkLifecycle.UNLOADED || chunkX < -480000000 || chunkX > 480000000 || chunkZ < -480000000 || chunkZ > 480000000) continue;
            state.set(chunkX, chunkZ, ChunkLifecycle.BV_QUEUED);
            return new McChunkPos(chunkX, chunkZ);
        }
        this.iterationIndex = 0;
        return null;
    }

    public void purgeQueue(int chunkX, int chunkZ) {
        this.chunkQueue.removeIf(entry -> {
            if (entry.chunkPos.getX() == chunkX && entry.chunkPos.getZ() == chunkZ) {
                entry.release();
                return true;
            }
            return false;
        });
    }

    public boolean checkQueueEntry(ChunkQueueEntry entry) {
        if (!entry.future.isDone()) {
            return false;
        }
        McChunkPos chunkPos = entry.chunkPos;
        int chunkIndex = BetterViewPlayer.calcIndex(chunkPos.getX(), chunkPos.getZ(), this.storageDiameter);
        ChunkState state = this.chunkStates[chunkIndex];
        if (state.lifecycle != ChunkLifecycle.BV_QUEUED) {
            entry.release();
            return true;
        }
        if (entry.future.isCompletedExceptionally()) {
            Throwable exception = entry.future.exceptionNow();
            LOGGER.error("Error while building chunk {} for {} in {}", new Object[]{chunkPos, this.player, this.level, exception});
            state.lifecycle = ChunkLifecycle.UNLOADED;
            entry.release();
            return true;
        }
        ByteBuf chunkBuf = entry.future.getNow(null);
        if (chunkBuf == null) {
            state.lifecycle = ChunkLifecycle.UNLOADED;
            this.iterationIndex = 0;
            entry.release();
            return true;
        }
        ByteBuf finalChunkBuf = chunkBuf.isReadable() ? chunkBuf.retainedSlice() : this.level.getEmptyChunkBuf(chunkPos);
        this.player.getNettyChannel().write((Object)new BypassedPacket(finalChunkBuf));
        state.lifecycle = ChunkLifecycle.BV_LOADED;
        entry.release();
        return true;
    }

    public void unloadBvChunks() {
        int centerX = this.chunkPos.getX();
        int centerZ = this.chunkPos.getZ();
        for (long chunkKeyOff : this.chunksInDistance) {
            int chunkX = McChunkPos.getChunkX(chunkKeyOff) + centerX;
            int chunkZ = McChunkPos.getChunkZ(chunkKeyOff) + centerZ;
            int chunkIndex = BetterViewPlayer.calcIndex(chunkX, chunkZ, this.storageDiameter);
            ChunkState state = this.chunkStates[chunkIndex];
            ChunkLifecycle lifecycle = state.lifecycle;
            if (lifecycle != ChunkLifecycle.BV_LOADED && lifecycle != ChunkLifecycle.BV_QUEUED) continue;
            if (lifecycle == ChunkLifecycle.BV_LOADED) {
                this.player.sendChunkUnload(chunkX, chunkZ);
            }
            state.lifecycle = ChunkLifecycle.UNLOADED;
        }
        this.clearChunkQueue();
    }

    public void handleDimensionReset(@Nullable Object networkDimension) {
        if (networkDimension != null) {
            if (this.networkDimension.equals(networkDimension)) {
                return;
            }
            this.networkDimension = networkDimension;
        }
        int len = this.chunkStates.length;
        for (int i = 0; i < len; ++i) {
            this.chunkStates[i].set(0, 0, ChunkLifecycle.UNLOADED);
        }
        this.clearChunkQueue();
        this.disable();
    }

    public boolean preTick() {
        int clientDistance = this.getClientViewDistance();
        if (this.enabled) {
            boolean valid = this.player.isValid();
            if (this.distance == clientDistance && valid) {
                return true;
            }
            if (!this.canBeActivated(clientDistance)) {
                this.unloadBvChunks();
                this.disable();
                return false;
            }
            if (!valid) {
                return false;
            }
            this.updateDistance(clientDistance);
        }
        if (!this.canBeActivated(clientDistance)) {
            return false;
        }
        this.enable(clientDistance);
        return true;
    }

    public void enable(int clientDistance) {
        if (!this.enabled) {
            this.enabled = true;
            this.updateDistance(clientDistance);
        }
    }

    public void disable() {
        if (!this.enabled) {
            return;
        }
        this.enabled = false;
        this.player.sendViewDistancePacket(this.getServerViewDistance());
    }

    public void release() {
        this.clearChunkQueue();
    }

    public void clearChunkQueue() {
        for (ChunkQueueEntry entry : this.chunkQueue) {
            entry.release();
        }
        this.chunkQueue.clear();
    }

    public static final class ChunkState {
        private int chunkX;
        private int chunkZ;
        private ChunkLifecycle lifecycle = ChunkLifecycle.UNLOADED;

        public void set(int chunkX, int chunkZ, ChunkLifecycle lifecycle) {
            this.chunkX = chunkX;
            this.chunkZ = chunkZ;
            this.lifecycle = lifecycle;
        }

        public boolean hasCoords() {
            return this.lifecycle != ChunkLifecycle.UNLOADED || this.chunkX != 0 || this.chunkZ != 0;
        }
    }

    public static enum ChunkLifecycle {
        UNLOADED,
        SERVER_LOADED,
        BV_QUEUED,
        BV_LOADED;

    }

    public record ChunkQueueEntry(McChunkPos chunkPos, CompletableFuture<@Nullable ByteBuf> future) {
        public ChunkQueueEntry retain() {
            this.future.thenApply(ReferenceCountUtil::retain);
            return this;
        }

        public ChunkQueueEntry release() {
            this.future.thenApply(ReferenceCountUtil::release);
            return this;
        }
    }
}

