/*
 * Decompiled with CFR 0.152.
 */
package dev.booky.betterview;

import dev.booky.betterview.common.BetterViewManager;
import dev.booky.betterview.libs.bstats.bukkit.Metrics;
import dev.booky.betterview.listener.LevelListener;
import dev.booky.betterview.listener.PlayerListener;
import dev.booky.betterview.listener.TickListener;
import dev.booky.betterview.nms.PaperNmsInterface;
import dev.booky.betterview.platform.PaperBetterView;
import java.nio.file.Path;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class BetterViewPlugin
extends JavaPlugin {
    private final BetterViewManager manager;
    private @MonotonicNonNull NamespacedKey listenerKey;

    public BetterViewPlugin() {
        Path configPath = this.getDataPath().resolve("config.yml");
        this.manager = new BetterViewManager(PaperBetterView::new, configPath);
    }

    public void onLoad() {
        this.listenerKey = new NamespacedKey((Plugin)this, "packets");
        new Metrics((Plugin)this, 26105);
    }

    public void onEnable() {
        Bukkit.getPluginManager().registerEvents((Listener)new LevelListener(this.manager), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new PlayerListener(this.manager), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new TickListener(this.manager), (Plugin)this);
        PaperNmsInterface.SERVICE.injectPacketHandler(this.manager, this.listenerKey);
        Bukkit.getScheduler().runTask((Plugin)this, this.manager::onPostLoad);
    }

    public void onDisable() {
        PaperNmsInterface.SERVICE.uninjectPacketHandler(this.listenerKey);
    }
}

