/*
 * Decompiled with CFR 0.152.
 */
package xyz.hynse.foliaflow;

import io.papermc.paper.threadedregions.scheduler.GlobalRegionScheduler;
import io.papermc.paper.threadedregions.scheduler.RegionScheduler;
import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Slab;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.FallingBlock;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.util.Vector;

public class FoliaFlow
extends JavaPlugin
implements Listener {
    private final double vh = 0.2;
    private final double vt = 0.8;
    private final Vector velocity1 = new Vector(0.0, 0.2, 0.8);
    private final Vector velocity2 = new Vector(0.8, 0.2, 0.0);
    private final Vector velocity3 = new Vector(0.0, 0.2, -0.8);
    private final Vector velocity4 = new Vector(-0.8, 0.2, 0.0);
    private final Vector[] velocities = new Vector[]{this.velocity1, this.velocity2, this.velocity3, this.velocity4};
    private int counter = 0;
    private final Set<Location> movingBlocks = new HashSet<Location>();
    private final Map<Entity, Vector> velocitiesMap = new HashMap<Entity, Vector>();
    private ScheduledTask task;
    private ScheduledTask blockktask;
    private boolean blockCreated = false;

    public void onEnable() {
        super.onEnable();
        RegionScheduler schedulerblock = this.getServer().getRegionScheduler();
        this.blockktask = schedulerblock.runAtFixedRate((Plugin)this, Objects.requireNonNull(Bukkit.getWorld((String)"world_the_end")), 1, 1, schedulerTask -> {
            Block block = Objects.requireNonNull(Bukkit.getWorld((String)"world_the_end")).getBlockAt(100, 48, 0);
            if (block.getType() == Material.OBSIDIAN) {
                block.setType(Material.COBBLED_DEEPSLATE_SLAB);
                Slab slab = (Slab)block.getBlockData();
                slab.setType(Slab.Type.BOTTOM);
                block.setBlockData((BlockData)slab);
            }
        }, 1L, 1L);
        GlobalRegionScheduler scheduler = this.getServer().getGlobalRegionScheduler();
        this.task = scheduler.runAtFixedRate((Plugin)this, scheduledTask -> {
            for (World world : Bukkit.getWorlds()) {
                for (Entity entity : world.getEntities()) {
                    if (entity.getType() != EntityType.FALLING_BLOCK || entity.getWorld().getEnvironment() != World.Environment.THE_END) continue;
                    Location centerLoc = new Location(entity.getWorld(), 100.0, 48.5, 0.0);
                    Location loc = entity.getLocation();
                    if (!(loc.distance(centerLoc) <= 1.0) || this.velocitiesMap.containsKey(entity)) continue;
                    int index = this.counter % 4;
                    ++this.counter;
                    Vector velocity = this.velocities[index];
                    entity.setVelocity(velocity);
                    this.velocitiesMap.put(entity, velocity);
                    this.movingBlocks.add(entity.getLocation());
                }
            }
        }, 20L, 1L);
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
    }

    public void onDisable() {
        super.onDisable();
    }

    @EventHandler
    public void onFallingBlockToBlock(EntityChangeBlockEvent e) {
        if (e.getEntityType() == EntityType.FALLING_BLOCK) {
            Entity entity = e.getEntity();
            Location loc = entity.getLocation();
            Vector vel = entity.getVelocity();
            Block movingTo = this.getBlockMovingTo(loc, vel);
            try {
                if (movingTo != null && movingTo.getType() == Material.END_PORTAL) {
                    Location spawnLoc = movingTo.getLocation();
                    spawnLoc.setX(spawnLoc.getX() + 0.5);
                    spawnLoc.setY(spawnLoc.getY() - 0.25);
                    spawnLoc.setZ(spawnLoc.getZ() + 0.5);
                    FallingBlock dummy = loc.getWorld().spawnFallingBlock(spawnLoc, ((FallingBlock)entity).getBlockData());
                    dummy.setDropItem(true);
                    dummy.setHurtEntities(true);
                    dummy.setGravity(true);
                    Vector dummyVel = vel.clone();
                    dummyVel.setY(-dummyVel.getY());
                    dummyVel.multiply(new Vector(2, 1, 2));
                    dummyVel.add(new Vector(0, 1, 0));
                    dummy.setVelocity(dummyVel);
                }
            }
            catch (NullPointerException dummy) {
                this.getServer().getLogger().info("onFallingBlockToBlock error (likly chunky it not load)");
            }
        }
    }

    Block getBlockMovingTo(Location loc, Vector vel) {
        double absMax = 0.0;
        double max = 0.0;
        int dir = 32;
        Block relative = null;
        if (Math.abs(vel.getX()) > absMax) {
            max = vel.getX();
            absMax = Math.abs(vel.getX());
            dir = 120;
        }
        if (Math.abs(vel.getY()) > absMax) {
            max = vel.getY();
            absMax = Math.abs(vel.getY());
            dir = 121;
        }
        if (Math.abs(vel.getZ()) > absMax) {
            max = vel.getZ();
            dir = 122;
        }
        switch (dir) {
            case 120: {
                relative = loc.getBlock().getRelative((int)Math.signum(max), 0, 0);
                break;
            }
            case 121: {
                relative = loc.getBlock().getRelative(0, (int)Math.signum(max), 0);
                break;
            }
            case 122: {
                relative = loc.getBlock().getRelative(0, 0, (int)Math.signum(max));
            }
        }
        return relative;
    }
}

