/*
 * Decompiled with CFR 0.152.
 */
package io.github._4drian3d.unsignedvelocity.listener.packet.chat;

import com.github.retrooper.packetevents.event.PacketListenerAbstract;
import com.github.retrooper.packetevents.event.PacketListenerPriority;
import com.github.retrooper.packetevents.event.PacketSendEvent;
import com.github.retrooper.packetevents.protocol.chat.message.ChatMessage;
import com.github.retrooper.packetevents.protocol.chat.message.ChatMessage_v1_19;
import com.github.retrooper.packetevents.protocol.chat.message.ChatMessage_v1_19_1;
import com.github.retrooper.packetevents.protocol.chat.message.ChatMessage_v1_19_3;
import com.github.retrooper.packetevents.protocol.packettype.PacketType;
import com.github.retrooper.packetevents.protocol.packettype.PacketTypeCommon;
import com.github.retrooper.packetevents.protocol.player.ClientVersion;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerChatMessage;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerSystemChatMessage;
import com.google.inject.Inject;
import io.github._4drian3d.unsignedvelocity.UnSignedVelocity;
import io.github._4drian3d.unsignedvelocity.listener.LoadablePacketListener;
import java.util.Optional;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.Nullable;

public final class ServerChatListener
extends PacketListenerAbstract
implements LoadablePacketListener {
    private final UnSignedVelocity plugin;

    @Inject
    public ServerChatListener(UnSignedVelocity plugin) {
        super(PacketListenerPriority.LOWEST);
        this.plugin = plugin;
    }

    @Override
    public boolean canBeLoaded() {
        return this.plugin.getConfiguration().convertPlayerChatToSystemChat();
    }

    public void onPacketSend(PacketSendEvent event) {
        if (event.isCancelled()) {
            return;
        }
        PacketTypeCommon packetType = event.getPacketType();
        if (packetType == PacketType.Play.Server.CHAT_MESSAGE) {
            if (event.getUser().getClientVersion().isOlderThan(ClientVersion.V_1_19)) {
                return;
            }
            Component messageContent = ServerChatListener.getComponentFromChatPacket(event);
            WrapperPlayServerSystemChatMessage newPacket = new WrapperPlayServerSystemChatMessage(false, messageContent);
            event.getUser().sendPacketSilently((PacketWrapper)newPacket);
            event.setCancelled(true);
        }
    }

    @Nullable
    private static Component getComponentFromChatPacket(PacketSendEvent event) {
        Optional unsignedChatContent;
        WrapperPlayServerChatMessage packet = new WrapperPlayServerChatMessage(event);
        ChatMessage chatMessage = packet.getMessage();
        Component messageContent = chatMessage.getChatContent();
        if (chatMessage instanceof ChatMessage_v1_19) {
            messageContent = ((ChatMessage_v1_19)chatMessage).getUnsignedChatContent();
        } else if (chatMessage instanceof ChatMessage_v1_19_1) {
            messageContent = ((ChatMessage_v1_19_1)chatMessage).getUnsignedChatContent();
        } else if (chatMessage instanceof ChatMessage_v1_19_3 && (unsignedChatContent = ((ChatMessage_v1_19_3)chatMessage).getUnsignedChatContent()).isPresent()) {
            messageContent = (Component)unsignedChatContent.get();
        }
        return messageContent;
    }
}

