/*
 * Decompiled with CFR 0.152.
 */
package io.github._4drian3d.unsignedvelocity.configuration;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import org.spongepowered.configurate.CommentedConfigurationNode;
import org.spongepowered.configurate.hocon.HoconConfigurationLoader;
import org.spongepowered.configurate.objectmapping.ConfigSerializable;

@ConfigSerializable
public record Configuration(boolean removeSignedKeyOnJoin, boolean removeSignedCommandInformation, boolean applyChatMessages, boolean convertPlayerChatToSystemChat, boolean blockChatHeaderPackets, boolean blockChatSessionPackets, boolean sendSecureChatData, boolean sendSafeServerStatus) {
    public static Configuration loadConfig(Path path) throws IOException {
        Path configPath = Configuration.loadFiles(path);
        HoconConfigurationLoader loader = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().path(configPath)).build();
        CommentedConfigurationNode loaded = (CommentedConfigurationNode)loader.load();
        return (Configuration)loaded.get(Configuration.class);
    }

    private static Path loadFiles(Path path) throws IOException {
        Path configPath;
        if (Files.notExists(path, new LinkOption[0])) {
            Files.createDirectory(path, new FileAttribute[0]);
        }
        if (Files.notExists(configPath = path.resolve("config.conf"), new LinkOption[0])) {
            try (InputStream stream = Configuration.class.getClassLoader().getResourceAsStream("config.conf");){
                Files.copy(Objects.requireNonNull(stream), configPath, new CopyOption[0]);
            }
        }
        return configPath;
    }
}

