/*
 * Decompiled with CFR 0.152.
 */
package io.github._4drian3d.unsignedvelocity;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.event.PacketListenerAbstract;
import com.github.retrooper.packetevents.event.PacketListenerCommon;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.velocitypowered.api.command.Command;
import com.velocitypowered.api.command.CommandManager;
import com.velocitypowered.api.command.CommandMeta;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.plugin.Dependency;
import com.velocitypowered.api.plugin.Plugin;
import com.velocitypowered.api.plugin.annotation.DataDirectory;
import com.velocitypowered.api.proxy.ProxyServer;
import com.velocitypowered.proxy.VelocityServer;
import com.velocitypowered.proxy.config.VelocityConfiguration;
import io.github._4drian3d.unsignedvelocity.commands.UnSignedVelocityCommand;
import io.github._4drian3d.unsignedvelocity.configuration.Configuration;
import io.github._4drian3d.unsignedvelocity.libs.bstats.velocity.Metrics;
import io.github._4drian3d.unsignedvelocity.listener.LoadablePacketListener;
import io.github._4drian3d.unsignedvelocity.listener.packet.chat.ChatHeaderListener;
import io.github._4drian3d.unsignedvelocity.listener.packet.chat.ChatSessionListener;
import io.github._4drian3d.unsignedvelocity.listener.packet.chat.ClientChatListener;
import io.github._4drian3d.unsignedvelocity.listener.packet.chat.ServerChatListener;
import io.github._4drian3d.unsignedvelocity.listener.packet.command.CommandListener;
import io.github._4drian3d.unsignedvelocity.listener.packet.data.ServerDataListener;
import io.github._4drian3d.unsignedvelocity.listener.packet.login.LoginListener;
import io.github._4drian3d.unsignedvelocity.listener.packet.status.ServerResponseListener;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.InaccessibleObjectException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Stream;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.logger.slf4j.ComponentLogger;
import net.kyori.adventure.text.minimessage.MiniMessage;

@Plugin(id="unsignedvelocity", name="UnSignedVelocity", authors={"4drian3d"}, version="2.1.0", dependencies={@Dependency(id="packetevents")})
public class UnSignedVelocity {
    private final ProxyServer server;
    private final Injector injector;
    private final Path dataDirectory;
    private final Metrics.Factory factory;
    private final ComponentLogger logger;
    private Configuration configuration;
    private List<? extends LoadablePacketListener> packetListeners;

    @Inject
    public UnSignedVelocity(ProxyServer server, Injector injector, @DataDirectory Path dataDirectory, Metrics.Factory factory, ComponentLogger logger) {
        this.server = server;
        this.injector = injector;
        this.dataDirectory = dataDirectory;
        this.factory = factory;
        this.logger = logger;
    }

    @Subscribe
    public void onProxyInitialize(ProxyInitializeEvent event) {
        this.factory.make(this, 17514);
        if (!this.setupConfiguration()) {
            return;
        }
        if (this.configuration.removeSignedKeyOnJoin()) {
            try {
                VelocityConfiguration velocityConfiguration = ((VelocityServer)this.server).getConfiguration();
                Field forceKeyAuthenticationField = velocityConfiguration.getClass().getDeclaredField("forceKeyAuthentication");
                forceKeyAuthenticationField.setAccessible(true);
                boolean forceKeyAuthenticationValue = (Boolean)forceKeyAuthenticationField.get(velocityConfiguration);
                if (forceKeyAuthenticationValue) {
                    this.logger.warn("WARN: The 'force-key-authentication' option in the Velocity configuration file (velocity.toml) is set to 'true'.");
                    this.logger.warn("UnSignedVelocity requires that option to be set to 'false', so it will try to set it to 'true' forcefully at runtime.");
                    this.logger.warn("If you want to hide this warning, set 'force-key-authentication' to 'false' in Velocity settings and restart the proxy.");
                    this.logger.warn("Trying to set 'force-key-authentication' to false...");
                    forceKeyAuthenticationField.setBoolean(velocityConfiguration, false);
                    forceKeyAuthenticationField.setAccessible(false);
                    this.logger.warn("The 'force-key-authentication' field was found and set to false at runtime (this doesn't modify velocity.toml file).");
                }
            }
            catch (NoSuchFieldException e) {
                this.logger.error("The plugin cannot find 'force-key-authentication' option field, 'remove-signed-key-on-join' option will not work. Contact the developer of this plugin.", (Throwable)e);
            }
            catch (ExceptionInInitializerError | IllegalAccessException | IllegalArgumentException | NullPointerException | SecurityException | InaccessibleObjectException e) {
                this.logger.error("The plugin cannot access 'force-key-authentication' option field, 'remove-signed-key-on-join' option will not work. If setting 'force-key-authentication' to 'false' manually and restarting the proxy doesn't work, contact the developer of this plugin.", e);
            }
        }
        this.setupLoadablePacketListeners();
        CommandManager commandManager = this.server.getCommandManager();
        CommandMeta commandMeta = commandManager.metaBuilder("unsignedvelocity").plugin((Object)this).build();
        this.server.getCommandManager().register(commandMeta, (Command)UnSignedVelocityCommand.createBrigadierCommand(this));
        this.logger.info(MiniMessage.miniMessage().deserialize((Object)"<gradient:#166D3B:#7F8C8D:#A29BFE>UnSignedVelocity</gradient> <#6892bd>has been successfully loaded"));
        this.getPluginStatus(this.configuration).forEach(arg_0 -> ((ComponentLogger)this.logger).info(arg_0));
        try {
            String latestVersion = UnSignedVelocity.getLatestVersion();
            if (UnSignedVelocity.isUpdateAvailable(latestVersion)) {
                System.out.println("There is an update available for UnSignedVelocity: " + latestVersion);
            } else {
                this.logger.info(MiniMessage.miniMessage().deserialize((Object)"<#6892bd>You are using the latest version of <gradient:#166D3B:#7F8C8D:#A29BFE>UnSignedVelocity</gradient>"));
            }
        }
        catch (Exception e) {
            this.logger.error("Cannot check for updates", (Throwable)e);
        }
    }

    public boolean setupConfiguration() {
        try {
            this.configuration = Configuration.loadConfig(this.dataDirectory);
            return true;
        }
        catch (IOException e) {
            this.logger.error("Cannot load configuration", (Throwable)e);
            return false;
        }
    }

    public void setupLoadablePacketListeners() {
        if (this.packetListeners != null && !this.packetListeners.isEmpty()) {
            for (LoadablePacketListener loadablePacketListener : this.packetListeners) {
                PacketEvents.getAPI().getEventManager().unregisterListener((PacketListenerCommon)loadablePacketListener);
            }
        }
        List<PacketListenerAbstract> packetListeners = Stream.of(LoginListener.class, CommandListener.class, ClientChatListener.class, ServerChatListener.class, ChatHeaderListener.class, ChatSessionListener.class, ServerDataListener.class, ServerResponseListener.class).map(arg_0 -> ((Injector)this.injector).getInstance(arg_0)).filter(rec$ -> ((LoadablePacketListener)rec$).canBeLoaded()).toList();
        packetListeners.forEach(LoadablePacketListener::register);
        this.packetListeners = packetListeners;
    }

    public List<Component> getPluginStatus(Configuration configuration) {
        return List.of(MiniMessage.miniMessage().deserialize((Object)("<#6892bd>Remove Signed Key: <aqua>" + configuration.removeSignedKeyOnJoin())), MiniMessage.miniMessage().deserialize((Object)("<#6892bd>UnSigned <dark_gray>|</dark_gray> Commands: <aqua>" + configuration.removeSignedCommandInformation() + "</aqua> <dark_gray>|</dark_gray> Chat: <aqua>" + configuration.applyChatMessages())), MiniMessage.miniMessage().deserialize((Object)("<#6892bd>Convert Player Chat Messages to System Chat Messages: <aqua>" + configuration.convertPlayerChatToSystemChat())), MiniMessage.miniMessage().deserialize((Object)("<#6892bd>Block <dark_gray>|</dark_gray> <#6892bd>Chat Header Packets: <aqua>" + configuration.blockChatHeaderPackets() + "</aqua> <dark_gray>|</dark_gray> <#6892bd>Chat Session Packets: <aqua>" + configuration.blockChatSessionPackets() + "</aqua>")), MiniMessage.miniMessage().deserialize((Object)("<#6892bd>Secure Chat Data: <aqua>" + configuration.sendSecureChatData() + " <dark_gray>|</dark_gray> <#6892bd>Safe Server Status: <aqua>" + configuration.sendSafeServerStatus())));
    }

    private static String getLatestVersion() throws Exception {
        String url = "https://api.github.com/repos/MemencioPerez/UnSignedVelocity/releases/latest";
        HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Accept", "application/json");
        try (InputStreamReader reader = new InputStreamReader(connection.getInputStream());){
            JsonObject jsonObject = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            String string = jsonObject.get("tag_name").getAsString();
            return string;
        }
    }

    private static boolean isUpdateAvailable(String latestVersion) {
        return !"2.1.0".equals(latestVersion);
    }

    public ProxyServer getServer() {
        return this.server;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }
}

