/*
 * Decompiled with CFR 0.152.
 */
package me.max.power;

import java.util.HashMap;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class PowerPlugin
extends JavaPlugin
implements Listener {
    private final HashMap<UUID, String> playerAbilities = new HashMap();

    public void onEnable() {
        this.getLogger().info("\u041f\u043b\u0430\u0433\u0438\u043d Power \u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d!");
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getCommand("power").setExecutor((sender, command, label, args) -> {
            if (sender instanceof Player) {
                Player player = (Player)sender;
                if (args.length == 1) {
                    String ability = args[0].toLowerCase();
                    if (ability.equals("kiborg") || ability.equals("vegetarianism")) {
                        this.playerAbilities.put(player.getUniqueId(), ability);
                        player.sendMessage("\u00a7a\u0412\u044b \u0432\u044b\u0431\u0440\u0430\u043b\u0438 \u0441\u043f\u043e\u0441\u043e\u0431\u043d\u043e\u0441\u0442\u044c: " + ability);
                    } else {
                        player.sendMessage("\u00a7c\u041d\u0435\u0432\u0435\u0440\u043d\u0430\u044f \u0441\u043f\u043e\u0441\u043e\u0431\u043d\u043e\u0441\u0442\u044c! \u0414\u043e\u0441\u0442\u0443\u043f\u043d\u044b: kiborg, vegetarianism.");
                    }
                } else {
                    player.sendMessage("\u00a7c\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435: /power <\u0441\u043f\u043e\u0441\u043e\u0431\u043d\u043e\u0441\u0442\u044c>");
                }
            }
            return true;
        });
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        if ("kiborg".equals(this.playerAbilities.get(player.getUniqueId())) && event.getAction().name().contains("RIGHT_CLICK") && player.getInventory().getItemInMainHand().getType() == Material.AIR) {
            player.launchProjectile(Fireball.class);
            player.sendMessage("\u00a76\u0424\u0430\u0435\u0440\u0431\u043e\u043b \u0437\u0430\u043f\u0443\u0449\u0435\u043d!");
        }
    }

    @EventHandler
    public void onPlayerItemConsume(PlayerItemConsumeEvent event) {
        Player player = event.getPlayer();
        if ("vegetarianism".equals(this.playerAbilities.get(player.getUniqueId()))) {
            Material food = event.getItem().getType();
            if (this.isMeat(food)) {
                player.sendMessage("\u00a7c\u0412\u044b \u043d\u0435 \u043c\u043e\u0436\u0435\u0442\u0435 \u0435\u0441\u0442\u044c \u043c\u044f\u0441\u043e! \u0412\u0430\u0441 \u0442\u043e\u0448\u043d\u0438\u0442...");
                player.addPotionEffect(new PotionEffect(PotionEffectType.HUNGER, 200, 1));
                player.addPotionEffect(new PotionEffect(PotionEffectType.POISON, 60, 1));
            } else {
                player.sendMessage("\u00a7a\u0412\u044b \u043f\u043e\u043b\u0443\u0447\u0438\u043b\u0438 \u0440\u0435\u0433\u0435\u043d\u0435\u0440\u0430\u0446\u0438\u044e!");
                player.addPotionEffect(new PotionEffect(PotionEffectType.REGENERATION, 60, 0));
            }
        }
    }

    private boolean isMeat(Material food) {
        return food == Material.COOKED_BEEF || food == Material.COOKED_PORKCHOP || food == Material.COOKED_MUTTON || food == Material.COOKED_CHICKEN || food == Material.COOKED_SALMON || food == Material.COOKED_RABBIT || food == Material.COOKED_COD || food == Material.ROTTEN_FLESH || food == Material.BEEF || food == Material.RABBIT || food == Material.PORKCHOP || food == Material.CHICKEN || food == Material.COD || food == Material.SALMON || food == Material.MUTTON || food == Material.TROPICAL_FISH;
    }
}

