/*
 * Decompiled with CFR 0.152.
 */
package com.marcpg.pillarperil.player;

import java.util.Collection;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.kyori.adventure.text.Component;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.scoreboard.Scoreboard;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u001a\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u001c\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0099\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007\u0012\u000e\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007\u0012\u000e\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u000e\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\b\u0010\u0012\u001a\u0004\u0018\u00010\u0011\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u0012\u0006\u0010\u0017\u001a\u00020\u0018\u0012\u0006\u0010\u0019\u001a\u00020\u000e\u0012\u0006\u0010\u001a\u001a\u00020\f\u00a2\u0006\u0004\b\u001b\u0010\u001cB\u0011\b\u0016\u0012\u0006\u0010\u001d\u001a\u00020\u001e\u00a2\u0006\u0004\b\u001b\u0010\u001fJh\u00108\u001a\u0002092\u0006\u0010\u001d\u001a\u00020\u001e2\b\b\u0002\u0010:\u001a\u00020;2\b\b\u0002\u0010<\u001a\u00020;2\b\b\u0002\u0010=\u001a\u00020;2\b\b\u0002\u0010>\u001a\u00020;2\b\b\u0002\u0010?\u001a\u00020;2\b\b\u0002\u0010@\u001a\u00020;2\b\b\u0002\u0010A\u001a\u00020;2\b\b\u0002\u0010B\u001a\u00020;2\b\b\u0002\u0010C\u001a\u00020;J\t\u0010D\u001a\u00020\u0003H\u00c6\u0003J\t\u0010E\u001a\u00020\u0005H\u00c6\u0003J\u0011\u0010F\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007H\u00c6\u0003J\u0011\u0010G\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007H\u00c6\u0003J\u0011\u0010H\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007H\u00c6\u0003J\t\u0010I\u001a\u00020\fH\u00c6\u0003J\t\u0010J\u001a\u00020\u000eH\u00c6\u0003J\t\u0010K\u001a\u00020\u000eH\u00c6\u0003J\t\u0010L\u001a\u00020\u0011H\u00c6\u0003J\u000b\u0010M\u001a\u0004\u0018\u00010\u0011H\u00c6\u0003J\t\u0010N\u001a\u00020\u0014H\u00c6\u0003J\t\u0010O\u001a\u00020\u0016H\u00c6\u0003J\t\u0010P\u001a\u00020\u0018H\u00c6\u0003J\t\u0010Q\u001a\u00020\u000eH\u00c6\u0003J\t\u0010R\u001a\u00020\fH\u00c6\u0003J\u00b9\u0001\u0010S\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u0010\b\u0002\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00072\u0010\b\u0002\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00072\u0010\b\u0002\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00072\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u000e2\b\b\u0002\u0010\u0010\u001a\u00020\u00112\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u00112\b\b\u0002\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u00162\b\b\u0002\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\u0019\u001a\u00020\u000e2\b\b\u0002\u0010\u001a\u001a\u00020\fH\u00c6\u0001J\u0013\u0010T\u001a\u00020;2\b\u0010U\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010V\u001a\u00020\u000eH\u00d6\u0001J\t\u0010W\u001a\u00020XH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0019\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0019\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010%R\u0019\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010%R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u0011\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010+R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u0013\u0010\u0012\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010.R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00103R\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u00105R\u0011\u0010\u0019\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u0010+R\u0011\u0010\u001a\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u0010)\u00a8\u0006Y"}, d2={"Lcom/marcpg/pillarperil/player/PlayerSnapshot;", "", "uuid", "Ljava/util/UUID;", "displayName", "Lnet/kyori/adventure/text/Component;", "inventory", "", "Lorg/bukkit/inventory/ItemStack;", "inventoryArmor", "inventoryExtra", "exp", "", "totalExperience", "", "level", "location", "Lorg/bukkit/Location;", "respawnLocation", "gameMode", "Lorg/bukkit/GameMode;", "scoreboard", "Lorg/bukkit/scoreboard/Scoreboard;", "health", "", "foodLevel", "saturation", "<init>", "(Ljava/util/UUID;Lnet/kyori/adventure/text/Component;Ljava/util/List;Ljava/util/List;Ljava/util/List;FIILorg/bukkit/Location;Lorg/bukkit/Location;Lorg/bukkit/GameMode;Lorg/bukkit/scoreboard/Scoreboard;DIF)V", "player", "Lorg/bukkit/entity/Player;", "(Lorg/bukkit/entity/Player;)V", "getUuid", "()Ljava/util/UUID;", "getDisplayName", "()Lnet/kyori/adventure/text/Component;", "getInventory", "()Ljava/util/List;", "getInventoryArmor", "getInventoryExtra", "getExp", "()F", "getTotalExperience", "()I", "getLevel", "getLocation", "()Lorg/bukkit/Location;", "getRespawnLocation", "getGameMode", "()Lorg/bukkit/GameMode;", "getScoreboard", "()Lorg/bukkit/scoreboard/Scoreboard;", "getHealth", "()D", "getFoodLevel", "getSaturation", "set", "", "restoreName", "", "restoreLocation", "restoreInventory", "restoreExperience", "restoreRespawnLocation", "restoreGameMode", "restoreScoreboard", "restoreHealth", "restoreHunger", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "component10", "component11", "component12", "component13", "component14", "component15", "copy", "equals", "other", "hashCode", "toString", "", "PillarPeril"})
@SourceDebugExtension(value={"SMAP\nPlayerSnapshot.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlayerSnapshot.kt\ncom/marcpg/pillarperil/player/PlayerSnapshot\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,94:1\n37#2,2:95\n37#2,2:97\n37#2,2:99\n*S KotlinDebug\n*F\n+ 1 PlayerSnapshot.kt\ncom/marcpg/pillarperil/player/PlayerSnapshot\n*L\n62#1:95,2\n63#1:97,2\n64#1:99,2\n*E\n"})
public final class PlayerSnapshot {
    @NotNull
    private final UUID uuid;
    @NotNull
    private final Component displayName;
    @NotNull
    private final List<ItemStack> inventory;
    @NotNull
    private final List<ItemStack> inventoryArmor;
    @NotNull
    private final List<ItemStack> inventoryExtra;
    private final float exp;
    private final int totalExperience;
    private final int level;
    @NotNull
    private final Location location;
    @Nullable
    private final Location respawnLocation;
    @NotNull
    private final GameMode gameMode;
    @NotNull
    private final Scoreboard scoreboard;
    private final double health;
    private final int foodLevel;
    private final float saturation;

    public PlayerSnapshot(@NotNull UUID uuid, @NotNull Component displayName, @NotNull List<? extends ItemStack> inventory, @NotNull List<? extends ItemStack> inventoryArmor, @NotNull List<? extends ItemStack> inventoryExtra, float exp, int totalExperience, int level, @NotNull Location location, @Nullable Location respawnLocation, @NotNull GameMode gameMode, @NotNull Scoreboard scoreboard, double health, int foodLevel, float saturation) {
        Intrinsics.checkNotNullParameter(uuid, "uuid");
        Intrinsics.checkNotNullParameter(displayName, "displayName");
        Intrinsics.checkNotNullParameter(inventory, "inventory");
        Intrinsics.checkNotNullParameter(inventoryArmor, "inventoryArmor");
        Intrinsics.checkNotNullParameter(inventoryExtra, "inventoryExtra");
        Intrinsics.checkNotNullParameter(location, "location");
        Intrinsics.checkNotNullParameter(gameMode, "gameMode");
        Intrinsics.checkNotNullParameter(scoreboard, "scoreboard");
        this.uuid = uuid;
        this.displayName = displayName;
        this.inventory = inventory;
        this.inventoryArmor = inventoryArmor;
        this.inventoryExtra = inventoryExtra;
        this.exp = exp;
        this.totalExperience = totalExperience;
        this.level = level;
        this.location = location;
        this.respawnLocation = respawnLocation;
        this.gameMode = gameMode;
        this.scoreboard = scoreboard;
        this.health = health;
        this.foodLevel = foodLevel;
        this.saturation = saturation;
    }

    @NotNull
    public final UUID getUuid() {
        return this.uuid;
    }

    @NotNull
    public final Component getDisplayName() {
        return this.displayName;
    }

    @NotNull
    public final List<ItemStack> getInventory() {
        return this.inventory;
    }

    @NotNull
    public final List<ItemStack> getInventoryArmor() {
        return this.inventoryArmor;
    }

    @NotNull
    public final List<ItemStack> getInventoryExtra() {
        return this.inventoryExtra;
    }

    public final float getExp() {
        return this.exp;
    }

    public final int getTotalExperience() {
        return this.totalExperience;
    }

    public final int getLevel() {
        return this.level;
    }

    @NotNull
    public final Location getLocation() {
        return this.location;
    }

    @Nullable
    public final Location getRespawnLocation() {
        return this.respawnLocation;
    }

    @NotNull
    public final GameMode getGameMode() {
        return this.gameMode;
    }

    @NotNull
    public final Scoreboard getScoreboard() {
        return this.scoreboard;
    }

    public final double getHealth() {
        return this.health;
    }

    public final int getFoodLevel() {
        return this.foodLevel;
    }

    public final float getSaturation() {
        return this.saturation;
    }

    public PlayerSnapshot(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        UUID uUID = player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        Component component = player.displayName();
        Intrinsics.checkNotNullExpressionValue(component, "displayName(...)");
        ItemStack[] itemStackArray = player.getInventory().getContents();
        Intrinsics.checkNotNullExpressionValue(itemStackArray, "getContents(...)");
        List<Object> list = ArraysKt.toList((Object[])itemStackArray);
        ItemStack[] itemStackArray2 = player.getInventory().getArmorContents();
        Intrinsics.checkNotNullExpressionValue(itemStackArray2, "getArmorContents(...)");
        List<Object> list2 = ArraysKt.toList((Object[])itemStackArray2);
        ItemStack[] itemStackArray3 = player.getInventory().getExtraContents();
        Intrinsics.checkNotNullExpressionValue(itemStackArray3, "getExtraContents(...)");
        List<Object> list3 = ArraysKt.toList((Object[])itemStackArray3);
        float f = player.getExp();
        int n = player.getTotalExperience();
        int n2 = player.getLevel();
        Location location = player.getLocation().clone();
        Intrinsics.checkNotNullExpressionValue(location, "clone(...)");
        Location location2 = player.getRespawnLocation();
        Object object = location2 != null ? location2.clone() : null;
        GameMode gameMode = player.getGameMode();
        Intrinsics.checkNotNullExpressionValue(gameMode, "getGameMode(...)");
        Scoreboard scoreboard = player.getScoreboard();
        Intrinsics.checkNotNullExpressionValue(scoreboard, "getScoreboard(...)");
        this(uUID, component, (List<? extends ItemStack>)list, (List<? extends ItemStack>)list2, (List<? extends ItemStack>)list3, f, n, n2, location, (Location)object, gameMode, scoreboard, player.getHealth(), player.getFoodLevel(), player.getSaturation());
    }

    public final void set(@NotNull Player player, boolean restoreName, boolean restoreLocation, boolean restoreInventory, boolean restoreExperience, boolean restoreRespawnLocation, boolean restoreGameMode, boolean restoreScoreboard, boolean restoreHealth, boolean restoreHunger) {
        Intrinsics.checkNotNullParameter(player, "player");
        if (restoreName) {
            player.displayName(this.displayName);
        }
        if (restoreInventory) {
            Collection $this$toTypedArray$iv = this.inventory;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            player.getInventory().setContents(thisCollection$iv.toArray(new ItemStack[0]));
            $this$toTypedArray$iv = this.inventoryArmor;
            $i$f$toTypedArray = false;
            thisCollection$iv = $this$toTypedArray$iv;
            player.getInventory().setArmorContents(thisCollection$iv.toArray(new ItemStack[0]));
            $this$toTypedArray$iv = this.inventoryExtra;
            $i$f$toTypedArray = false;
            thisCollection$iv = $this$toTypedArray$iv;
            player.getInventory().setExtraContents(thisCollection$iv.toArray(new ItemStack[0]));
        }
        if (restoreExperience) {
            player.setExp(this.exp);
            player.setTotalExperience(this.totalExperience);
            player.setLevel(this.level);
        }
        if (restoreLocation) {
            player.teleport(this.location);
        }
        if (restoreRespawnLocation) {
            player.setRespawnLocation(this.respawnLocation);
        }
        if (restoreGameMode) {
            player.setGameMode(this.gameMode);
        }
        if (restoreScoreboard) {
            player.setScoreboard(this.scoreboard);
        }
        if (restoreHealth) {
            player.setHealth(this.health);
        }
        if (restoreHunger) {
            player.setFoodLevel(this.foodLevel);
            player.setSaturation(this.saturation);
        }
    }

    public static /* synthetic */ void set$default(PlayerSnapshot playerSnapshot, Player player, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, boolean bl9, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = true;
        }
        if ((n & 8) != 0) {
            bl3 = true;
        }
        if ((n & 0x10) != 0) {
            bl4 = true;
        }
        if ((n & 0x20) != 0) {
            bl5 = true;
        }
        if ((n & 0x40) != 0) {
            bl6 = true;
        }
        if ((n & 0x80) != 0) {
            bl7 = true;
        }
        if ((n & 0x100) != 0) {
            bl8 = true;
        }
        if ((n & 0x200) != 0) {
            bl9 = true;
        }
        playerSnapshot.set(player, bl, bl2, bl3, bl4, bl5, bl6, bl7, bl8, bl9);
    }

    @NotNull
    public final UUID component1() {
        return this.uuid;
    }

    @NotNull
    public final Component component2() {
        return this.displayName;
    }

    @NotNull
    public final List<ItemStack> component3() {
        return this.inventory;
    }

    @NotNull
    public final List<ItemStack> component4() {
        return this.inventoryArmor;
    }

    @NotNull
    public final List<ItemStack> component5() {
        return this.inventoryExtra;
    }

    public final float component6() {
        return this.exp;
    }

    public final int component7() {
        return this.totalExperience;
    }

    public final int component8() {
        return this.level;
    }

    @NotNull
    public final Location component9() {
        return this.location;
    }

    @Nullable
    public final Location component10() {
        return this.respawnLocation;
    }

    @NotNull
    public final GameMode component11() {
        return this.gameMode;
    }

    @NotNull
    public final Scoreboard component12() {
        return this.scoreboard;
    }

    public final double component13() {
        return this.health;
    }

    public final int component14() {
        return this.foodLevel;
    }

    public final float component15() {
        return this.saturation;
    }

    @NotNull
    public final PlayerSnapshot copy(@NotNull UUID uuid, @NotNull Component displayName, @NotNull List<? extends ItemStack> inventory, @NotNull List<? extends ItemStack> inventoryArmor, @NotNull List<? extends ItemStack> inventoryExtra, float exp, int totalExperience, int level, @NotNull Location location, @Nullable Location respawnLocation, @NotNull GameMode gameMode, @NotNull Scoreboard scoreboard, double health, int foodLevel, float saturation) {
        Intrinsics.checkNotNullParameter(uuid, "uuid");
        Intrinsics.checkNotNullParameter(displayName, "displayName");
        Intrinsics.checkNotNullParameter(inventory, "inventory");
        Intrinsics.checkNotNullParameter(inventoryArmor, "inventoryArmor");
        Intrinsics.checkNotNullParameter(inventoryExtra, "inventoryExtra");
        Intrinsics.checkNotNullParameter(location, "location");
        Intrinsics.checkNotNullParameter(gameMode, "gameMode");
        Intrinsics.checkNotNullParameter(scoreboard, "scoreboard");
        return new PlayerSnapshot(uuid, displayName, inventory, inventoryArmor, inventoryExtra, exp, totalExperience, level, location, respawnLocation, gameMode, scoreboard, health, foodLevel, saturation);
    }

    public static /* synthetic */ PlayerSnapshot copy$default(PlayerSnapshot playerSnapshot, UUID uUID, Component component, List list, List list2, List list3, float f, int n, int n2, Location location, Location location2, GameMode gameMode, Scoreboard scoreboard, double d, int n3, float f2, int n4, Object object) {
        if ((n4 & 1) != 0) {
            uUID = playerSnapshot.uuid;
        }
        if ((n4 & 2) != 0) {
            component = playerSnapshot.displayName;
        }
        if ((n4 & 4) != 0) {
            list = playerSnapshot.inventory;
        }
        if ((n4 & 8) != 0) {
            list2 = playerSnapshot.inventoryArmor;
        }
        if ((n4 & 0x10) != 0) {
            list3 = playerSnapshot.inventoryExtra;
        }
        if ((n4 & 0x20) != 0) {
            f = playerSnapshot.exp;
        }
        if ((n4 & 0x40) != 0) {
            n = playerSnapshot.totalExperience;
        }
        if ((n4 & 0x80) != 0) {
            n2 = playerSnapshot.level;
        }
        if ((n4 & 0x100) != 0) {
            location = playerSnapshot.location;
        }
        if ((n4 & 0x200) != 0) {
            location2 = playerSnapshot.respawnLocation;
        }
        if ((n4 & 0x400) != 0) {
            gameMode = playerSnapshot.gameMode;
        }
        if ((n4 & 0x800) != 0) {
            scoreboard = playerSnapshot.scoreboard;
        }
        if ((n4 & 0x1000) != 0) {
            d = playerSnapshot.health;
        }
        if ((n4 & 0x2000) != 0) {
            n3 = playerSnapshot.foodLevel;
        }
        if ((n4 & 0x4000) != 0) {
            f2 = playerSnapshot.saturation;
        }
        return playerSnapshot.copy(uUID, component, list, list2, list3, f, n, n2, location, location2, gameMode, scoreboard, d, n3, f2);
    }

    @NotNull
    public String toString() {
        return "PlayerSnapshot(uuid=" + this.uuid + ", displayName=" + this.displayName + ", inventory=" + this.inventory + ", inventoryArmor=" + this.inventoryArmor + ", inventoryExtra=" + this.inventoryExtra + ", exp=" + this.exp + ", totalExperience=" + this.totalExperience + ", level=" + this.level + ", location=" + this.location + ", respawnLocation=" + this.respawnLocation + ", gameMode=" + this.gameMode + ", scoreboard=" + this.scoreboard + ", health=" + this.health + ", foodLevel=" + this.foodLevel + ", saturation=" + this.saturation + ")";
    }

    public int hashCode() {
        int result = this.uuid.hashCode();
        result = result * 31 + this.displayName.hashCode();
        result = result * 31 + ((Object)this.inventory).hashCode();
        result = result * 31 + ((Object)this.inventoryArmor).hashCode();
        result = result * 31 + ((Object)this.inventoryExtra).hashCode();
        result = result * 31 + Float.hashCode(this.exp);
        result = result * 31 + Integer.hashCode(this.totalExperience);
        result = result * 31 + Integer.hashCode(this.level);
        result = result * 31 + this.location.hashCode();
        result = result * 31 + (this.respawnLocation == null ? 0 : this.respawnLocation.hashCode());
        result = result * 31 + this.gameMode.hashCode();
        result = result * 31 + this.scoreboard.hashCode();
        result = result * 31 + Double.hashCode(this.health);
        result = result * 31 + Integer.hashCode(this.foodLevel);
        result = result * 31 + Float.hashCode(this.saturation);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PlayerSnapshot)) {
            return false;
        }
        PlayerSnapshot playerSnapshot = (PlayerSnapshot)other;
        if (!Intrinsics.areEqual(this.uuid, playerSnapshot.uuid)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.displayName, playerSnapshot.displayName)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.inventory, playerSnapshot.inventory)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.inventoryArmor, playerSnapshot.inventoryArmor)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.inventoryExtra, playerSnapshot.inventoryExtra)) {
            return false;
        }
        if (Float.compare(this.exp, playerSnapshot.exp) != 0) {
            return false;
        }
        if (this.totalExperience != playerSnapshot.totalExperience) {
            return false;
        }
        if (this.level != playerSnapshot.level) {
            return false;
        }
        if (!Intrinsics.areEqual(this.location, playerSnapshot.location)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.respawnLocation, playerSnapshot.respawnLocation)) {
            return false;
        }
        if (this.gameMode != playerSnapshot.gameMode) {
            return false;
        }
        if (!Intrinsics.areEqual(this.scoreboard, playerSnapshot.scoreboard)) {
            return false;
        }
        if (Double.compare(this.health, playerSnapshot.health) != 0) {
            return false;
        }
        if (this.foodLevel != playerSnapshot.foodLevel) {
            return false;
        }
        return Float.compare(this.saturation, playerSnapshot.saturation) == 0;
    }
}

