/*
 * Decompiled with CFR 0.152.
 */
package com.marcpg.pillarperil.player;

import com.marcpg.libpg.display.PlayerMinecraftReceiver;
import com.marcpg.libpg.display.PlayerMinecraftReceiverKt;
import com.marcpg.libpg.display.SimpleActionBar;
import com.marcpg.libpg.display.SimpleScoreboard;
import com.marcpg.libpg.util.PaperGlobalFunctionsKt;
import com.marcpg.pillarperil.game.Game;
import com.marcpg.pillarperil.game.util.QueueManager;
import com.marcpg.pillarperil.player.PlayerSnapshot;
import com.marcpg.pillarperil.util.Configuration;
import com.marcpg.pillarperil.util.QueueMethod;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.ItemType;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001e\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\b\b\u0002\u0010!\u001a\u00020\u0013J\u0010\u0010\"\u001a\u00020\u001d2\b\b\u0002\u0010#\u001a\u00020$J\u0006\u0010%\u001a\u00020\u001dR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006&"}, d2={"Lcom/marcpg/pillarperil/player/PillarPlayer;", "Lcom/marcpg/libpg/display/PlayerMinecraftReceiver;", "player", "Lorg/bukkit/entity/Player;", "game", "Lcom/marcpg/pillarperil/game/Game;", "<init>", "(Lorg/bukkit/entity/Player;Lcom/marcpg/pillarperil/game/Game;)V", "getGame", "()Lcom/marcpg/pillarperil/game/Game;", "simpleScoreboard", "Lcom/marcpg/libpg/display/SimpleScoreboard;", "getSimpleScoreboard", "()Lcom/marcpg/libpg/display/SimpleScoreboard;", "simpleActionBar", "Lcom/marcpg/libpg/display/SimpleActionBar;", "getSimpleActionBar", "()Lcom/marcpg/libpg/display/SimpleActionBar;", "kills", "", "getKills", "()I", "setKills", "(I)V", "initialSnapshot", "Lcom/marcpg/pillarperil/player/PlayerSnapshot;", "getInitialSnapshot", "()Lcom/marcpg/pillarperil/player/PlayerSnapshot;", "giveItems", "", "available", "", "Lorg/bukkit/inventory/ItemType;", "differentItems", "clear", "display", "", "eliminate", "PillarPeril"})
public final class PillarPlayer
extends PlayerMinecraftReceiver {
    @NotNull
    private final Game game;
    @Nullable
    private final SimpleScoreboard simpleScoreboard;
    @Nullable
    private final SimpleActionBar simpleActionBar;
    private int kills;
    @NotNull
    private final PlayerSnapshot initialSnapshot;

    public PillarPlayer(@NotNull Player player, @NotNull Game game) {
        block5: {
            SimpleActionBar simpleActionBar;
            Intrinsics.checkNotNullParameter(player, "player");
            Intrinsics.checkNotNullParameter(game, "game");
            super(player);
            this.game = game;
            if (this.game.getInfo().getShowScoreboard().invoke().booleanValue()) {
                Function1<PillarPlayer, SimpleScoreboard> function1 = this.game.getScoreboard();
                v1 = function1 != null ? function1.invoke(this) : null;
            } else {
                v1 = this.simpleScoreboard = null;
            }
            if (this.game.getInfo().getShowActionBar().invoke().booleanValue()) {
                Function1<PillarPlayer, SimpleActionBar> function1 = this.game.getActionBar();
                simpleActionBar = function1 != null ? function1.invoke(this) : null;
            } else {
                simpleActionBar = null;
            }
            this.simpleActionBar = simpleActionBar;
            this.initialSnapshot = new PlayerSnapshot(player);
            SimpleScoreboard simpleScoreboard = this.simpleScoreboard;
            if (simpleScoreboard != null) {
                PlayerMinecraftReceiverKt.start(simpleScoreboard);
            }
            SimpleActionBar simpleActionBar2 = this.simpleActionBar;
            if (simpleActionBar2 == null) break block5;
            PlayerMinecraftReceiverKt.start(simpleActionBar2);
        }
    }

    @NotNull
    public final Game getGame() {
        return this.game;
    }

    @Nullable
    public final SimpleScoreboard getSimpleScoreboard() {
        return this.simpleScoreboard;
    }

    @Nullable
    public final SimpleActionBar getSimpleActionBar() {
        return this.simpleActionBar;
    }

    public final int getKills() {
        return this.kills;
    }

    public final void setKills(int n) {
        this.kills = n;
    }

    @NotNull
    public final PlayerSnapshot getInitialSnapshot() {
        return this.initialSnapshot;
    }

    public final void giveItems(@NotNull Collection<? extends ItemType> available, int differentItems) {
        Intrinsics.checkNotNullParameter(available, "available");
        int n = 0;
        while (n < differentItems) {
            int it = n++;
            boolean bl = false;
            ItemStack[] itemStackArray = new ItemStack[]{CollectionsKt.random(available, Random.Default).createItemStack()};
            this.getPlayer().getInventory().addItem(itemStackArray);
        }
    }

    public static /* synthetic */ void giveItems$default(PillarPlayer pillarPlayer, Collection collection, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 1;
        }
        pillarPlayer.giveItems(collection, n);
    }

    public final void clear(boolean display) {
        if (display) {
            SimpleScoreboard simpleScoreboard = this.simpleScoreboard;
            if (simpleScoreboard != null) {
                simpleScoreboard.stop();
            }
            SimpleActionBar simpleActionBar = this.simpleActionBar;
            if (simpleActionBar != null) {
                simpleActionBar.stop();
            }
            this.getPlayer().setScoreboard(Bukkit.getScoreboardManager().getMainScoreboard());
        }
        this.getPlayer().closeInventory();
        this.getPlayer().getInventory().clear();
        this.getPlayer().clearActivePotionEffects();
        PlayerSnapshot playerSnapshot = this.initialSnapshot;
        PlayerSnapshot.set$default(playerSnapshot, this.getPlayer(), false, false, false, false, false, false, false, false, false, 954, null);
        this.getPlayer().setGameMode(Configuration.INSTANCE.getSpawnGameMode());
        this.getPlayer().teleport(Configuration.INSTANCE.getSpawnLocation());
        if (Configuration.INSTANCE.getQueueMethod() == QueueMethod.AUTO) {
            PaperGlobalFunctionsKt.bukkitRunLater(60L, arg_0 -> PillarPlayer.clear$lambda$0(this, arg_0));
        }
    }

    public static /* synthetic */ void clear$default(PillarPlayer pillarPlayer, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        pillarPlayer.clear(bl);
    }

    public final void eliminate() {
        this.game.eliminate(this);
    }

    private static final Unit clear$lambda$0(PillarPlayer this$0, BukkitTask it) {
        Intrinsics.checkNotNullParameter(it, "it");
        QueueManager.INSTANCE.add(this$0.getPlayer());
        return Unit.INSTANCE;
    }
}

