/*
 * Decompiled with CFR 0.152.
 */
package com.marcpg.pillarperil.generation;

import com.marcpg.pillarperil.game.Game;
import com.marcpg.pillarperil.generation.HorizontalGen;
import com.marcpg.pillarperil.generation.VerticalGen;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.Location;
import org.bukkit.block.data.BlockData;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00122\b\b\u0002\u0010\u0019\u001a\u00020\u0013J\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00120\u001bJ\u0006\u0010\u001c\u001a\u00020\u0017R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001d\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001d"}, d2={"Lcom/marcpg/pillarperil/generation/Buildings;", "", "game", "Lcom/marcpg/pillarperil/game/Game;", "horizontalGen", "Lcom/marcpg/pillarperil/generation/HorizontalGen;", "verticalGen", "Lcom/marcpg/pillarperil/generation/VerticalGen;", "<init>", "(Lcom/marcpg/pillarperil/game/Game;Lcom/marcpg/pillarperil/generation/HorizontalGen;Lcom/marcpg/pillarperil/generation/VerticalGen;)V", "getGame", "()Lcom/marcpg/pillarperil/game/Game;", "getHorizontalGen", "()Lcom/marcpg/pillarperil/generation/HorizontalGen;", "getVerticalGen", "()Lcom/marcpg/pillarperil/generation/VerticalGen;", "initialBlocks", "", "Lorg/bukkit/Location;", "Lorg/bukkit/block/data/BlockData;", "getInitialBlocks", "()Ljava/util/Map;", "place", "", "location", "data", "generate", "", "reset", "PillarPeril"})
@SourceDebugExtension(value={"SMAP\nBuildings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Buildings.kt\ncom/marcpg/pillarperil/generation/Buildings\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,33:1\n1869#2,2:34\n216#3,2:36\n216#3,2:38\n*S KotlinDebug\n*F\n+ 1 Buildings.kt\ncom/marcpg/pillarperil/generation/Buildings\n*L\n21#1:34,2\n27#1:36,2\n30#1:38,2\n*E\n"})
public final class Buildings {
    @NotNull
    private final Game game;
    @NotNull
    private final HorizontalGen horizontalGen;
    @NotNull
    private final VerticalGen verticalGen;
    @NotNull
    private final Map<Location, BlockData> initialBlocks;

    public Buildings(@NotNull Game game, @NotNull HorizontalGen horizontalGen, @NotNull VerticalGen verticalGen) {
        Intrinsics.checkNotNullParameter(game, "game");
        Intrinsics.checkNotNullParameter(horizontalGen, "horizontalGen");
        Intrinsics.checkNotNullParameter(verticalGen, "verticalGen");
        this.game = game;
        this.horizontalGen = horizontalGen;
        this.verticalGen = verticalGen;
        this.initialBlocks = new LinkedHashMap();
    }

    @NotNull
    public final Game getGame() {
        return this.game;
    }

    @NotNull
    public final HorizontalGen getHorizontalGen() {
        return this.horizontalGen;
    }

    @NotNull
    public final VerticalGen getVerticalGen() {
        return this.verticalGen;
    }

    @NotNull
    public final Map<Location, BlockData> getInitialBlocks() {
        return this.initialBlocks;
    }

    public final void place(@NotNull Location location, @NotNull BlockData data) {
        Intrinsics.checkNotNullParameter(location, "location");
        Intrinsics.checkNotNullParameter(data, "data");
        if (!this.initialBlocks.containsKey(location)) {
            this.initialBlocks.put(location.clone(), data);
        }
    }

    public static /* synthetic */ void place$default(Buildings buildings, Location location, BlockData blockData, int n, Object object) {
        if ((n & 2) != 0) {
            BlockData blockData2 = location.getBlock().getBlockData();
            Intrinsics.checkNotNullExpressionValue(blockData2, "getBlockData(...)");
            blockData = blockData2;
        }
        buildings.place(location, blockData);
    }

    @NotNull
    public final List<Location> generate() {
        List<Location> locations = this.horizontalGen.generate();
        Iterable $this$forEach$iv = locations;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Location it = (Location)element$iv;
            boolean bl = false;
            this.verticalGen.generate(it.getX(), it.getZ());
        }
        return locations;
    }

    public final void reset() {
        BlockData b;
        Location l;
        Map.Entry<Location, BlockData> entry;
        Map.Entry<Location, BlockData> element$iv;
        Map<Location, BlockData> $this$forEach$iv = this.initialBlocks;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<Location, BlockData>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            entry = element$iv = iterator2.next();
            boolean bl = false;
            l = entry.getKey();
            b = entry.getValue();
            l.getBlock().setBlockData(b, true);
        }
        $this$forEach$iv = this.initialBlocks;
        $i$f$forEach = false;
        iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            entry = element$iv = iterator2.next();
            boolean bl = false;
            l = entry.getKey();
            b = entry.getValue();
            l.getBlock().setBlockData(b, false);
        }
    }
}

