/*
 * Decompiled with CFR 0.152.
 */
package com.marcpg.pillarperil.game.util;

import com.marcpg.libpg.lang.TranslationKt;
import com.marcpg.libpg.util.AdventureExtensionsKt;
import com.marcpg.libpg.util.AdventureGlobalFunctionsKt;
import com.marcpg.pillarperil.PillarPeril;
import com.marcpg.pillarperil.game.Game;
import com.marcpg.pillarperil.game.util.GameManager;
import com.marcpg.pillarperil.util.Configuration;
import com.marcpg.pillarperil.util.PlaceholderNameGetter;
import com.marcpg.pillarperil.util.Ticking;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArrayDeque;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\tJ\u000e\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\tJ\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u000fH\u0002J\u0016\u0010\u0015\u001a\u00020\u000f2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\t0\u0017H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/marcpg/pillarperil/game/util/QueueManager;", "Lcom/marcpg/pillarperil/util/Ticking;", "<init>", "()V", "RED_COLORS", "", "GREEN_COLORS", "queue", "Lkotlin/collections/ArrayDeque;", "Lorg/bukkit/entity/Player;", "getQueue", "()Lkotlin/collections/ArrayDeque;", "phase", "", "add", "", "player", "remove", "tick", "Lcom/marcpg/pillarperil/util/Ticking$Tick;", "check", "startGame", "players", "", "PillarPeril"})
@SourceDebugExtension(value={"SMAP\nQueueManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QueueManager.kt\ncom/marcpg/pillarperil/game/util/QueueManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,100:1\n1869#2,2:101\n1869#2,2:103\n1869#2,2:106\n1869#2,2:108\n1869#2,2:110\n1#3:105\n*S KotlinDebug\n*F\n+ 1 QueueManager.kt\ncom/marcpg/pillarperil/game/util/QueueManager\n*L\n49#1:101,2\n55#1:103,2\n74#1:106,2\n79#1:108,2\n94#1:110,2\n*E\n"})
public final class QueueManager
implements Ticking {
    @NotNull
    public static final QueueManager INSTANCE = new QueueManager();
    @NotNull
    public static final String RED_COLORS = "#CC2222:#FF8888";
    @NotNull
    public static final String GREEN_COLORS = "#22CC22:#88FF88";
    @NotNull
    private static final ArrayDeque<Player> queue = new ArrayDeque();
    private static double phase;

    private QueueManager() {
    }

    @NotNull
    public final ArrayDeque<Player> getQueue() {
        return queue;
    }

    public final void add(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        if (!Configuration.INSTANCE.getQueueEnabled() || queue.contains(player) || GameManager.isInGame$default(GameManager.INSTANCE, player, false, 2, null)) {
            return;
        }
        queue.addLast(player);
        if (Configuration.INSTANCE.getQueueCheckIntervalSecs() == -1) {
            this.check();
        }
    }

    public final void remove(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        if (!Configuration.INSTANCE.getQueueEnabled()) {
            return;
        }
        queue.remove(player);
        if (Configuration.INSTANCE.getQueueCheckIntervalSecs() == -1) {
            this.check();
        }
    }

    @Override
    public void tick(@NotNull Ticking.Tick tick) {
        Object[] objectArray;
        Player it;
        Intrinsics.checkNotNullParameter(tick, "tick");
        if (!Configuration.INSTANCE.getQueueEnabled()) {
            return;
        }
        if (Configuration.INSTANCE.getQueueCheckIntervalSecs() >= 1 && tick.isInInterval(0, Configuration.INSTANCE.getQueueCheckInterval())) {
            this.check();
        }
        Iterable $this$forEach$iv = queue;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Player)element$iv;
            boolean bl = false;
            Locale locale = it.locale();
            Intrinsics.checkNotNullExpressionValue(locale, "locale(...)");
            objectArray = new String[2];
            objectArray[0] = String.valueOf(queue.size());
            objectArray[1] = String.valueOf(Configuration.INSTANCE.getQueueMinPlayers());
            it.sendActionBar(AdventureExtensionsKt.component$default(locale, "queue.actionbar", (String[])objectArray, (TextColor)(queue.size() >= Configuration.INSTANCE.getQueueMinPlayers() ? NamedTextColor.GREEN : NamedTextColor.RED), null, 8, null));
        }
        $this$forEach$iv = queue;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Player)element$iv;
            boolean bl = false;
            MiniMessage miniMessage = MiniMessage.miniMessage();
            String string = queue.size() >= Configuration.INSTANCE.getQueueMinPlayers() ? GREEN_COLORS : RED_COLORS;
            Locale locale = it.locale();
            Intrinsics.checkNotNullExpressionValue(locale, "locale(...)");
            objectArray = new Object[2];
            objectArray[0] = String.valueOf(queue.size());
            objectArray[1] = String.valueOf(Configuration.INSTANCE.getQueueMinPlayers());
            it.sendActionBar(miniMessage.deserialize((Object)("<gradient:" + string + ":" + phase + ">" + TranslationKt.string(locale, "queue.actionbar", objectArray) + "</gradient>")));
        }
    }

    private final void check() {
        if (queue.size() < Configuration.INSTANCE.getQueueMinPlayers()) {
            return;
        }
        int n = Configuration.INSTANCE.getQueueMaxPlayers();
        int n2 = queue.size();
        int count = Math.min(n, n2);
        QueueManager queueManager = this;
        ArrayList<Player> arrayList = new ArrayList<Player>(count);
        n2 = 0;
        while (n2 < count) {
            int n3;
            int n4 = n3 = n2++;
            ArrayList<Player> arrayList2 = arrayList;
            boolean bl = false;
            arrayList2.add(queue.removeFirst());
        }
        queueManager.startGame((List<? extends Player>)arrayList);
    }

    private final void startGame(List<? extends Player> players) {
        Pair[] it;
        String id = Game.Companion.generateId();
        Pair[] pairArray = new Pair[]{TuplesKt.to("id", id), TuplesKt.to("mode", Configuration.INSTANCE.getQueueMode().getGameInfo().getNamespace()), TuplesKt.to("players", players.size())};
        Map map = MapsKt.mutableMapOf(pairArray);
        Iterable $this$forEach$iv = Configuration.INSTANCE.getQueuePreCommands();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (PlaceholderNameGetter)element$iv;
            boolean bl = false;
            PillarPeril.Companion.sendCommand(it.invoke(map));
        }
        String worldName = Configuration.INSTANCE.getQueueWorldName().invoke(map);
        World world = Bukkit.getWorld((String)worldName);
        if (world == null) {
            Iterable $this$forEach$iv2 = players;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                Player it2 = (Player)element$iv;
                boolean bl = false;
                String string = "Configured world \"" + worldName + "\" does not exist, which means the game cannot start.";
                NamedTextColor namedTextColor = NamedTextColor.RED;
                Intrinsics.checkNotNullExpressionValue(namedTextColor, "RED");
                it2.sendMessage((Component)AdventureGlobalFunctionsKt.component(string, (TextColor)namedTextColor));
                NamedTextColor namedTextColor2 = NamedTextColor.RED;
                Intrinsics.checkNotNullExpressionValue(namedTextColor2, "RED");
                it2.sendMessage((Component)AdventureGlobalFunctionsKt.component("Please notify an admin of the server.", (TextColor)namedTextColor2));
            }
            return;
        }
        Location location = Configuration.INSTANCE.queueLocation(world);
        Map $i$f$forEach2 = map;
        it = new Pair[]{TuplesKt.to("world", location.getWorld().getName()), TuplesKt.to("x", location.getX()), TuplesKt.to("y", location.getY()), TuplesKt.to("z", location.getZ())};
        $i$f$forEach2.putAll(MapsKt.mapOf(it));
        Iterable $this$forEach$iv3 = Configuration.INSTANCE.getQueuePostCommands();
        boolean $i$f$forEach3 = false;
        for (Object element$iv : $this$forEach$iv3) {
            PlaceholderNameGetter it3 = (PlaceholderNameGetter)element$iv;
            boolean bl = false;
            PillarPeril.Companion.sendCommand(it3.invoke(map));
        }
        Configuration.INSTANCE.getQueueMode().getGameConstructor().invoke(id, location, players).init();
    }
}

