/*
 * Decompiled with CFR 0.152.
 */
package com.marcpg.pillarperil.game;

import com.marcpg.libpg.data.Quantity;
import com.marcpg.libpg.data.time.Time;
import com.marcpg.libpg.display.ForwardingMinecraftReceiver;
import com.marcpg.libpg.display.GradientActionBar;
import com.marcpg.libpg.display.MinecraftReceiver;
import com.marcpg.libpg.display.MinecraftReceiverKt;
import com.marcpg.libpg.display.PlayerMinecraftReceiverKt;
import com.marcpg.libpg.display.ScoreboardEntry;
import com.marcpg.libpg.display.SimpleActionBar;
import com.marcpg.libpg.display.SimpleBossBar;
import com.marcpg.libpg.display.SimpleScoreboard;
import com.marcpg.libpg.display.StaticValueScoreboardEntry;
import com.marcpg.libpg.display.ValueScoreboardEntry;
import com.marcpg.libpg.util.AdventureExtensionsKt;
import com.marcpg.libpg.util.AdventureGlobalFunctionsKt;
import com.marcpg.libpg.util.PaperGlobalFunctionsKt;
import com.marcpg.libpg.util.Randomizer;
import com.marcpg.pillarperil.PillarPeril;
import com.marcpg.pillarperil.game.util.GameInfo;
import com.marcpg.pillarperil.game.util.GameManager;
import com.marcpg.pillarperil.game.util.QueueManager;
import com.marcpg.pillarperil.generation.Buildings;
import com.marcpg.pillarperil.generation.HorizontalGen;
import com.marcpg.pillarperil.generation.VerticalGen;
import com.marcpg.pillarperil.player.PillarPlayer;
import com.marcpg.pillarperil.util.Configuration;
import com.marcpg.pillarperil.util.PlaceholderNameGetter;
import com.marcpg.pillarperil.util.Ticking;
import io.papermc.paper.world.flag.FeatureDependant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.title.Title;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Registry;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemType;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00b8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u0000 f2\u00020\u0001:\u0002fgB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010P\u001a\u00020IH\u0016J\u0010\u0010Q\u001a\u00020I2\u0006\u0010R\u001a\u00020\u000eH\u0016J\u000e\u0010\u001b\u001a\u00020I2\u0006\u0010S\u001a\u00020\u0003J\u000e\u0010T\u001a\u00020I2\u0006\u0010S\u001a\u00020\u0003J\u001e\u0010U\u001a\u00020I2\u0006\u0010V\u001a\u00020C2\f\u0010W\u001a\b\u0012\u0004\u0012\u00020I0(H\u0004J\u001e\u0010U\u001a\u00020I2\u0006\u0010X\u001a\u00020Y2\f\u0010W\u001a\b\u0012\u0004\u0012\u00020I0(H\u0004J\u0010\u0010Z\u001a\u00020[2\b\b\u0002\u0010\\\u001a\u00020KJ\u001a\u0010R\u001a\u0004\u0018\u00010\u000e2\u0006\u0010]\u001a\u00020\b2\b\b\u0002\u0010\\\u001a\u00020KJ\u000e\u0010^\u001a\u00020I2\u0006\u0010R\u001a\u00020\u000eJ\u0010\u0010_\u001a\u00020I2\u0006\u0010_\u001a\u00020`H\u0016J\u001e\u0010a\u001a\u00020I2\u0006\u0010b\u001a\u00020c2\u000e\b\u0002\u0010d\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0007J\u0006\u0010e\u001a\u00020IR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082.\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0010R\u001d\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00180\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0012\u0010\u001b\u001a\u00020\u001cX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\"\u0010\u001f\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020!\u0018\u00010 X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\"\u0010$\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020%\u0018\u00010 X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010#R\u001a\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u0011\u0010.\u001a\u00020/\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101R \u00102\u001a\b\u0012\u0004\u0012\u0002030\u0007X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u0010\u0010\"\u0004\b5\u00106R\u001e\u00109\u001a\u0002082\u0006\u00107\u001a\u000208@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u0010;R\u0011\u0010<\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b=\u0010>R\"\u0010?\u001a\u0004\u0018\u00010)2\b\u00107\u001a\u0004\u0018\u00010)@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b@\u0010AR\u0011\u0010B\u001a\u00020C\u00a2\u0006\b\n\u0000\u001a\u0004\bD\u0010ER\u001e\u0010F\u001a\u00020C2\u0006\u00107\u001a\u00020C@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\bG\u0010ER \u0010H\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020I0(\u0012\u0004\u0012\u00020\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010J\u001a\u00020KX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bL\u0010M\"\u0004\bN\u0010O\u00a8\u0006h"}, d2={"Lcom/marcpg/pillarperil/game/Game;", "Lcom/marcpg/pillarperil/util/Ticking;", "id", "", "center", "Lorg/bukkit/Location;", "bukkitPlayers", "", "Lorg/bukkit/entity/Player;", "<init>", "(Ljava/lang/String;Lorg/bukkit/Location;Ljava/util/List;)V", "getId", "()Ljava/lang/String;", "initialPlayers", "Lcom/marcpg/pillarperil/player/PillarPlayer;", "getInitialPlayers", "()Ljava/util/List;", "initialTarget", "Lcom/marcpg/libpg/display/ForwardingMinecraftReceiver;", "players", "", "getPlayers", "deathTimes", "", "", "getDeathTimes", "()Ljava/util/Map;", "info", "Lcom/marcpg/pillarperil/game/util/GameInfo;", "getInfo", "()Lcom/marcpg/pillarperil/game/util/GameInfo;", "scoreboard", "Lkotlin/Function1;", "Lcom/marcpg/libpg/display/SimpleScoreboard;", "getScoreboard", "()Lkotlin/jvm/functions/Function1;", "actionBar", "Lcom/marcpg/libpg/display/SimpleActionBar;", "getActionBar", "bossBarCreator", "Lkotlin/Function0;", "Lcom/marcpg/libpg/display/SimpleBossBar;", "getBossBarCreator", "()Lkotlin/jvm/functions/Function0;", "getCenter", "()Lorg/bukkit/Location;", "world", "Lorg/bukkit/World;", "getWorld", "()Lorg/bukkit/World;", "items", "Lorg/bukkit/inventory/ItemType;", "getItems", "setItems", "(Ljava/util/List;)V", "value", "Lcom/marcpg/pillarperil/generation/Buildings;", "buildings", "getBuildings", "()Lcom/marcpg/pillarperil/generation/Buildings;", "startingTick", "getStartingTick", "()I", "bossBar", "getBossBar", "()Lcom/marcpg/libpg/display/SimpleBossBar;", "timeLeft", "Lcom/marcpg/libpg/data/time/Time;", "getTimeLeft", "()Lcom/marcpg/libpg/data/time/Time;", "itemCountdown", "getItemCountdown", "tickEvents", "", "ending", "", "getEnding", "()Z", "setEnding", "(Z)V", "init", "addItem", "player", "msg", "warn", "addTickEvent", "interval", "event", "intervalTicks", "", "target", "Lcom/marcpg/libpg/display/MinecraftReceiver;", "onlyAlive", "bukkitPlayer", "eliminate", "tick", "Lcom/marcpg/pillarperil/util/Ticking$Tick;", "end", "cause", "Lcom/marcpg/pillarperil/game/Game$EndingCause;", "winners", "clear", "Companion", "EndingCause", "PillarPeril"})
@SourceDebugExtension(value={"SMAP\nGame.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Game.kt\ncom/marcpg/pillarperil/game/Game\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,282:1\n2756#2:283\n1563#2:285\n1634#2,3:286\n1869#2,2:289\n774#2:291\n865#2,2:292\n1878#2,3:294\n1869#2,2:297\n1068#2:309\n1878#2,3:310\n1869#2,2:313\n1869#2,2:315\n1#3:284\n1#3:308\n536#4:299\n521#4,6:300\n536#4:317\n521#4,6:318\n216#5,2:306\n*S KotlinDebug\n*F\n+ 1 Game.kt\ncom/marcpg/pillarperil/game/Game\n*L\n102#1:283\n110#1:285\n110#1:286,3\n111#1:289,2\n117#1:291\n117#1:292,2\n120#1:294,3\n194#1:297,2\n258#1:309\n258#1:310,3\n262#1:313,2\n277#1:315,2\n102#1:284\n203#1:299\n203#1:300,6\n169#1:317\n169#1:318,6\n203#1:306,2\n*E\n"})
public abstract class Game
implements Ticking {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String id;
    @NotNull
    private final List<Player> bukkitPlayers;
    @NotNull
    private final List<PillarPlayer> initialPlayers;
    private ForwardingMinecraftReceiver initialTarget;
    @NotNull
    private final List<PillarPlayer> players;
    @NotNull
    private final Map<PillarPlayer, Integer> deathTimes;
    @Nullable
    private final Function1<PillarPlayer, SimpleScoreboard> scoreboard;
    @Nullable
    private final Function1<PillarPlayer, SimpleActionBar> actionBar;
    @NotNull
    private final Function0<SimpleBossBar> bossBarCreator;
    @NotNull
    private final Location center;
    @NotNull
    private final World world;
    public List<? extends ItemType> items;
    private Buildings buildings;
    private final int startingTick;
    @Nullable
    private SimpleBossBar bossBar;
    @NotNull
    private final Time timeLeft;
    @NotNull
    private Time itemCountdown;
    @NotNull
    private final Map<Function0<Unit>, Integer> tickEvents;
    private boolean ending;
    @NotNull
    private static final List<TextColor> itemNowColor;
    @NotNull
    private static final List<TextColor> itemTimeColor;

    public Game(@NotNull String id, @NotNull Location center, @NotNull List<? extends Player> bukkitPlayers) {
        Intrinsics.checkNotNullParameter(id, "id");
        Intrinsics.checkNotNullParameter(center, "center");
        Intrinsics.checkNotNullParameter(bukkitPlayers, "bukkitPlayers");
        this.id = id;
        this.bukkitPlayers = bukkitPlayers;
        this.initialPlayers = new ArrayList();
        this.players = new ArrayList();
        this.deathTimes = new LinkedHashMap();
        this.scoreboard = arg_0 -> Game.scoreboard$lambda$0(this, arg_0);
        this.actionBar = arg_0 -> Game.actionBar$lambda$0(this, arg_0);
        this.bossBarCreator = () -> Game.bossBarCreator$lambda$0(this);
        Location location = center.clone();
        Intrinsics.checkNotNullExpressionValue(location, "clone(...)");
        this.center = location;
        World world = center.getWorld();
        Intrinsics.checkNotNullExpressionValue(world, "getWorld(...)");
        this.world = world;
        this.startingTick = Bukkit.getCurrentTick();
        this.timeLeft = new Time(0L, false, 3, null);
        this.itemCountdown = new Time(0L, true);
        this.tickEvents = new LinkedHashMap();
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    @NotNull
    public final List<PillarPlayer> getInitialPlayers() {
        return this.initialPlayers;
    }

    @NotNull
    public final List<PillarPlayer> getPlayers() {
        return this.players;
    }

    @NotNull
    public final Map<PillarPlayer, Integer> getDeathTimes() {
        return this.deathTimes;
    }

    @NotNull
    public abstract GameInfo getInfo();

    @Nullable
    public Function1<PillarPlayer, SimpleScoreboard> getScoreboard() {
        return this.scoreboard;
    }

    @Nullable
    public Function1<PillarPlayer, SimpleActionBar> getActionBar() {
        return this.actionBar;
    }

    @NotNull
    public Function0<SimpleBossBar> getBossBarCreator() {
        return this.bossBarCreator;
    }

    @NotNull
    public final Location getCenter() {
        return this.center;
    }

    @NotNull
    public final World getWorld() {
        return this.world;
    }

    @NotNull
    public final List<ItemType> getItems() {
        List<ItemType> list = this.items;
        if (list != null) {
            return list;
        }
        Intrinsics.throwUninitializedPropertyAccessException("items");
        return null;
    }

    public final void setItems(@NotNull List<? extends ItemType> list) {
        Intrinsics.checkNotNullParameter(list, "<set-?>");
        this.items = list;
    }

    @NotNull
    public final Buildings getBuildings() {
        Buildings buildings = this.buildings;
        if (buildings != null) {
            return buildings;
        }
        Intrinsics.throwUninitializedPropertyAccessException("buildings");
        return null;
    }

    public final int getStartingTick() {
        return this.startingTick;
    }

    @Nullable
    public final SimpleBossBar getBossBar() {
        return this.bossBar;
    }

    @NotNull
    public final Time getTimeLeft() {
        return this.timeLeft;
    }

    @NotNull
    public final Time getItemCountdown() {
        return this.itemCountdown;
    }

    public final boolean getEnding() {
        return this.ending;
    }

    public final void setEnding(boolean bl) {
        this.ending = bl;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void init() {
        this.center.setY(Configuration.INSTANCE.getPlatformHeight() + 1.0);
        $this$onEach$iv = this.bukkitPlayers;
        $i$f$onEach = false;
        $this$onEach_u24lambda_u240$iv = var3_3 = $this$onEach$iv;
        $i$a$-apply-CollectionsKt___CollectionsKt$onEach$1$iv = false;
        for (T element$iv : $this$onEach_u24lambda_u240$iv) {
            it = (Player)element$iv;
            $i$a$-onEach-Game$init$1 = false;
            QueueManager.INSTANCE.remove(it);
            it.setGameMode(GameMode.SURVIVAL);
            it.clearActivePotionEffects();
            it.getInventory().clear();
            it.setHealth(20.0);
        }
        $this$map$iv = var3_3;
        $i$f$map = false;
        var3_3 = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        $i$f$mapTo = false;
        var6_9 = $this$mapTo$iv$iv.iterator();
        while (var6_9.hasNext()) {
            item$iv$iv = var6_9.next();
            it = (Player)item$iv$iv;
            var10_16 = destination$iv$iv;
            $i$a$-map-Game$init$2 = false;
            var10_16.add(new PillarPlayer(it, this));
        }
        $this$forEach$iv = (List)destination$iv$iv;
        $i$f$forEach = false;
        for (T element$iv : $this$forEach$iv) {
            it = (PillarPlayer)element$iv;
            $i$a$-forEach-Game$init$3 = false;
            v0 = this.initialPlayers;
            Intrinsics.checkNotNull(v0, "null cannot be cast to non-null type kotlin.collections.MutableList<com.marcpg.pillarperil.player.PillarPlayer>");
            ((Collection)TypeIntrinsics.asMutableList(v0)).add(it);
            ((Collection)this.players).add(it);
        }
        this.initialTarget = MinecraftReceiverKt.receiver((Collection<? extends MinecraftReceiver>)CollectionsKt.toList((Iterable)this.initialPlayers));
        v1 = Registry.ITEM;
        Intrinsics.checkNotNullExpressionValue(v1, "ITEM");
        $this$forEach$iv = (Iterable)v1;
        var10_16 = this;
        $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            it = (ItemType)element$iv$iv /* !! */ ;
            $i$a$-filter-Game$init$4 = false;
            if (Intrinsics.areEqual(it, ItemType.AIR) || !this.world.isEnabled((FeatureDependant)it)) ** GOTO lbl-1000
            v2 = this.getInfo().getAdditionalFilter();
            Intrinsics.checkNotNull(it);
            if (v2.invoke((ItemType)it).booleanValue()) {
                v3 = true;
            } else lbl-1000:
            // 2 sources

            {
                v3 = false;
            }
            if (!v3) continue;
            destination$iv$iv.add(element$iv$iv /* !! */ );
        }
        var10_16.setItems(CollectionsKt.toList((List)destination$iv$iv));
        this.buildings = new Buildings(this, (HorizontalGen)this.getInfo().getHorGen().invoke().getGenConstructor().invoke(this), (VerticalGen)this.getInfo().getVertGen().invoke().getGenConstructor().invoke(this));
        $this$forEachIndexed$iv = this.getBuildings().generate();
        $i$f$forEachIndexed = false;
        index$iv = 0;
        for (T item$iv : $this$forEachIndexed$iv) {
            if ((var6_11 = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            element$iv$iv /* !! */  = (Location)item$iv;
            i = var6_11;
            $i$a$-forEachIndexed-Game$init$5 = false;
            v4 = this.players.get(i);
            v5 = l.clone().add(0.0, 1.0, 0.0).toCenterLocation();
            Intrinsics.checkNotNullExpressionValue(v5, "toCenterLocation(...)");
            PlayerMinecraftReceiverKt.teleport(v4, v5);
        }
        if (this.getInfo().getShowBossBar().invoke().booleanValue()) {
            v6 = this.bossBar = this.getBossBarCreator().invoke();
            if (v6 != null) {
                PlayerMinecraftReceiverKt.start(v6);
            }
        }
        this.timeLeft.set((Quantity)this.getInfo().getTimeLimit().invoke());
        this.itemCountdown.set(((Number)this.getInfo().getItemCountdown().invoke()).longValue());
        GameManager.INSTANCE.add(this);
        this.info("Initialized the game.");
    }

    public void addItem(@NotNull PillarPlayer player) {
        Intrinsics.checkNotNullParameter(player, "player");
        PillarPlayer.giveItems$default(player, this.getItems(), 0, 2, null);
    }

    public final void info(@NotNull String msg) {
        Intrinsics.checkNotNullParameter(msg, "msg");
        PillarPeril.Companion.getLOG().info("[G-" + this.id + "] " + msg);
    }

    public final void warn(@NotNull String msg) {
        Intrinsics.checkNotNullParameter(msg, "msg");
        PillarPeril.Companion.getLOG().warn("[G-" + this.id + "] " + msg);
    }

    protected final void addTickEvent(@NotNull Time interval, @NotNull Function0<Unit> event) {
        Intrinsics.checkNotNullParameter(interval, "interval");
        Intrinsics.checkNotNullParameter(event, "event");
        this.addTickEvent(interval.get() * 20L, event);
    }

    protected final void addTickEvent(long intervalTicks, @NotNull Function0<Unit> event) {
        Intrinsics.checkNotNullParameter(event, "event");
        this.tickEvents.put(event, (int)intervalTicks);
    }

    @NotNull
    public final MinecraftReceiver target(boolean onlyAlive) {
        MinecraftReceiver minecraftReceiver;
        if (onlyAlive) {
            minecraftReceiver = MinecraftReceiverKt.receiver((Collection<? extends MinecraftReceiver>)this.players);
        } else {
            ForwardingMinecraftReceiver forwardingMinecraftReceiver = this.initialTarget;
            if (forwardingMinecraftReceiver == null) {
                Intrinsics.throwUninitializedPropertyAccessException("initialTarget");
                forwardingMinecraftReceiver = null;
            }
            minecraftReceiver = forwardingMinecraftReceiver;
        }
        return minecraftReceiver;
    }

    public static /* synthetic */ MinecraftReceiver target$default(Game game, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: target");
        }
        if ((n & 1) != 0) {
            bl = true;
        }
        return game.target(bl);
    }

    @Nullable
    public final PillarPlayer player(@NotNull Player bukkitPlayer, boolean onlyAlive) {
        Intrinsics.checkNotNullParameter(bukkitPlayer, "bukkitPlayer");
        for (PillarPlayer player : onlyAlive ? this.players : this.initialPlayers) {
            if (!Intrinsics.areEqual(player.uuid(), bukkitPlayer.getUniqueId())) continue;
            return player;
        }
        return null;
    }

    public static /* synthetic */ PillarPlayer player$default(Game game, Player player, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: player");
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        return game.player(player, bl);
    }

    public final void eliminate(@NotNull PillarPlayer player) {
        Intrinsics.checkNotNullParameter(player, "player");
        if (this.ending || !this.players.contains(player)) {
            return;
        }
        ((Collection)this.players).remove(player);
        this.info(player + " got eliminated.");
        this.deathTimes.put(player, Bukkit.getCurrentTick());
        boolean win = this.players.size() <= 1;
        List winners = CollectionsKt.toList((Iterable)this.players);
        PaperGlobalFunctionsKt.bukkitRunLater(19L, arg_0 -> Game.eliminate$lambda$0(this, win, winners, player, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void tick(@NotNull Ticking.Tick tick) {
        void $this$filterTo$iv$iv;
        Object element$iv;
        Iterator iterator2;
        boolean $i$f$forEach;
        Object $this$forEach$iv;
        Intrinsics.checkNotNullParameter(tick, "tick");
        if (this.ending) {
            return;
        }
        if (tick.isSecond(this.startingTick)) {
            this.itemCountdown.dec();
            if (this.itemCountdown.get() <= 0L) {
                $this$forEach$iv = this.players;
                $i$f$forEach = false;
                iterator2 = $this$forEach$iv.iterator();
                while (iterator2.hasNext()) {
                    element$iv = iterator2.next();
                    PillarPlayer it = (PillarPlayer)element$iv;
                    boolean bl = false;
                    this.addItem(it);
                }
                this.itemCountdown.set(((Number)this.getInfo().getItemCountdown().invoke()).longValue());
            }
            this.timeLeft.dec();
            if (this.timeLeft.get() <= 0L) {
                Game.end$default(this, EndingCause.TIME_OVER, null, 2, null);
            }
        }
        Map<Function0<Unit>, Integer> $this$filter$iv = this.tickEvents;
        boolean $i$f$filter = false;
        iterator2 = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator bl = $this$filterTo$iv$iv.entrySet().iterator();
        while (bl.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = bl.next();
            boolean bl2 = false;
            if (!tick.isInInterval(this.startingTick, ((Number)it.getValue()).intValue())) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        $this$forEach$iv = destination$iv$iv;
        $i$f$forEach = false;
        iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Object it = element$iv = iterator2.next();
            boolean bl3 = false;
            ((Function0)it.getKey()).invoke();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void end(@NotNull EndingCause cause, @NotNull List<PillarPlayer> winners) {
        Intrinsics.checkNotNullParameter((Object)cause, "cause");
        Intrinsics.checkNotNullParameter(winners, "winners");
        if (this.ending) {
            return;
        }
        this.ending = true;
        for (PillarPlayer p : this.initialPlayers) {
            void $this$forEachIndexed$iv;
            Object object;
            switch (WhenMappings.$EnumSwitchMapping$0[cause.ordinal()]) {
                case 1: {
                    p.showTitle(Title.title((Component)AdventureExtensionsKt.component$default(p.locale(), "info.end.force.title", (TextColor)NamedTextColor.YELLOW, null, 4, null), (Component)AdventureExtensionsKt.component$default(p.locale(), "info.end.force.subtitle", (TextColor)NamedTextColor.RED, null, 4, null)));
                    this.warn("Stopped game forcefully.");
                    break;
                }
                case 2: {
                    p.showTitle(Title.title((Component)AdventureExtensionsKt.component$default(p.locale(), "info.end.time-over.title", (TextColor)NamedTextColor.GREEN, null, 4, null), (Component)AdventureExtensionsKt.component$default(p.locale(), "info.end.time-over.subtitle", (TextColor)NamedTextColor.YELLOW, null, 4, null)));
                    this.info("Stopped game because the time is up.");
                    break;
                }
                case 3: {
                    int n;
                    String[] stringArray = new String[]{CollectionsKt.joinToString$default(winners, " & ", null, null, 0, null, null, 62, null)};
                    Component component = AdventureExtensionsKt.component$default(p.locale(), "info.end.last-standing.title", stringArray, (TextColor)NamedTextColor.GREEN, null, 8, null);
                    stringArray = new String[1];
                    Iterable iterable = winners;
                    int n2 = 0;
                    String[] stringArray2 = stringArray;
                    String string = "info.end.last-standing.subtitle";
                    Locale locale = p.locale();
                    Component component2 = component;
                    PillarPlayer pillarPlayer = p;
                    int n3 = 0;
                    Iterator iterator2 = iterable.iterator();
                    while (iterator2.hasNext()) {
                        void it;
                        object = iterator2.next();
                        PillarPlayer pillarPlayer2 = (PillarPlayer)object;
                        n = n3;
                        boolean bl = false;
                        int n4 = it.getKills();
                        n3 = n + n4;
                    }
                    n = n3;
                    stringArray2[n2] = String.valueOf(n);
                    pillarPlayer.showTitle(Title.title((Component)component2, (Component)AdventureExtensionsKt.component$default(locale, string, stringArray, (TextColor)NamedTextColor.YELLOW, null, 8, null)));
                    this.info("Stopped game because " + CollectionsKt.joinToString$default(winners, null, null, null, 0, null, null, 63, null) + " won.");
                    break;
                }
                case 4: {
                    String[] stringArray = new String[]{CollectionsKt.joinToString$default(winners, " & ", null, null, 0, null, null, 62, null)};
                    p.showTitle(Title.title((Component)AdventureExtensionsKt.component$default(p.locale(), "info.end.draw.title", (TextColor)NamedTextColor.GREEN, null, 4, null), (Component)AdventureExtensionsKt.component$default(p.locale(), "info.end.draw.subtitle", stringArray, (TextColor)NamedTextColor.YELLOW, null, 8, null)));
                    this.info("Stopped game because " + CollectionsKt.joinToString$default(winners, " & ", null, null, 0, null, null, 62, null) + " died at the same time, resulting in a draw.");
                    break;
                }
                case 5: {
                    NamedTextColor namedTextColor = NamedTextColor.RED;
                    Intrinsics.checkNotNullExpressionValue(namedTextColor, "RED");
                    Component component = (Component)AdventureGlobalFunctionsKt.component("Nobody wins!", (TextColor)namedTextColor);
                    NamedTextColor namedTextColor2 = NamedTextColor.GRAY;
                    Intrinsics.checkNotNullExpressionValue(namedTextColor2, "GRAY");
                    p.showTitle(Title.title((Component)component, (Component)((Component)AdventureGlobalFunctionsKt.component("An error occurred, resulting in no winner.", (TextColor)namedTextColor2))));
                    throw new IllegalStateException(("Stopped game because " + CollectionsKt.joinToString$default(winners, null, null, null, 0, null, null, 63, null) + " of an error. Error: #001").toString());
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            p.sendMessage(((TextComponent)((TextComponent)((TextComponent)AdventureGlobalFunctionsKt.component("=== ").append(AdventureExtensionsKt.component$default(p.locale(), "info.end.time-over.stats", null, null, 6, null))).append((Component)AdventureGlobalFunctionsKt.component(" ==="))).color((TextColor)NamedTextColor.GREEN)).decorate(TextDecoration.BOLD));
            Iterable $this$sortedByDescending$iv = this.initialPlayers;
            boolean $i$f$sortedByDescending = false;
            $this$sortedByDescending$iv = CollectionsKt.sortedWith($this$sortedByDescending$iv, new Comparator(){

                public final int compare(T a, T b) {
                    PillarPlayer it = (PillarPlayer)b;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.getKills());
                    it = (PillarPlayer)a;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues(comparable2, it.getKills());
                }
            });
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void sorted2;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                object = (PillarPlayer)item$iv;
                int i = n;
                boolean bl = false;
                p.sendMessage(AdventureGlobalFunctionsKt.miniMessage("<dark_gray>" + (i + 1) + ". <gray>" + sorted2.getPlayer().getName() + " <dark_gray>(<gold>" + sorted2.getKills() + "<red>\u2694<dark_gray>)", new TagResolver[0]));
            }
        }
        Iterable $this$forEach$iv = Configuration.INSTANCE.getEndingCommands();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PlaceholderNameGetter it = (PlaceholderNameGetter)element$iv;
            boolean bl = false;
            Pair[] pairArray = new Pair[8];
            pairArray[0] = TuplesKt.to("id", this.id);
            pairArray[1] = TuplesKt.to("mode", this.getInfo().getMode().getGameInfo().getNamespace());
            pairArray[2] = TuplesKt.to("players", this.initialPlayers.size());
            String string = cause.name().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
            pairArray[3] = TuplesKt.to("cause", string);
            pairArray[4] = TuplesKt.to("world", this.center.getWorld().getName());
            pairArray[5] = TuplesKt.to("x", this.center.getX());
            pairArray[6] = TuplesKt.to("y", this.center.getY());
            pairArray[7] = TuplesKt.to("z", this.center.getZ());
            PillarPeril.Companion.sendCommand(it.invoke(pairArray));
        }
        this.clear();
    }

    public static /* synthetic */ void end$default(Game game, EndingCause endingCause, List list, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: end");
        }
        if ((n & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        game.end(endingCause, list);
    }

    public final void clear() {
        block1: {
            GameManager.INSTANCE.remove(this);
            Iterable $this$forEach$iv = this.initialPlayers;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PillarPlayer it = (PillarPlayer)element$iv;
                boolean bl = false;
                it.clear(true);
            }
            this.getBuildings().reset();
            SimpleBossBar simpleBossBar = this.bossBar;
            if (simpleBossBar == null) break block1;
            simpleBossBar.stop();
        }
    }

    private static final SimpleScoreboard scoreboard$lambda$0(Game this$0, PillarPlayer p) {
        Intrinsics.checkNotNullParameter(p, "p");
        MinecraftReceiver minecraftReceiver = p;
        Component component = MiniMessage.miniMessage().deserialize((Object)"<bold><gradient:#71CCF8:#FC91EC:#F87171>Pillar Peril");
        Intrinsics.checkNotNullExpressionValue(component, "deserialize(...)");
        ScoreboardEntry[] scoreboardEntryArray = new ScoreboardEntry[4];
        Component component2 = AdventureExtensionsKt.component$default(p.locale(), "scoreboard.mode", null, null, 6, null).style(this$0.getInfo().getKeyStyle().invoke());
        Intrinsics.checkNotNullExpressionValue(component2, "style(...)");
        Component component3 = AdventureGlobalFunctionsKt.component(this$0.getInfo().name(p.locale())).style(this$0.getInfo().getValueStyle());
        Intrinsics.checkNotNullExpressionValue(component3, "style(...)");
        scoreboardEntryArray[0] = new StaticValueScoreboardEntry(component2, component3);
        Component component4 = AdventureExtensionsKt.component$default(p.locale(), "scoreboard.name", null, null, 6, null).style(this$0.getInfo().getKeyStyle().invoke());
        Intrinsics.checkNotNullExpressionValue(component4, "style(...)");
        Component component5 = AdventureGlobalFunctionsKt.component(p.name()).style(this$0.getInfo().getValueStyle());
        Intrinsics.checkNotNullExpressionValue(component5, "style(...)");
        scoreboardEntryArray[1] = new StaticValueScoreboardEntry(component4, component5);
        Component component6 = AdventureExtensionsKt.component$default(p.locale(), "scoreboard.time", null, null, 6, null).style(this$0.getInfo().getKeyStyle().invoke());
        Intrinsics.checkNotNullExpressionValue(component6, "style(...)");
        scoreboardEntryArray[2] = new ValueScoreboardEntry(component6, arg_0 -> Game.scoreboard$lambda$0$0(this$0, arg_0));
        Component component7 = AdventureExtensionsKt.component$default(p.locale(), "scoreboard.kills", null, null, 6, null).style(this$0.getInfo().getKeyStyle().invoke());
        Intrinsics.checkNotNullExpressionValue(component7, "style(...)");
        scoreboardEntryArray[3] = new ValueScoreboardEntry(component7, arg_0 -> Game.scoreboard$lambda$0$1(p, this$0, arg_0));
        return new SimpleScoreboard(minecraftReceiver, 5L, component, scoreboardEntryArray);
    }

    private static final Component scoreboard$lambda$0$0(Game this$0, Locale it) {
        Intrinsics.checkNotNullParameter(it, "it");
        Component component = AdventureGlobalFunctionsKt.component(this$0.timeLeft.getOneUnitFormatted()).style(this$0.getInfo().getValueStyle());
        Intrinsics.checkNotNullExpressionValue(component, "style(...)");
        return component;
    }

    private static final Component scoreboard$lambda$0$1(PillarPlayer $p, Game this$0, Locale it) {
        Intrinsics.checkNotNullParameter(it, "it");
        Component component = AdventureGlobalFunctionsKt.component(String.valueOf($p.getKills())).style(this$0.getInfo().getValueStyle());
        Intrinsics.checkNotNullExpressionValue(component, "style(...)");
        return component;
    }

    private static final GradientActionBar actionBar$lambda$0(Game this$0, PillarPlayer p) {
        Intrinsics.checkNotNullParameter(p, "p");
        return new GradientActionBar(p, 5L, 0.1, arg_0 -> Game.actionBar$lambda$0$0(this$0, p, arg_0));
    }

    private static final Pair actionBar$lambda$0$0(Game this$0, PillarPlayer $p, Locale it) {
        Pair<Component, List<TextColor>> pair;
        Intrinsics.checkNotNullParameter(it, "it");
        if (this$0.itemCountdown.get() == 0L) {
            pair = TuplesKt.to(AdventureExtensionsKt.component$default($p.locale(), "actionbar.now", null, null, 6, null), itemNowColor);
        } else {
            String[] stringArray = new String[]{this$0.itemCountdown.getPreciselyFormatted()};
            pair = TuplesKt.to(AdventureExtensionsKt.component$default($p.locale(), "actionbar.time", stringArray, null, null, 12, null), itemTimeColor);
        }
        return pair;
    }

    private static final SimpleBossBar bossBarCreator$lambda$0(Game this$0) {
        return new SimpleBossBar(this$0.target(false), 20L, arg_0 -> Game.bossBarCreator$lambda$0$0(this$0, arg_0), () -> Game.bossBarCreator$lambda$0$1(this$0), arg_0 -> Game.bossBarCreator$lambda$0$2(this$0, arg_0), Game::bossBarCreator$lambda$0$3);
    }

    private static final Component bossBarCreator$lambda$0$0(Game this$0, Locale it) {
        Intrinsics.checkNotNullParameter(it, "it");
        Component component = AdventureGlobalFunctionsKt.component("=== " + this$0.itemCountdown.getOneUnitFormatted() + " ===").style(this$0.getInfo().getKeyStyle().invoke());
        Intrinsics.checkNotNullExpressionValue(component, "style(...)");
        return component;
    }

    private static final float bossBarCreator$lambda$0$1(Game this$0) {
        return (float)this$0.itemCountdown.get() / (float)((Number)this$0.getInfo().getItemCountdown().invoke()).longValue();
    }

    private static final BossBar.Color bossBarCreator$lambda$0$2(Game this$0, float it) {
        return Companion.getColor((float)this$0.itemCountdown.get() / (float)((Number)this$0.getInfo().getItemCountdown().invoke()).longValue());
    }

    private static final BossBar.Overlay bossBarCreator$lambda$0$3(float it) {
        return BossBar.Overlay.NOTCHED_10;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit eliminate$lambda$0(Game this$0, boolean $win, List $winners, PillarPlayer $player, BukkitTask it) {
        Intrinsics.checkNotNullParameter(it, "it");
        if (!this$0.ending && $win) {
            void $this$filterTo$iv$iv;
            Iterator iterator2 = ((Iterable)this$0.deathTimes.entrySet()).iterator();
            if (!iterator2.hasNext()) {
                throw new NoSuchElementException();
            }
            Map.Entry it22 = (Map.Entry)iterator2.next();
            boolean bl = false;
            int it22 = ((Number)it22.getValue()).intValue();
            while (iterator2.hasNext()) {
                Map.Entry it32 = (Map.Entry)iterator2.next();
                $i$a$-maxOf-Game$eliminate$1$lastDeath$1 = false;
                int it32 = ((Number)it32.getValue()).intValue();
                if (it22 >= it32) continue;
                it22 = it32;
            }
            int lastDeath = it22;
            Map<PillarPlayer, Integer> $this$filter$iv = this$0.deathTimes;
            boolean $i$f$filter = false;
            Map<PillarPlayer, Integer> it32 = $this$filter$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$filterTo = false;
            Iterator iterator3 = $this$filterTo$iv$iv.entrySet().iterator();
            while (iterator3.hasNext()) {
                Map.Entry element$iv$iv;
                Map.Entry it3 = element$iv$iv = iterator3.next();
                boolean bl2 = false;
                if (!(((Number)it3.getValue()).intValue() + 19 >= lastDeath)) continue;
                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            List<PillarPlayer> drawWinners = CollectionsKt.toList(destination$iv$iv.keySet());
            if (Configuration.INSTANCE.getEnableDraws() && this$0.players.isEmpty() && !((Collection)drawWinners).isEmpty()) {
                this$0.end(EndingCause.DRAW, drawWinners);
            } else {
                this$0.end(EndingCause.LAST_STANDING, $winners);
            }
        }
        if (Configuration.INSTANCE.getRespawnAtConfig()) {
            $player.getPlayer().setGameMode(Configuration.INSTANCE.getSpawnGameMode());
            v0 = $player.getPlayer().teleport(Configuration.INSTANCE.getSpawnLocation());
        } else {
            $player.getPlayer().setGameMode(GameMode.SPECTATOR);
            v0 = $player.getPlayer().teleport(this$0.center);
        }
        return Unit.INSTANCE;
    }

    static {
        TextColor[] textColorArray = new TextColor[]{TextColor.color((int)43554), TextColor.color((int)0x11FF77)};
        itemNowColor = CollectionsKt.listOf(textColorArray);
        textColorArray = new TextColor[]{TextColor.color((int)8959), TextColor.color((int)0x3399FF)};
        itemTimeColor = CollectionsKt.listOf(textColorArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0006\u0010\u000e\u001a\u00020\u000fR\u001e\u0010\u0004\u001a\u0012\u0012\u000e\u0012\f0\u0006\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0002\b\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u0012\u0012\u000e\u0012\f0\u0006\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0002\b\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/marcpg/pillarperil/game/Game$Companion;", "", "<init>", "()V", "itemNowColor", "", "Lnet/kyori/adventure/text/format/TextColor;", "Lorg/jetbrains/annotations/NotNull;", "Lkotlin/jvm/internal/EnhancedNullability;", "itemTimeColor", "getColor", "Lnet/kyori/adventure/bossbar/BossBar$Color;", "left", "", "generateId", "", "PillarPeril"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BossBar.Color getColor(float left) {
            return (double)left < 0.1 ? BossBar.Color.WHITE : ((double)left < 0.2 ? BossBar.Color.BLUE : ((double)left < 0.4 ? BossBar.Color.GREEN : ((double)left < 0.6 ? BossBar.Color.YELLOW : ((double)left < 0.8 ? BossBar.Color.RED : BossBar.Color.PINK))));
        }

        @NotNull
        public final String generateId() {
            return Randomizer.INSTANCE.generateRandomString(16, "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz123456789");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\b\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lcom/marcpg/pillarperil/game/Game$EndingCause;", "", "<init>", "(Ljava/lang/String;I)V", "FORCE", "TIME_OVER", "LAST_STANDING", "DRAW", "ERROR", "PillarPeril"})
    public static final class EndingCause
    extends Enum<EndingCause> {
        public static final /* enum */ EndingCause FORCE = new EndingCause();
        public static final /* enum */ EndingCause TIME_OVER = new EndingCause();
        public static final /* enum */ EndingCause LAST_STANDING = new EndingCause();
        public static final /* enum */ EndingCause DRAW = new EndingCause();
        public static final /* enum */ EndingCause ERROR = new EndingCause();
        private static final /* synthetic */ EndingCause[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static EndingCause[] values() {
            return (EndingCause[])$VALUES.clone();
        }

        public static EndingCause valueOf(String value) {
            return Enum.valueOf(EndingCause.class, value);
        }

        @NotNull
        public static EnumEntries<EndingCause> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = endingCauseArray = new EndingCause[]{EndingCause.FORCE, EndingCause.TIME_OVER, EndingCause.LAST_STANDING, EndingCause.DRAW, EndingCause.ERROR};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[EndingCause.values().length];
            try {
                nArray[EndingCause.FORCE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EndingCause.TIME_OVER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EndingCause.LAST_STANDING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EndingCause.DRAW.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EndingCause.ERROR.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

