/*
 * Decompiled with CFR 0.152.
 */
package com.marcpg.pillarperil.event;

import com.marcpg.libpg.util.PaperGlobalFunctionsKt;
import com.marcpg.pillarperil.game.Game;
import com.marcpg.pillarperil.game.util.GameManager;
import com.marcpg.pillarperil.game.util.QueueManager;
import com.marcpg.pillarperil.player.PillarPlayer;
import com.marcpg.pillarperil.util.Configuration;
import com.marcpg.pillarperil.util.QueueMethod;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\tH\u0007J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u000bH\u0007J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\rH\u0007\u00a8\u0006\u000e"}, d2={"Lcom/marcpg/pillarperil/event/PlayerEvents;", "Lorg/bukkit/event/Listener;", "<init>", "()V", "onPlayerDeath", "", "event", "Lorg/bukkit/event/entity/PlayerDeathEvent;", "onPlayerMove", "Lorg/bukkit/event/player/PlayerMoveEvent;", "onPlayerJoin", "Lorg/bukkit/event/player/PlayerJoinEvent;", "onPlayerQuit", "Lorg/bukkit/event/player/PlayerQuitEvent;", "PillarPeril"})
public final class PlayerEvents
implements Listener {
    @NotNull
    public static final PlayerEvents INSTANCE = new PlayerEvents();

    private PlayerEvents() {
    }

    @EventHandler(ignoreCancelled=true)
    public final void onPlayerDeath(@NotNull PlayerDeathEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        PillarPlayer pillarPlayer = GameManager.player$default(GameManager.INSTANCE, player, false, 2, null);
        if (pillarPlayer == null) {
            return;
        }
        PillarPlayer player2 = pillarPlayer;
        if (player2.getGame().getEnding()) {
            return;
        }
        if (event.getPlayer().getKiller() != null) {
            Game game = player2.getGame();
            Player player3 = event.getPlayer().getKiller();
            Intrinsics.checkNotNull(player3);
            PillarPlayer pillarPlayer2 = game.player(player3, false);
            if (pillarPlayer2 != null) {
                PillarPlayer pillarPlayer3 = pillarPlayer2;
                int n = pillarPlayer3.getKills();
                pillarPlayer3.setKills(n + 1);
            }
        }
        player2.eliminate();
    }

    @EventHandler(ignoreCancelled=true)
    public final void onPlayerMove(@NotNull PlayerMoveEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (event.getTo().getY() < Configuration.INSTANCE.getDeathHeight()) {
            Player player = event.getPlayer();
            Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
            if (GameManager.player$default(GameManager.INSTANCE, player, false, 2, null) == null) {
                return;
            }
            event.getPlayer().setHealth(0.0);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public final void onPlayerJoin(@NotNull PlayerJoinEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (Configuration.INSTANCE.getQueueMethod() == QueueMethod.AUTO) {
            PaperGlobalFunctionsKt.bukkitRunLater(20L, arg_0 -> PlayerEvents.onPlayerJoin$lambda$0(event, arg_0));
        }
    }

    @EventHandler(ignoreCancelled=true)
    public final void onPlayerQuit(@NotNull PlayerQuitEvent event) {
        block0: {
            Intrinsics.checkNotNullParameter(event, "event");
            Player player = event.getPlayer();
            Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
            QueueManager.INSTANCE.remove(player);
            Player player2 = event.getPlayer();
            Intrinsics.checkNotNullExpressionValue(player2, "getPlayer(...)");
            PillarPlayer pillarPlayer = GameManager.player$default(GameManager.INSTANCE, player2, false, 2, null);
            if (pillarPlayer == null) break block0;
            pillarPlayer.eliminate();
        }
    }

    private static final Unit onPlayerJoin$lambda$0(PlayerJoinEvent $event, BukkitTask it) {
        Intrinsics.checkNotNullParameter(it, "it");
        if ($event.getPlayer().isOnline()) {
            Player player = $event.getPlayer();
            Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
            QueueManager.INSTANCE.add(player);
        }
        return Unit.INSTANCE;
    }
}

