/*
 * Decompiled with CFR 0.152.
 */
package com.marcpg.libpg.web;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.net.URL;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u001e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005J\u0016\u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ'\u0010\u000e\u001a\u0002H\u000f\"\u0004\b\u0000\u0010\u000f2\u0006\u0010\b\u001a\u00020\t2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u0011\u00a2\u0006\u0002\u0010\u0012R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/marcpg/libpg/web/Downloads;", "", "<init>", "()V", "DEFAULT_BUFFER_SIZE", "", "download", "", "url", "Ljava/net/URL;", "destination", "Ljava/io/File;", "bufferSize", "simpleDownload", "simpleGet", "T", "bodyHandler", "Ljava/net/http/HttpResponse$BodyHandler;", "(Ljava/net/URL;Ljava/net/http/HttpResponse$BodyHandler;)Ljava/lang/Object;", "base"})
public final class Downloads {
    @NotNull
    public static final Downloads INSTANCE = new Downloads();
    public static final int DEFAULT_BUFFER_SIZE = 1024;

    private Downloads() {
    }

    public final void download(@NotNull URL url, @NotNull File destination) {
        Intrinsics.checkNotNullParameter(url, "url");
        Intrinsics.checkNotNullParameter(destination, "destination");
        this.download(url, destination, 1024);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void download(@NotNull URL url, @NotNull File destination, int bufferSize) {
        Intrinsics.checkNotNullParameter(url, "url");
        Intrinsics.checkNotNullParameter(destination, "destination");
        Closeable closeable = Channels.newChannel(url.openStream());
        Throwable throwable = null;
        try {
            ReadableByteChannel channel = (ReadableByteChannel)closeable;
            boolean bl = false;
            Closeable closeable2 = new FileOutputStream(destination);
            Throwable throwable2 = null;
            try {
                FileOutputStream out = (FileOutputStream)closeable2;
                boolean bl2 = false;
                ByteBuffer buffer = ByteBuffer.allocate(bufferSize);
                FileChannel outputChannel = out.getChannel();
                while (channel.read(buffer) != -1) {
                    buffer.flip();
                    while (buffer.hasRemaining()) {
                        outputChannel.write(buffer);
                    }
                    buffer.clear();
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally(closeable2, throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void simpleDownload(@NotNull URL url, @NotNull File destination) {
        Intrinsics.checkNotNullParameter(url, "url");
        Intrinsics.checkNotNullParameter(destination, "destination");
        Closeable closeable = Channels.newChannel(url.openStream());
        Throwable throwable = null;
        try {
            long l;
            ReadableByteChannel inputChannel = (ReadableByteChannel)closeable;
            boolean bl = false;
            Closeable closeable2 = new FileOutputStream(destination);
            Throwable throwable2 = null;
            try {
                FileOutputStream output = (FileOutputStream)closeable2;
                boolean bl2 = false;
                l = output.getChannel().transferFrom(inputChannel, 0L, Long.MAX_VALUE);
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally(closeable2, throwable2);
            }
            long l2 = l;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
    }

    public final <T> T simpleGet(@NotNull URL url, @NotNull HttpResponse.BodyHandler<T> bodyHandler) {
        Intrinsics.checkNotNullParameter(url, "url");
        Intrinsics.checkNotNullParameter(bodyHandler, "bodyHandler");
        HttpRequest request = HttpRequest.newBuilder(url.toURI()).GET().build();
        return HttpClient.newHttpClient().send(request, bodyHandler).body();
    }
}

