/*
 * Decompiled with CFR 0.152.
 */
package com.marcpg.libpg.util;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import net.kyori.adventure.util.TriState;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.WorldCreator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007J\u0018\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007\u00a8\u0006\u000b"}, d2={"Lcom/marcpg/libpg/util/WorldUtils;", "", "<init>", "()V", "copy", "", "base", "", "target", "copyAndLoad", "Lorg/bukkit/World;", "KtLibPG-Paper"})
public final class WorldUtils {
    @NotNull
    public static final WorldUtils INSTANCE = new WorldUtils();

    private WorldUtils() {
    }

    public final void copy(@NotNull String base, @NotNull String target) {
        Intrinsics.checkNotNullParameter(base, "base");
        Intrinsics.checkNotNullParameter(target, "target");
        try {
            Path from = Bukkit.getWorldContainer().toPath().resolve(base);
            Path to = Bukkit.getWorldContainer().toPath().resolve(target);
            Intrinsics.checkNotNull(from);
            Intrinsics.checkNotNull(to);
            PathsKt.copyToRecursively$default(from, to, null, false, true, 2, null);
            Files.deleteIfExists(to.resolve("uid.dat"));
            Files.deleteIfExists(to.resolve("session.lock"));
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Nullable
    public final World copyAndLoad(@NotNull String base, @NotNull String target) {
        Intrinsics.checkNotNullParameter(base, "base");
        Intrinsics.checkNotNullParameter(target, "target");
        this.copy(base, target);
        return Bukkit.createWorld((WorldCreator)WorldCreator.name((String)target).keepSpawnLoaded(TriState.FALSE));
    }
}

