/*
 * Decompiled with CFR 0.152.
 */
package com.marcpg.libpg.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0010\r\n\u0000\n\u0002\u0010 \n\u0002\b\u000b\u001a\n\u0010\u0002\u001a\u00020\u0003*\u00020\u0003\u001a\n\u0010\u0005\u001a\u00020\u0006*\u00020\u0007\u001a\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\t*\u00020\u00032\b\b\u0002\u0010\n\u001a\u00020\u0006\u001a\u0014\u0010\u000b\u001a\u00020\u0003*\u00020\u00032\b\b\u0002\u0010\f\u001a\u00020\u0006\u001a\n\u0010\r\u001a\u00020\u0003*\u00020\u0003\u001a\n\u0010\u000e\u001a\u00020\u0003*\u00020\u0003\u001a\u001b\u0010\u000f\u001a\u0004\u0018\u0001H\u0010\"\b\b\u0000\u0010\u0010*\u00020\u0007*\u0002H\u0010\u00a2\u0006\u0002\u0010\u0011\u001a\u0012\u0010\u0012\u001a\u00020\u0006*\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0003\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"splitRegex", "Lkotlin/text/Regex;", "toTitleCase", "", "NUMBER_REGEX", "extractNumber", "", "", "lineWrap", "", "maxWidth", "truncate", "maxLength", "escapeJson", "unescapeJson", "blankToNull", "T", "(Ljava/lang/CharSequence;)Ljava/lang/CharSequence;", "commonPrefixLength", "other", "base"})
@SourceDebugExtension(value={"SMAP\nStringExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StringExtensions.kt\ncom/marcpg/libpg/util/StringExtensionsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,124:1\n774#2:125\n865#2,2:126\n739#2,9:129\n1#3:128\n*S KotlinDebug\n*F\n+ 1 StringExtensions.kt\ncom/marcpg/libpg/util/StringExtensionsKt\n*L\n17#1:125\n17#1:126,2\n44#1:129,9\n*E\n"})
public final class StringExtensionsKt {
    @NotNull
    private static final Regex splitRegex = new Regex("[_\\-\\s]+");
    @NotNull
    private static final Regex NUMBER_REGEX = new Regex("\\d+");

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String toTitleCase(@NotNull String $this$toTitleCase) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$toTitleCase, "<this>");
        CharSequence charSequence = $this$toTitleCase;
        Regex regex = splitRegex;
        int n = 0;
        Iterable $this$filter$iv = regex.split(charSequence, n);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = !StringsKt.isBlank(it);
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.joinToString$default((List)destination$iv$iv, " ", null, null, 0, null, StringExtensionsKt::toTitleCase$lambda$2, 30, null);
    }

    public static final int extractNumber(@NotNull CharSequence $this$extractNumber) {
        Intrinsics.checkNotNullParameter($this$extractNumber, "<this>");
        Object object = Regex.find$default(NUMBER_REGEX, $this$extractNumber, 0, 2, null);
        return object != null && (object = object.getValue()) != null ? Integer.parseInt((String)object) : 0;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<String> lineWrap(@NotNull String $this$lineWrap, int maxWidth) {
        List<String> list;
        void $this$dropLastWhile$iv;
        Intrinsics.checkNotNullParameter($this$lineWrap, "<this>");
        if (!(maxWidth > 0)) {
            boolean $i$a$-require-StringExtensionsKt$lineWrap$232 = false;
            String $i$a$-require-StringExtensionsKt$lineWrap$232 = "Maximum line length cannot be 0 or lower!";
            throw new IllegalArgumentException($i$a$-require-StringExtensionsKt$lineWrap$232.toString());
        }
        if (StringsKt.isBlank($this$lineWrap) || $this$lineWrap.length() <= maxWidth) {
            return CollectionsKt.listOf($this$lineWrap);
        }
        List lines = new ArrayList();
        StringBuilder currentLine = new StringBuilder();
        int currentWidth = 0;
        Object object = $this$lineWrap;
        Regex regex = new Regex("\\s+");
        int n = 0;
        object = regex.split((CharSequence)object, n);
        boolean $i$f$dropLastWhile = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv.hasPrevious()) {
                String it = (String)iterator$iv.previous();
                boolean bl = false;
                if (((CharSequence)it).length() == 0) continue;
                list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, iterator$iv.nextIndex() + 1);
                break;
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        for (String word : list) {
            if (currentWidth + word.length() + 1 > maxWidth) {
                String string = currentLine.toString();
                Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
                lines.add(((Object)StringsKt.trim((CharSequence)string)).toString());
                currentLine = new StringBuilder();
                currentWidth = 0;
            }
            currentLine.append(word).append(" ");
            currentWidth += word.length() + 1;
        }
        if (((CharSequence)currentLine).length() > 0) {
            String string = currentLine.toString();
            Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
            lines.add(string);
        }
        return lines;
    }

    public static /* synthetic */ List lineWrap$default(String string, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 48;
        }
        return StringExtensionsKt.lineWrap(string, n);
    }

    @NotNull
    public static final String truncate(@NotNull String $this$truncate, int maxLength) {
        Intrinsics.checkNotNullParameter($this$truncate, "<this>");
        return $this$truncate.length() <= maxLength ? $this$truncate : StringsKt.take($this$truncate, maxLength - 3) + "...";
    }

    public static /* synthetic */ String truncate$default(String string, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 48;
        }
        return StringExtensionsKt.truncate(string, n);
    }

    @NotNull
    public static final String escapeJson(@NotNull String $this$escapeJson) {
        Intrinsics.checkNotNullParameter($this$escapeJson, "<this>");
        return StringsKt.replace$default(StringsKt.replace$default(StringsKt.replace$default(StringsKt.replace$default(StringsKt.replace$default($this$escapeJson, "\\", "\\\\", false, 4, null), "/", "\\/", false, 4, null), "\"", "\\\"", false, 4, null), "\n", "\\n", false, 4, null), "\r", "\\r", false, 4, null);
    }

    @NotNull
    public static final String unescapeJson(@NotNull String $this$unescapeJson) {
        Intrinsics.checkNotNullParameter($this$unescapeJson, "<this>");
        return StringsKt.replace$default(StringsKt.replace$default(StringsKt.replace$default(StringsKt.replace$default(StringsKt.replace$default($this$unescapeJson, "\\\\", "\\", false, 4, null), "\\/", "/", false, 4, null), "\\\"", "\"", false, 4, null), "\\n", "\n", false, 4, null), "\\r", "\r", false, 4, null);
    }

    @Nullable
    public static final <T extends CharSequence> T blankToNull(@NotNull T $this$blankToNull) {
        T t;
        Intrinsics.checkNotNullParameter($this$blankToNull, "<this>");
        T t2 = $this$blankToNull;
        if (StringsKt.isBlank(t2)) {
            boolean bl = false;
            t = null;
        } else {
            t = t2;
        }
        return t;
    }

    public static final int commonPrefixLength(@NotNull String $this$commonPrefixLength, @NotNull String other) {
        int i;
        Intrinsics.checkNotNullParameter($this$commonPrefixLength, "<this>");
        Intrinsics.checkNotNullParameter(other, "other");
        int max = Math.min($this$commonPrefixLength.length(), other.length());
        for (i = 0; i < max && $this$commonPrefixLength.charAt(i) == other.charAt(i); ++i) {
        }
        return i;
    }

    private static final CharSequence toTitleCase$lambda$2(String word) {
        String string;
        Intrinsics.checkNotNullParameter(word, "word");
        String string2 = word.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
        String string3 = string2;
        if (((CharSequence)string3).length() > 0) {
            char it = string3.charAt(0);
            boolean bl = false;
            char c = Character.toUpperCase(it);
            String string4 = string3;
            int n = 1;
            String string5 = string4.substring(n);
            Intrinsics.checkNotNullExpressionValue(string5, "substring(...)");
            string4 = string5;
            string = c + string4;
        } else {
            string = string3;
        }
        return string;
    }
}

