/*
 * Decompiled with CFR 0.152.
 */
package com.marcpg.libpg.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0006\f\r\u000e\u000f\u0010\u0011B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0012"}, d2={"Lcom/marcpg/libpg/util/SpecialNumbers;", "", "<init>", "()V", "CONTEXT", "Ljava/math/MathContext;", "getCONTEXT", "()Ljava/math/MathContext;", "PHI", "Ljava/math/BigDecimal;", "getPHI", "()Ljava/math/BigDecimal;", "SquareRoots", "GoldenRatio", "HighestPrimes", "MersennePrimes", "Fibonacci", "XorShifts", "base"})
public final class SpecialNumbers {
    @NotNull
    public static final SpecialNumbers INSTANCE = new SpecialNumbers();
    @NotNull
    private static final MathContext CONTEXT = new MathContext(79, RoundingMode.HALF_UP);
    @NotNull
    private static final BigDecimal PHI;

    private SpecialNumbers() {
    }

    @NotNull
    public final MathContext getCONTEXT() {
        return CONTEXT;
    }

    @NotNull
    public final BigDecimal getPHI() {
        return PHI;
    }

    static {
        BigDecimal bigDecimal = BigDecimal.valueOf((1.0 + Math.sqrt(5.0)) / (double)2);
        Intrinsics.checkNotNullExpressionValue(bigDecimal, "valueOf(...)");
        PHI = bigDecimal;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/marcpg/libpg/util/SpecialNumbers$Fibonacci;", "", "<init>", "()V", "calculate", "Ljava/math/BigInteger;", "n", "", "base"})
    public static final class Fibonacci {
        @NotNull
        public static final Fibonacci INSTANCE = new Fibonacci();

        private Fibonacci() {
        }

        @NotNull
        public final BigInteger calculate(int n) {
            if (n == 0) {
                BigInteger bigInteger = BigInteger.ZERO;
                Intrinsics.checkNotNullExpressionValue(bigInteger, "ZERO");
                return bigInteger;
            }
            if (n == 1) {
                BigInteger bigInteger = BigInteger.ONE;
                Intrinsics.checkNotNullExpressionValue(bigInteger, "ONE");
                return bigInteger;
            }
            BigInteger a = BigInteger.ZERO;
            BigInteger b = BigInteger.ONE;
            int i = 2;
            if (i <= n) {
                while (true) {
                    BigInteger temp = a.add(b);
                    a = b;
                    b = temp;
                    if (i == n) break;
                    ++i;
                }
            }
            BigInteger bigInteger = b;
            Intrinsics.checkNotNull(bigInteger);
            return bigInteger;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\f\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\tR\u0011\u0010\u000e\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\tR\u0011\u0010\u0010\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\tR\u0011\u0010\u0012\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\t\u00a8\u0006\u0017"}, d2={"Lcom/marcpg/libpg/util/SpecialNumbers$GoldenRatio;", "", "<init>", "()V", "MULTIPLIER", "Ljava/math/BigDecimal;", "GR_8BIT", "Ljava/math/BigInteger;", "getGR_8BIT", "()Ljava/math/BigInteger;", "GR_16BIT", "getGR_16BIT", "GR_32BIT", "getGR_32BIT", "GR_64BIT", "getGR_64BIT", "GR_128BIT", "getGR_128BIT", "GR_256BIT", "getGR_256BIT", "calculate", "bits", "", "base"})
    public static final class GoldenRatio {
        @NotNull
        public static final GoldenRatio INSTANCE = new GoldenRatio();
        @NotNull
        private static final BigDecimal MULTIPLIER;
        @NotNull
        private static final BigInteger GR_8BIT;
        @NotNull
        private static final BigInteger GR_16BIT;
        @NotNull
        private static final BigInteger GR_32BIT;
        @NotNull
        private static final BigInteger GR_64BIT;
        @NotNull
        private static final BigInteger GR_128BIT;
        @NotNull
        private static final BigInteger GR_256BIT;

        private GoldenRatio() {
        }

        @NotNull
        public final BigInteger getGR_8BIT() {
            return GR_8BIT;
        }

        @NotNull
        public final BigInteger getGR_16BIT() {
            return GR_16BIT;
        }

        @NotNull
        public final BigInteger getGR_32BIT() {
            return GR_32BIT;
        }

        @NotNull
        public final BigInteger getGR_64BIT() {
            return GR_64BIT;
        }

        @NotNull
        public final BigInteger getGR_128BIT() {
            return GR_128BIT;
        }

        @NotNull
        public final BigInteger getGR_256BIT() {
            return GR_256BIT;
        }

        @NotNull
        public final BigInteger calculate(int bits) {
            BigDecimal phiN1 = SquareRoots.INSTANCE.getSQRT_5().subtract(BigDecimal.ONE).divide(BigDecimal.valueOf(2L), INSTANCE.getCONTEXT());
            BigInteger bigInteger = BigDecimal.valueOf(2L).pow(bits, INSTANCE.getCONTEXT()).multiply(phiN1, INSTANCE.getCONTEXT()).toBigInteger();
            Intrinsics.checkNotNullExpressionValue(bigInteger, "toBigInteger(...)");
            return bigInteger;
        }

        static {
            BigDecimal bigDecimal = BigDecimal.valueOf(2L).subtract(INSTANCE.getPHI());
            Intrinsics.checkNotNullExpressionValue(bigDecimal, "subtract(...)");
            MULTIPLIER = bigDecimal;
            GR_8BIT = INSTANCE.calculate(8);
            GR_16BIT = INSTANCE.calculate(16);
            GR_32BIT = INSTANCE.calculate(32);
            GR_64BIT = INSTANCE.calculate(64);
            GR_128BIT = INSTANCE.calculate(128);
            GR_256BIT = INSTANCE.calculate(256);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007R\u0011\u0010\u000e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0007R\u0011\u0010\u0010\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0007\u00a8\u0006\u0015"}, d2={"Lcom/marcpg/libpg/util/SpecialNumbers$HighestPrimes;", "", "<init>", "()V", "HP_8BIT", "Ljava/math/BigInteger;", "getHP_8BIT", "()Ljava/math/BigInteger;", "HP_16BIT", "getHP_16BIT", "HP_32BIT", "getHP_32BIT", "HP_64BIT", "getHP_64BIT", "HP_128BIT", "getHP_128BIT", "HP_256BIT", "getHP_256BIT", "calculate", "bits", "", "base"})
    public static final class HighestPrimes {
        @NotNull
        public static final HighestPrimes INSTANCE = new HighestPrimes();
        @NotNull
        private static final BigInteger HP_8BIT = INSTANCE.calculate(8);
        @NotNull
        private static final BigInteger HP_16BIT = INSTANCE.calculate(16);
        @NotNull
        private static final BigInteger HP_32BIT = INSTANCE.calculate(32);
        @NotNull
        private static final BigInteger HP_64BIT = INSTANCE.calculate(64);
        @NotNull
        private static final BigInteger HP_128BIT = INSTANCE.calculate(128);
        @NotNull
        private static final BigInteger HP_256BIT = INSTANCE.calculate(256);

        private HighestPrimes() {
        }

        @NotNull
        public final BigInteger getHP_8BIT() {
            return HP_8BIT;
        }

        @NotNull
        public final BigInteger getHP_16BIT() {
            return HP_16BIT;
        }

        @NotNull
        public final BigInteger getHP_32BIT() {
            return HP_32BIT;
        }

        @NotNull
        public final BigInteger getHP_64BIT() {
            return HP_64BIT;
        }

        @NotNull
        public final BigInteger getHP_128BIT() {
            return HP_128BIT;
        }

        @NotNull
        public final BigInteger getHP_256BIT() {
            return HP_256BIT;
        }

        @NotNull
        public final BigInteger calculate(int bits) {
            BigInteger max = BigInteger.valueOf(2L).pow(bits).subtract(BigInteger.ONE);
            while (!max.isProbablePrime(100)) {
                max = max.subtract(BigInteger.ONE);
            }
            BigInteger bigInteger = max;
            Intrinsics.checkNotNull(bigInteger);
            return bigInteger;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\t"}, d2={"Lcom/marcpg/libpg/util/SpecialNumbers$MersennePrimes;", "", "<init>", "()V", "calculate", "Ljava/math/BigInteger;", "exponent", "", "calculateUnsafe", "base"})
    @SourceDebugExtension(value={"SMAP\nSpecialNumbers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpecialNumbers.kt\ncom/marcpg/libpg/util/SpecialNumbers$MersennePrimes\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,193:1\n1#2:194\n*E\n"})
    public static final class MersennePrimes {
        @NotNull
        public static final MersennePrimes INSTANCE = new MersennePrimes();

        private MersennePrimes() {
        }

        @NotNull
        public final BigInteger calculate(int exponent) {
            if (!(exponent <= 10000)) {
                boolean bl = false;
                String string = "Exponent is too high! Operation stopped, as it can cause complete freezes otherwise. Use #calculateUnsafe() to bypass this check";
                throw new IllegalArgumentException(string.toString());
            }
            return this.calculateUnsafe(exponent);
        }

        @NotNull
        public final BigInteger calculateUnsafe(int exponent) {
            if (!BigInteger.valueOf(exponent).isProbablePrime(100)) {
                boolean bl = false;
                String string = "Exponent has be a prime number";
                throw new IllegalArgumentException(string.toString());
            }
            BigInteger candidate = BigInteger.valueOf(2L).pow(exponent).subtract(BigInteger.ONE);
            if (!candidate.isProbablePrime(100)) {
                boolean bl = false;
                String string = "2^" + exponent + " - 1 is not a prime number!";
                throw new IllegalArgumentException(string.toString());
            }
            Intrinsics.checkNotNull(candidate);
            return candidate;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lcom/marcpg/libpg/util/SpecialNumbers$SquareRoots;", "", "<init>", "()V", "SQRT_2", "Ljava/math/BigDecimal;", "getSQRT_2", "()Ljava/math/BigDecimal;", "SQRT_3", "getSQRT_3", "SQRT_5", "getSQRT_5", "SQRT_10", "getSQRT_10", "calculate", "number", "", "base"})
    public static final class SquareRoots {
        @NotNull
        public static final SquareRoots INSTANCE = new SquareRoots();
        @NotNull
        private static final BigDecimal SQRT_2 = INSTANCE.calculate(2);
        @NotNull
        private static final BigDecimal SQRT_3 = INSTANCE.calculate(3);
        @NotNull
        private static final BigDecimal SQRT_5 = INSTANCE.calculate(5);
        @NotNull
        private static final BigDecimal SQRT_10 = INSTANCE.calculate(10);

        private SquareRoots() {
        }

        @NotNull
        public final BigDecimal getSQRT_2() {
            return SQRT_2;
        }

        @NotNull
        public final BigDecimal getSQRT_3() {
            return SQRT_3;
        }

        @NotNull
        public final BigDecimal getSQRT_5() {
            return SQRT_5;
        }

        @NotNull
        public final BigDecimal getSQRT_10() {
            return SQRT_10;
        }

        @NotNull
        public final BigDecimal calculate(int number) {
            BigDecimal bigDecimal = new BigDecimal(number, INSTANCE.getCONTEXT()).sqrt(INSTANCE.getCONTEXT());
            Intrinsics.checkNotNullExpressionValue(bigDecimal, "sqrt(...)");
            return bigDecimal;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R#\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR#\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR#\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\bR#\u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\bR#\u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\b\u00a8\u0006\u0011"}, d2={"Lcom/marcpg/libpg/util/SpecialNumbers$XorShifts;", "", "<init>", "()V", "XOR_8BIT", "Lkotlin/Triple;", "", "getXOR_8BIT", "()Lkotlin/Triple;", "XOR_16BIT", "getXOR_16BIT", "XOR_32BIT", "getXOR_32BIT", "XOR_64BIT", "getXOR_64BIT", "XOR_128BIT", "getXOR_128BIT", "base"})
    public static final class XorShifts {
        @NotNull
        public static final XorShifts INSTANCE = new XorShifts();
        @NotNull
        private static final Triple<Integer, Integer, Integer> XOR_8BIT = new Triple<Integer, Integer, Integer>(1, 3, 2);
        @NotNull
        private static final Triple<Integer, Integer, Integer> XOR_16BIT = new Triple<Integer, Integer, Integer>(1, 3, 2);
        @NotNull
        private static final Triple<Integer, Integer, Integer> XOR_32BIT = new Triple<Integer, Integer, Integer>(13, 17, 21);
        @NotNull
        private static final Triple<Integer, Integer, Integer> XOR_64BIT = new Triple<Integer, Integer, Integer>(11, 23, 17);
        @NotNull
        private static final Triple<Integer, Integer, Integer> XOR_128BIT = new Triple<Integer, Integer, Integer>(47, 55, 33);

        private XorShifts() {
        }

        @NotNull
        public final Triple<Integer, Integer, Integer> getXOR_8BIT() {
            return XOR_8BIT;
        }

        @NotNull
        public final Triple<Integer, Integer, Integer> getXOR_16BIT() {
            return XOR_16BIT;
        }

        @NotNull
        public final Triple<Integer, Integer, Integer> getXOR_32BIT() {
            return XOR_32BIT;
        }

        @NotNull
        public final Triple<Integer, Integer, Integer> getXOR_64BIT() {
            return XOR_64BIT;
        }

        @NotNull
        public final Triple<Integer, Integer, Integer> getXOR_128BIT() {
            return XOR_128BIT;
        }
    }
}

