/*
 * Decompiled with CFR 0.152.
 */
package com.marcpg.libpg.util;

import java.security.SecureRandom;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\f\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tJ\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0005J\u000e\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\tJ\u0016\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0005J\u000e\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\tJ\u0006\u0010\u0011\u001a\u00020\u0012R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/marcpg/libpg/util/Randomizer;", "", "<init>", "()V", "BASIC_CHARS", "", "boolByChance", "", "numerator", "", "denominator", "percentage", "", "generateRandomString", "length", "charset", "generateRandomPassword", "randomChar", "", "base"})
public final class Randomizer {
    @NotNull
    public static final Randomizer INSTANCE = new Randomizer();
    @NotNull
    public static final String BASIC_CHARS = "!#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[]^_`abcdefghijklmnopqrstuvwxyz{|}~";

    private Randomizer() {
    }

    public final boolean boolByChance(int numerator, int denominator) {
        return Random.Default.nextInt(denominator + 1) < numerator;
    }

    public final boolean boolByChance(double percentage) {
        return Random.Default.nextDouble() < percentage / 100.0;
    }

    @NotNull
    public final String generateRandomString(int length, @NotNull String charset) {
        Intrinsics.checkNotNullParameter(charset, "charset");
        StringBuilder builder = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            builder.append(StringsKt.random(charset, Random.Default));
        }
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    @NotNull
    public final String generateRandomString(int length) {
        return this.generateRandomString(length, BASIC_CHARS);
    }

    @NotNull
    public final String generateRandomPassword(int length, @NotNull String charset) {
        Intrinsics.checkNotNullParameter(charset, "charset");
        SecureRandom secureRandom = new SecureRandom();
        StringBuilder builder = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            builder.append(charset.charAt(secureRandom.nextInt(charset.length())));
        }
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    @NotNull
    public final String generateRandomPassword(int length) {
        return this.generateRandomPassword(length, BASIC_CHARS);
    }

    public final char randomChar() {
        return StringsKt.random(BASIC_CHARS, Random.Default);
    }
}

