/*
 * Decompiled with CFR 0.152.
 */
package com.marcpg.libpg.util;

import com.marcpg.libpg.data.QuantityUnit;
import com.marcpg.libpg.util.StringExtensionsKt;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.DoubleAccumulator;
import java.util.concurrent.atomic.DoubleAdder;
import java.util.concurrent.atomic.LongAccumulator;
import java.util.concurrent.atomic.LongAdder;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000`\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010\u0004\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u0002\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0003\u001a\u00020\u0004*\u00020\u0001\u001a%\u0010\u0005\u001a\u0004\u0018\u0001H\u0006\"\u0004\b\u0000\u0010\u0006*\b\u0012\u0004\u0012\u0002H\u00060\u00072\u0006\u0010\b\u001a\u0002H\u0006\u00a2\u0006\u0002\u0010\t\u001a/\u0010\n\u001a\u0004\u0018\u0001H\u0006\"\u0004\b\u0000\u0010\u00062\u0006\u0010\u000b\u001a\u00020\u00012\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u00060\rH\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000e\u001a=\u0010\u000f\u001a\u0004\u0018\u0001H\u0006\"\u0004\b\u0000\u0010\u00062\u0006\u0010\u000b\u001a\u00020\u00012\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u00060\r2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u00060\rH\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0011\u001a\u0010\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u0007*\u00020\u0014\u001a6\u0010\u0015\u001a\u00020\u0016\"\u0004\b\u0000\u0010\u0006*\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00060\u00170\u00172\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u00020\u00160\u0019H\u0086\b\u00f8\u0001\u0000\u001a6\u0010\u001a\u001a\u00020\u0016\"\u0004\b\u0000\u0010\u0006*\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00060\u001b0\u00172\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u00020\u00160\u0019H\u0086\b\u00f8\u0001\u0000\u001a\u001a\u0010\u001c\u001a\u0004\u0018\u00010\u001d*\b\u0012\u0004\u0012\u00020\u001d0\u001e2\u0006\u0010\u001f\u001a\u00020\u0013\u001a\u0018\u0010 \u001a\u00020\u001d*\b\u0012\u0004\u0012\u00020\u001d0\u001e2\u0006\u0010\u001f\u001a\u00020\u0013\u001a\u0015\u0010!\u001a\u00020\"*\u00020\u00022\u0006\u0010#\u001a\u00020\u0002H\u0086\u0004\u001a\u0015\u0010$\u001a\u00020\"*\u00020\u00022\u0006\u0010#\u001a\u00020\u0002H\u0086\u0004\u001a\u0015\u0010%\u001a\u00020\"*\u00020\u00022\u0006\u0010#\u001a\u00020\u0002H\u0086\u0004\u001a\u0015\u0010&\u001a\u00020\"*\u00020\u00022\u0006\u0010#\u001a\u00020\u0002H\u0086\u0004\u001a\n\u0010'\u001a\u00020\"*\u00020\u0002\u001a\n\u0010(\u001a\u00020)*\u00020\u0002\u001a\u0010\u0010*\u001a\u00020\"*\b\u0012\u0004\u0012\u00020\"0\u0017\u001a\u0010\u0010*\u001a\u00020)*\b\u0012\u0004\u0012\u00020)0\u0017\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006+"}, d2={"toBoolean", "", "", "toInt", "", "following", "T", "", "element", "(Ljava/util/List;Ljava/lang/Object;)Ljava/lang/Object;", "getIf", "predicate", "provider", "Lkotlin/Function0;", "(ZLkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "getIfOr", "def", "(ZLkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "stackTraceToLines", "", "", "forEachNested", "", "", "action", "Lkotlin/Function1;", "forEachArrays", "", "matchOrNull", "Lcom/marcpg/libpg/data/QuantityUnit;", "", "text", "match", "plusNumber", "Ljava/math/BigDecimal;", "other", "minusNumber", "timesNumber", "divNumber", "toBigDecimal", "toBigInteger", "Ljava/math/BigInteger;", "sum", "base"})
@SourceDebugExtension(value={"SMAP\nExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Extensions.kt\ncom/marcpg/libpg/util/ExtensionsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,192:1\n1869#2,2:193\n1869#2:195\n1870#2:198\n13472#3,2:196\n*S KotlinDebug\n*F\n+ 1 Extensions.kt\ncom/marcpg/libpg/util/ExtensionsKt\n*L\n48#1:193,2\n51#1:195\n51#1:198\n51#1:196,2\n*E\n"})
public final class ExtensionsKt {
    public static final boolean toBoolean(@NotNull Number $this$toBoolean) {
        Intrinsics.checkNotNullParameter($this$toBoolean, "<this>");
        return Intrinsics.areEqual($this$toBoolean, (Object)1);
    }

    public static final int toInt(boolean $this$toInt) {
        return $this$toInt ? 1 : 2;
    }

    @Nullable
    public static final <T> T following(@NotNull List<? extends T> $this$following, T element) {
        Intrinsics.checkNotNullParameter($this$following, "<this>");
        int index = $this$following.indexOf(element);
        return index != -1 ? (T)$this$following.get((index + 1) % $this$following.size()) : null;
    }

    @Nullable
    public static final <T> T getIf(boolean predicate, @NotNull Function0<? extends T> provider) {
        Intrinsics.checkNotNullParameter(provider, "provider");
        boolean $i$f$getIf = false;
        return predicate ? (T)provider.invoke() : null;
    }

    @Nullable
    public static final <T> T getIfOr(boolean predicate, @NotNull Function0<? extends T> provider, @NotNull Function0<? extends T> def) {
        Intrinsics.checkNotNullParameter(provider, "provider");
        Intrinsics.checkNotNullParameter(def, "def");
        boolean $i$f$getIfOr = false;
        return predicate ? provider.invoke() : def.invoke();
    }

    @NotNull
    public static final List<String> stackTraceToLines(@NotNull Throwable $this$stackTraceToLines) {
        Intrinsics.checkNotNullParameter($this$stackTraceToLines, "<this>");
        String[] stringArray = new String[]{"\n"};
        return StringsKt.split$default((CharSequence)ExceptionsKt.stackTraceToString($this$stackTraceToLines), stringArray, false, 0, 6, null);
    }

    public static final <T> void forEachNested(@NotNull Iterable<? extends Iterable<? extends T>> $this$forEachNested, @NotNull Function1<? super T, Unit> action) {
        Intrinsics.checkNotNullParameter($this$forEachNested, "<this>");
        Intrinsics.checkNotNullParameter(action, "action");
        boolean $i$f$forEachNested = false;
        Iterable<Iterable<T>> $this$forEach$iv = $this$forEachNested;
        boolean $i$f$forEach = false;
        Iterator<Iterable<T>> iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            Iterable<T> element$iv;
            Iterable<T> it = element$iv = iterator2.next();
            boolean bl = false;
            Iterable<T> $this$forEach$iv2 = it;
            boolean $i$f$forEach2 = false;
            for (T element$iv2 : $this$forEach$iv2) {
                action.invoke(element$iv2);
            }
        }
    }

    public static final <T> void forEachArrays(@NotNull Iterable<T[]> $this$forEachArrays, @NotNull Function1<? super T, Unit> action) {
        Intrinsics.checkNotNullParameter($this$forEachArrays, "<this>");
        Intrinsics.checkNotNullParameter(action, "action");
        boolean $i$f$forEachArrays = false;
        Iterable<T[]> $this$forEach$iv = $this$forEachArrays;
        boolean $i$f$forEach = false;
        Iterator<T[]> iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            T[] element$iv;
            T[] it = element$iv = iterator2.next();
            boolean bl = false;
            T[] $this$forEach$iv2 = it;
            boolean $i$f$forEach2 = false;
            for (T element$iv2 : $this$forEach$iv2) {
                action.invoke(element$iv2);
            }
        }
    }

    @Nullable
    public static final QuantityUnit matchOrNull(@NotNull Collection<? extends QuantityUnit> $this$matchOrNull, @NotNull String text) {
        Intrinsics.checkNotNullParameter($this$matchOrNull, "<this>");
        Intrinsics.checkNotNullParameter(text, "text");
        QuantityUnit best = null;
        int bestScore = -1;
        for (QuantityUnit quantityUnit : $this$matchOrNull) {
            if (Intrinsics.areEqual(text, quantityUnit.getAbb()) || Intrinsics.areEqual(text, quantityUnit.getName())) {
                return quantityUnit;
            }
            int score = Math.max(StringExtensionsKt.commonPrefixLength(text, quantityUnit.getAbb()), StringExtensionsKt.commonPrefixLength(text, quantityUnit.getName()));
            if (score <= bestScore) continue;
            bestScore = score;
            best = quantityUnit;
        }
        return best;
    }

    @NotNull
    public static final QuantityUnit match(@NotNull Collection<? extends QuantityUnit> $this$match, @NotNull String text) {
        Intrinsics.checkNotNullParameter($this$match, "<this>");
        Intrinsics.checkNotNullParameter(text, "text");
        QuantityUnit quantityUnit = ExtensionsKt.matchOrNull($this$match, text);
        if (quantityUnit == null) {
            throw new NoSuchElementException("No matching unit found");
        }
        return quantityUnit;
    }

    @NotNull
    public static final BigDecimal plusNumber(@NotNull Number $this$plusNumber, @NotNull Number other) {
        Intrinsics.checkNotNullParameter($this$plusNumber, "<this>");
        Intrinsics.checkNotNullParameter(other, "other");
        BigDecimal bigDecimal = ExtensionsKt.toBigDecimal($this$plusNumber).add(ExtensionsKt.toBigDecimal(other));
        Intrinsics.checkNotNullExpressionValue(bigDecimal, "add(...)");
        return bigDecimal;
    }

    @NotNull
    public static final BigDecimal minusNumber(@NotNull Number $this$minusNumber, @NotNull Number other) {
        Intrinsics.checkNotNullParameter($this$minusNumber, "<this>");
        Intrinsics.checkNotNullParameter(other, "other");
        BigDecimal bigDecimal = ExtensionsKt.toBigDecimal($this$minusNumber).subtract(ExtensionsKt.toBigDecimal(other));
        Intrinsics.checkNotNullExpressionValue(bigDecimal, "subtract(...)");
        return bigDecimal;
    }

    @NotNull
    public static final BigDecimal timesNumber(@NotNull Number $this$timesNumber, @NotNull Number other) {
        Intrinsics.checkNotNullParameter($this$timesNumber, "<this>");
        Intrinsics.checkNotNullParameter(other, "other");
        BigDecimal bigDecimal = ExtensionsKt.toBigDecimal($this$timesNumber).multiply(ExtensionsKt.toBigDecimal(other));
        Intrinsics.checkNotNullExpressionValue(bigDecimal, "multiply(...)");
        return bigDecimal;
    }

    @NotNull
    public static final BigDecimal divNumber(@NotNull Number $this$divNumber, @NotNull Number other) {
        Intrinsics.checkNotNullParameter($this$divNumber, "<this>");
        Intrinsics.checkNotNullParameter(other, "other");
        BigDecimal bigDecimal = ExtensionsKt.toBigDecimal($this$divNumber).divide(ExtensionsKt.toBigDecimal(other), RoundingMode.HALF_EVEN);
        Intrinsics.checkNotNullExpressionValue(bigDecimal, "divide(...)");
        return bigDecimal;
    }

    @NotNull
    public static final BigDecimal toBigDecimal(@NotNull Number $this$toBigDecimal) {
        BigDecimal bigDecimal;
        Intrinsics.checkNotNullParameter($this$toBigDecimal, "<this>");
        Number number = $this$toBigDecimal;
        if (number instanceof BigDecimal) {
            bigDecimal = (BigDecimal)$this$toBigDecimal;
        } else if (number instanceof Long || number instanceof Integer || number instanceof Short || number instanceof Byte || number instanceof AtomicLong || number instanceof AtomicInteger || number instanceof LongAdder || number instanceof LongAccumulator) {
            BigDecimal bigDecimal2 = BigDecimal.valueOf($this$toBigDecimal.longValue());
            bigDecimal = bigDecimal2;
            Intrinsics.checkNotNullExpressionValue(bigDecimal2, "valueOf(...)");
        } else if (number instanceof Double || number instanceof Float || number instanceof DoubleAdder || number instanceof DoubleAccumulator) {
            BigDecimal bigDecimal3 = BigDecimal.valueOf($this$toBigDecimal.doubleValue());
            bigDecimal = bigDecimal3;
            Intrinsics.checkNotNullExpressionValue(bigDecimal3, "valueOf(...)");
        } else {
            bigDecimal = number instanceof BigInteger ? new BigDecimal((BigInteger)$this$toBigDecimal) : new BigDecimal($this$toBigDecimal.toString());
        }
        return bigDecimal;
    }

    @NotNull
    public static final BigInteger toBigInteger(@NotNull Number $this$toBigInteger) {
        BigInteger bigInteger;
        Intrinsics.checkNotNullParameter($this$toBigInteger, "<this>");
        Number number = $this$toBigInteger;
        if (number instanceof BigInteger) {
            bigInteger = (BigInteger)$this$toBigInteger;
        } else if (number instanceof BigDecimal) {
            BigInteger bigInteger2 = ((BigDecimal)$this$toBigInteger).toBigIntegerExact();
            bigInteger = bigInteger2;
            Intrinsics.checkNotNullExpressionValue(bigInteger2, "toBigIntegerExact(...)");
        } else if (number instanceof Long || number instanceof Integer || number instanceof Short || number instanceof Byte || number instanceof AtomicLong || number instanceof AtomicInteger || number instanceof LongAdder || number instanceof LongAccumulator) {
            BigInteger bigInteger3 = BigInteger.valueOf($this$toBigInteger.longValue());
            bigInteger = bigInteger3;
            Intrinsics.checkNotNullExpressionValue(bigInteger3, "valueOf(...)");
        } else {
            if (number instanceof Double || number instanceof Float || number instanceof DoubleAdder || number instanceof DoubleAccumulator) {
                throw new IllegalArgumentException("Not a whole number");
            }
            bigInteger = new BigInteger($this$toBigInteger.toString());
        }
        return bigInteger;
    }

    @NotNull
    public static final BigDecimal sum(@NotNull Iterable<? extends BigDecimal> $this$sum) {
        Intrinsics.checkNotNullParameter($this$sum, "<this>");
        BigDecimal sum = BigDecimal.ZERO;
        for (BigDecimal bigDecimal : $this$sum) {
            BigDecimal bigDecimal2 = sum;
            Intrinsics.checkNotNull(bigDecimal2);
            Intrinsics.checkNotNullExpressionValue(bigDecimal2.add(bigDecimal), "add(...)");
        }
        BigDecimal bigDecimal = sum;
        Intrinsics.checkNotNull(bigDecimal);
        return bigDecimal;
    }

    @NotNull
    public static final BigInteger sum(@NotNull Iterable<? extends BigInteger> $this$sum) {
        Intrinsics.checkNotNullParameter($this$sum, "<this>");
        BigInteger sum = BigInteger.ZERO;
        for (BigInteger bigInteger : $this$sum) {
            BigInteger bigInteger2 = sum;
            Intrinsics.checkNotNull(bigInteger2);
            Intrinsics.checkNotNullExpressionValue(bigInteger2.add(bigInteger), "add(...)");
        }
        BigInteger bigInteger = sum;
        Intrinsics.checkNotNull(bigInteger);
        return bigInteger;
    }
}

