/*
 * Decompiled with CFR 0.152.
 */
package com.marcpg.libpg.storing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.CollectionToArray;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMutableCollection;
import kotlin.random.Random;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010)\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0006\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0001(B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004B\u001d\b\u0016\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\u0003\u0010\bJ\u001b\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00028\u00002\u0006\u0010\u0016\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u0017J\u000b\u0010\r\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0018J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0016\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u001dJ\u000f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00028\u00000\u001fH\u0096\u0002J\u0015\u0010\u0013\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001dJ\u0015\u0010 \u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001dJ\u0016\u0010!\u001a\u00020\u001a2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00028\u00000#H\u0016J\u0016\u0010$\u001a\u00020\u001a2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00028\u00000#H\u0016J\u0016\u0010%\u001a\u00020\u001a2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00028\u00000#H\u0016J\u0016\u0010&\u001a\u00020\u001a2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00028\u00000#H\u0016J\b\u0010'\u001a\u00020\u0014H\u0016R\u001a\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006)"}, d2={"Lcom/marcpg/libpg/storing/WeightedList;", "T", "", "<init>", "()V", "map", "", "", "(Ljava/util/Map;)V", "items", "", "Lcom/marcpg/libpg/storing/WeightedList$WeightedItem;", "totalWeight", "random", "Lkotlin/random/Random$Default;", "size", "", "getSize", "()I", "add", "", "item", "weight", "(Ljava/lang/Object;D)V", "()Ljava/lang/Object;", "isEmpty", "", "contains", "element", "(Ljava/lang/Object;)Z", "iterator", "", "remove", "containsAll", "elements", "", "addAll", "removeAll", "retainAll", "clear", "WeightedItem", "base"})
@SourceDebugExtension(value={"SMAP\nWeightedList.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WeightedList.kt\ncom/marcpg/libpg/storing/WeightedList\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,120:1\n1#2:121\n1761#3,3:122\n360#3,7:125\n1740#3,3:132\n774#3:135\n865#3,2:136\n*S KotlinDebug\n*F\n+ 1 WeightedList.kt\ncom/marcpg/libpg/storing/WeightedList\n*L\n54#1:122,3\n69#1:125,7\n86#1:132,3\n103#1:135\n103#1:136,2\n*E\n"})
public final class WeightedList<T>
implements Collection<T>,
KMutableCollection {
    @NotNull
    private final List<WeightedItem<T>> items;
    private double totalWeight;
    @NotNull
    private final Random.Default random;

    public WeightedList() {
        this.items = new ArrayList();
        this.random = Random.Default;
    }

    public int getSize() {
        return this.items.size();
    }

    public WeightedList(@NotNull Map<T, Double> map) {
        Intrinsics.checkNotNullParameter(map, "map");
        this();
        for (Map.Entry<T, Double> entry : map.entrySet()) {
            T item = entry.getKey();
            double weight = ((Number)entry.getValue()).doubleValue();
            this.add(item, weight);
        }
    }

    public final void add(T item, double weight) {
        if (!(weight > 0.0)) {
            boolean bl = false;
            String string = "Weight must be > 0";
            throw new IllegalArgumentException(string.toString());
        }
        this.totalWeight += weight;
        double cumulativeWeight = this.items.isEmpty() ? weight : CollectionsKt.last(this.items).getCumulativeWeight() + weight;
        ((Collection)this.items).add(new WeightedItem<T>(item, cumulativeWeight));
    }

    public final T random() {
        if (!(!((Collection)this.items).isEmpty())) {
            boolean bl = false;
            String string = "No elements to choose from";
            throw new IllegalArgumentException(string.toString());
        }
        double r = this.random.nextDouble() * this.totalWeight;
        int low = 0;
        int high = CollectionsKt.getLastIndex(this.items);
        while (low < high) {
            int mid = low + high >>> 1;
            if (r < this.items.get(mid).getCumulativeWeight()) {
                high = mid;
                continue;
            }
            low = mid + 1;
        }
        return this.items.get(low).getValue();
    }

    @Override
    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    @Override
    public boolean contains(Object element) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this.items;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    WeightedItem it = (WeightedItem)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual(it.getValue(), element)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return new Iterator<T>(this){
            private final Iterator<WeightedItem<T>> inner;
            {
                this.inner = WeightedList.access$getItems$p($receiver).iterator();
            }

            public boolean hasNext() {
                return this.inner.hasNext();
            }

            public T next() {
                return this.inner.next().getValue();
            }

            public void remove() {
                this.inner.remove();
            }
        };
    }

    @Override
    public boolean add(T element) {
        this.add(element, 1.0);
        return true;
    }

    @Override
    public boolean remove(Object element) {
        int index;
        block4: {
            int n;
            List<WeightedItem<T>> $this$indexOfFirst$iv = this.items;
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            Iterator<WeightedItem<T>> iterator2 = $this$indexOfFirst$iv.iterator();
            while (iterator2.hasNext()) {
                WeightedItem<T> item$iv;
                WeightedItem<T> it = item$iv = iterator2.next();
                boolean bl = false;
                if (Intrinsics.areEqual(it.getValue(), element)) {
                    n = index$iv;
                    break block4;
                }
                ++index$iv;
            }
            n = index = -1;
        }
        if (index == -1) {
            return false;
        }
        double weightToRemove = index == 0 ? this.items.get(0).getCumulativeWeight() : this.items.get(index).getCumulativeWeight() - this.items.get(index - 1).getCumulativeWeight();
        this.totalWeight -= weightToRemove;
        this.items.remove(index);
        int n = this.items.size();
        for (int i = index; i < n; ++i) {
            WeightedItem<T> weightedItem = this.items.get(i);
            weightedItem.setCumulativeWeight(weightedItem.getCumulativeWeight() - weightToRemove);
        }
        return true;
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> elements) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(elements, "elements");
            Iterable $this$all$iv = elements;
            boolean $i$f$all = false;
            if (((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                Iterator iterator2 = $this$all$iv.iterator();
                while (iterator2.hasNext()) {
                    Object element$iv;
                    Object it = element$iv = iterator2.next();
                    boolean bl2 = false;
                    if (this.contains(it)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends T> elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        for (T e : elements) {
            this.add(e);
        }
        return true;
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        boolean changed = false;
        for (Object e : elements) {
            changed = this.remove(e) || changed;
        }
        return changed;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean retainAll(@NotNull Collection<?> elements) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(elements, "elements");
        Set toKeep = CollectionsKt.toSet((Iterable)elements);
        Iterable $this$filter$iv = this.items;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            WeightedItem it = (WeightedItem)element$iv$iv;
            boolean bl = false;
            if (!toKeep.contains(it.getValue())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List filtered = (List)destination$iv$iv;
        if (filtered.size() == this.items.size()) {
            return false;
        }
        this.items.clear();
        this.totalWeight = 0.0;
        for (WeightedItem item : filtered) {
            this.add(item.getValue(), filtered.indexOf(item) == 0 ? item.getCumulativeWeight() : item.getCumulativeWeight() - ((WeightedItem)filtered.get(filtered.indexOf(item) - 1)).getCumulativeWeight());
        }
        return true;
    }

    @Override
    public void clear() {
        this.items.clear();
        this.totalWeight = 0.0;
    }

    public static final /* synthetic */ List access$getItems$p(WeightedList $this) {
        return $this.items;
    }

    @Override
    public <T> T[] toArray(T[] array) {
        Intrinsics.checkNotNullParameter(array, "array");
        return CollectionToArray.toArray(this, array);
    }

    @Override
    public Object[] toArray() {
        return CollectionToArray.toArray(this);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u0000*\u0004\b\u0001\u0010\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00028\u0001\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u000f\u001a\u00028\u0001H\u00c6\u0003\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J(\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\b\b\u0002\u0010\u0003\u001a\u00028\u00012\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0012J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0013\u0010\u0003\u001a\u00028\u0001\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\tR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lcom/marcpg/libpg/storing/WeightedList$WeightedItem;", "T", "", "value", "cumulativeWeight", "", "<init>", "(Ljava/lang/Object;D)V", "getValue", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getCumulativeWeight", "()D", "setCumulativeWeight", "(D)V", "component1", "component2", "copy", "(Ljava/lang/Object;D)Lcom/marcpg/libpg/storing/WeightedList$WeightedItem;", "equals", "", "other", "hashCode", "", "toString", "", "base"})
    private static final class WeightedItem<T> {
        private final T value;
        private double cumulativeWeight;

        public WeightedItem(T value, double cumulativeWeight) {
            this.value = value;
            this.cumulativeWeight = cumulativeWeight;
        }

        public final T getValue() {
            return this.value;
        }

        public final double getCumulativeWeight() {
            return this.cumulativeWeight;
        }

        public final void setCumulativeWeight(double d) {
            this.cumulativeWeight = d;
        }

        public final T component1() {
            return this.value;
        }

        public final double component2() {
            return this.cumulativeWeight;
        }

        @NotNull
        public final WeightedItem<T> copy(T value, double cumulativeWeight) {
            return new WeightedItem<T>(value, cumulativeWeight);
        }

        public static /* synthetic */ WeightedItem copy$default(WeightedItem weightedItem, Object object, double d, int n, Object object2) {
            if ((n & 1) != 0) {
                object = weightedItem.value;
            }
            if ((n & 2) != 0) {
                d = weightedItem.cumulativeWeight;
            }
            return weightedItem.copy(object, d);
        }

        @NotNull
        public String toString() {
            return "WeightedItem(value=" + this.value + ", cumulativeWeight=" + this.cumulativeWeight + ")";
        }

        public int hashCode() {
            int result = this.value == null ? 0 : this.value.hashCode();
            result = result * 31 + Double.hashCode(this.cumulativeWeight);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof WeightedItem)) {
                return false;
            }
            WeightedItem weightedItem = (WeightedItem)other;
            if (!Intrinsics.areEqual(this.value, weightedItem.value)) {
                return false;
            }
            return Double.compare(this.cumulativeWeight, weightedItem.cumulativeWeight) == 0;
        }
    }
}

