/*
 * Decompiled with CFR 0.152.
 */
package com.marcpg.libpg.storing;

import java.io.Serializable;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 (2\u00020\u0001:\u0001(B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0011\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\u000e\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\u000f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\u0010\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u0000H\u0086\u0002J\u000e\u0010\u0011\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0000J\u0006\u0010\u0012\u001a\u00020\u0000J\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0000J6\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u0003J\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0003H\u00c6\u0003J'\u0010 \u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010!\u001a\u00020\u00142\b\u0010\"\u001a\u0004\u0018\u00010#H\u00d6\u0003J\t\u0010$\u001a\u00020%H\u00d6\u0001J\t\u0010&\u001a\u00020'H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006)"}, d2={"Lcom/marcpg/libpg/storing/Cord;", "Ljava/io/Serializable;", "x", "", "y", "z", "<init>", "(DDD)V", "getX", "()D", "getY", "getZ", "plus", "cord", "minus", "times", "div", "distance", "flipped", "inBounds", "", "low", "high", "lowX", "highX", "lowY", "highY", "lowZ", "highZ", "component1", "component2", "component3", "copy", "equals", "other", "", "hashCode", "", "toString", "", "Companion", "base"})
public final class Cord
implements Serializable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final double x;
    private final double y;
    private final double z;

    public Cord(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public final double getX() {
        return this.x;
    }

    public final double getY() {
        return this.y;
    }

    public final double getZ() {
        return this.z;
    }

    @NotNull
    public final Cord plus(@NotNull Cord cord) {
        Intrinsics.checkNotNullParameter(cord, "cord");
        return new Cord(this.x + cord.x, this.y + cord.y, this.z + cord.z);
    }

    @NotNull
    public final Cord minus(@NotNull Cord cord) {
        Intrinsics.checkNotNullParameter(cord, "cord");
        return new Cord(this.x - cord.x, this.y - cord.y, this.z - cord.z);
    }

    @NotNull
    public final Cord times(@NotNull Cord cord) {
        Intrinsics.checkNotNullParameter(cord, "cord");
        return new Cord(this.x * cord.x, this.y * cord.y, this.z * cord.z);
    }

    @NotNull
    public final Cord div(@NotNull Cord cord) {
        Intrinsics.checkNotNullParameter(cord, "cord");
        return new Cord(this.x / cord.x, this.y / cord.y, this.z / cord.z);
    }

    public final double distance(@NotNull Cord cord) {
        Intrinsics.checkNotNullParameter(cord, "cord");
        return Math.sqrt(Math.sqrt(this.x - cord.x) + Math.sqrt(this.y - cord.y) + Math.sqrt(this.z - cord.z));
    }

    @NotNull
    public final Cord flipped() {
        return new Cord(this.z, this.y, this.x);
    }

    public final boolean inBounds(@NotNull Cord low, @NotNull Cord high) {
        Intrinsics.checkNotNullParameter(low, "low");
        Intrinsics.checkNotNullParameter(high, "high");
        return this.inBounds(low.x, high.x, low.y, high.y, low.z, high.z);
    }

    public final boolean inBounds(double lowX, double highX, double lowY, double highY, double lowZ, double highZ) {
        return this.x >= lowX && this.x <= highX && this.y >= lowY && this.y <= highY && this.z >= lowZ && this.z <= highZ;
    }

    public final double component1() {
        return this.x;
    }

    public final double component2() {
        return this.y;
    }

    public final double component3() {
        return this.z;
    }

    @NotNull
    public final Cord copy(double x, double y, double z) {
        return new Cord(x, y, z);
    }

    public static /* synthetic */ Cord copy$default(Cord cord, double d, double d2, double d3, int n, Object object) {
        if ((n & 1) != 0) {
            d = cord.x;
        }
        if ((n & 2) != 0) {
            d2 = cord.y;
        }
        if ((n & 4) != 0) {
            d3 = cord.z;
        }
        return cord.copy(d, d2, d3);
    }

    @NotNull
    public String toString() {
        return "Cord(x=" + this.x + ", y=" + this.y + ", z=" + this.z + ")";
    }

    public int hashCode() {
        int result = Double.hashCode(this.x);
        result = result * 31 + Double.hashCode(this.y);
        result = result * 31 + Double.hashCode(this.z);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Cord)) {
            return false;
        }
        Cord cord = (Cord)other;
        if (Double.compare(this.x, cord.x) != 0) {
            return false;
        }
        if (Double.compare(this.y, cord.y) != 0) {
            return false;
        }
        return Double.compare(this.z, cord.z) == 0;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0004\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007J\"\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\n2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005\u00a8\u0006\r"}, d2={"Lcom/marcpg/libpg/storing/Cord$Companion;", "", "<init>", "()V", "ofList", "Lcom/marcpg/libpg/storing/Cord;", "list", "", "", "corners", "Lkotlin/Pair;", "corner1", "corner2", "base"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Cord ofList(@NotNull List<? extends Number> list) {
            Intrinsics.checkNotNullParameter(list, "list");
            return new Cord(list.get(0).doubleValue(), list.get(1).doubleValue(), list.get(2).doubleValue());
        }

        @NotNull
        public final Pair<Cord, Cord> corners(@NotNull Cord corner1, @NotNull Cord corner2) {
            Intrinsics.checkNotNullParameter(corner1, "corner1");
            Intrinsics.checkNotNullParameter(corner2, "corner2");
            return TuplesKt.to(new Cord(Math.min(corner1.getX(), corner2.getX()), Math.min(corner1.getY(), corner2.getY()), Math.min(corner1.getZ(), corner2.getZ())), new Cord(Math.max(corner1.getX(), corner2.getX()), Math.max(corner1.getY(), corner2.getY()), Math.max(corner1.getZ(), corner2.getZ())));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

