/*
 * Decompiled with CFR 0.152.
 */
package com.marcpg.libpg.sarge;

import com.marcpg.libpg.sarge.CustomConvertedArgumentType;
import com.marcpg.libpg.util.GlobalFunctionsKt;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u00020\u00040\u0003B\u0015\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\r\u001a\u00028\u00002\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0016H\u0016J4\u0010\u0017\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u0018\"\n\b\u0001\u0010\u001a*\u0004\u0018\u00010\u001b2\u000e\u0010\u001c\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H\u001a0\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006 "}, d2={"Lcom/marcpg/libpg/sarge/EnumArgumentType;", "T", "", "Lcom/marcpg/libpg/sarge/CustomConvertedArgumentType;", "", "enumClass", "Ljava/lang/Class;", "<init>", "(Ljava/lang/Class;)V", "getEnumClass", "()Ljava/lang/Class;", "lowercaseEnumNames", "", "parse", "reader", "Lcom/mojang/brigadier/StringReader;", "(Lcom/mojang/brigadier/StringReader;)Ljava/lang/Enum;", "nativeType", "Lcom/mojang/brigadier/arguments/ArgumentType;", "getNativeType", "()Lcom/mojang/brigadier/arguments/ArgumentType;", "getExamples", "", "listSuggestions", "Ljava/util/concurrent/CompletableFuture;", "Lcom/mojang/brigadier/suggestion/Suggestions;", "S", "", "context", "Lcom/mojang/brigadier/context/CommandContext;", "builder", "Lcom/mojang/brigadier/suggestion/SuggestionsBuilder;", "KtLibPG-Brigadier"})
@SourceDebugExtension(value={"SMAP\nExtendedArgumentTypes.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExtendedArgumentTypes.kt\ncom/marcpg/libpg/sarge/EnumArgumentType\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,96:1\n11228#2:97\n11563#2,3:98\n*S KotlinDebug\n*F\n+ 1 ExtendedArgumentTypes.kt\ncom/marcpg/libpg/sarge/EnumArgumentType\n*L\n47#1:97\n47#1:98,3\n*E\n"})
public class EnumArgumentType<T extends Enum<T>>
implements CustomConvertedArgumentType<T, String> {
    @NotNull
    private final Class<T> enumClass;
    @NotNull
    private final List<String> lowercaseEnumNames;

    /*
     * WARNING - void declaration
     */
    public EnumArgumentType(@NotNull Class<T> enumClass) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(enumClass, "enumClass");
        this.enumClass = enumClass;
        T[] TArray = this.enumClass.getEnumConstants();
        Intrinsics.checkNotNullExpressionValue(TArray, "getEnumConstants(...)");
        T[] TArray2 = TArray;
        EnumArgumentType enumArgumentType = this;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Enum enum_ = (Enum)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.name().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
            collection.add(string);
        }
        enumArgumentType.lowercaseEnumNames = (List)destination$iv$iv;
    }

    @NotNull
    public final Class<T> getEnumClass() {
        return this.enumClass;
    }

    @Override
    @NotNull
    public T parse(@NotNull StringReader reader) {
        Intrinsics.checkNotNullParameter(reader, "reader");
        String text = reader.readString();
        try {
            Intrinsics.checkNotNull(text);
            return GlobalFunctionsKt.enumValueNoCase(this.enumClass, text);
        }
        catch (Exception e) {
            throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherParseException().createWithContext(reader, "Unknown enum type " + text);
        }
    }

    @Override
    @NotNull
    public ArgumentType<String> getNativeType() {
        StringArgumentType stringArgumentType = StringArgumentType.word();
        Intrinsics.checkNotNullExpressionValue(stringArgumentType, "word(...)");
        return stringArgumentType;
    }

    @Override
    @NotNull
    public Collection<String> getExamples() {
        return this.lowercaseEnumNames;
    }

    @Override
    @NotNull
    public <S> CompletableFuture<Suggestions> listSuggestions(@NotNull CommandContext<S> context, @NotNull SuggestionsBuilder builder) {
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(builder, "builder");
        for (String entry : this.lowercaseEnumNames) {
            CharSequence charSequence = entry;
            String string = builder.getRemainingLowerCase();
            Intrinsics.checkNotNullExpressionValue(string, "getRemainingLowerCase(...)");
            if (!StringsKt.contains$default(charSequence, string, false, 2, null)) continue;
            builder.suggest(entry);
        }
        CompletableFuture<Suggestions> completableFuture = builder.buildFuture();
        Intrinsics.checkNotNullExpressionValue(completableFuture, "buildFuture(...)");
        return completableFuture;
    }
}

