/*
 * Decompiled with CFR 0.152.
 */
package com.marcpg.libpg.lang;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u001a\u0010\r\u001a\u00020\u000e2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00120\tJ\u0016\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0012J&\u0010\u0016\u001a\u00020\u000e2\u001e\u0010\u0017\u001a\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\t0\tJ\"\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00052\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\tJ\u0016\u0010\u001a\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\nJ7\u0010\u001a\u001a\u00020\n2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00052\b\u0010\u001b\u001a\u0004\u0018\u00010\n2\u0016\u0010\u001c\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u001d\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u001eJ\u0010\u0010\u001f\u001a\u00020 2\b\u0010\u001b\u001a\u0004\u0018\u00010\nJ\u001a\u0010!\u001a\u00020 2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00052\b\u0010\u001b\u001a\u0004\u0018\u00010\nJ\u001c\u0010\"\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\n\u0018\u00010\t2\u0006\u0010#\u001a\u00020\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R)\u0010\b\u001a\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\t0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006$"}, d2={"Lcom/marcpg/libpg/lang/Translation;", "", "<init>", "()V", "DEFAULT_LOCALE", "Ljava/util/Locale;", "getDEFAULT_LOCALE", "()Ljava/util/Locale;", "TRANSLATIONS", "", "", "getTRANSLATIONS", "()Ljava/util/Map;", "loadProperties", "", "folder", "Ljava/nio/file/Path;", "languages", "Ljava/util/Properties;", "loadSingleProperties", "locale", "properties", "loadMaps", "maps", "loadSingleMap", "map", "string", "key", "variables", "", "(Ljava/util/Locale;Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", "isKey", "", "isTranslated", "reverse", "value", "base"})
@SourceDebugExtension(value={"SMAP\nTranslation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Translation.kt\ncom/marcpg/libpg/lang/Translation\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,154:1\n1#2:155\n216#3,2:156\n126#3:158\n153#3,3:159\n216#3,2:162\n*S KotlinDebug\n*F\n+ 1 Translation.kt\ncom/marcpg/libpg/lang/Translation\n*L\n55#1:156,2\n64#1:158\n64#1:159,3\n72#1:162,2\n*E\n"})
public final class Translation {
    @NotNull
    public static final Translation INSTANCE = new Translation();
    @NotNull
    private static final Locale DEFAULT_LOCALE;
    @NotNull
    private static final Map<Locale, Map<String, String>> TRANSLATIONS;

    private Translation() {
    }

    @NotNull
    public final Locale getDEFAULT_LOCALE() {
        return DEFAULT_LOCALE;
    }

    @NotNull
    public final Map<Locale, Map<String, String>> getTRANSLATIONS() {
        return TRANSLATIONS;
    }

    public final void loadProperties(@NotNull Path folder) throws IOException {
        Intrinsics.checkNotNullParameter(folder, "folder");
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(folder, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            boolean $i$a$-require-Translation$loadProperties$22 = false;
            String $i$a$-require-Translation$loadProperties$22 = "Specified translation folder does not exist: " + folder;
            throw new IllegalArgumentException($i$a$-require-Translation$loadProperties$22.toString());
        }
        for (Path path : PathsKt.listDirectoryEntries$default(folder, null, 1, null)) {
            Properties properties = new Properties();
            OpenOption[] openOptionArray = new OpenOption[]{};
            InputStream inputStream = Files.newInputStream(path, Arrays.copyOf(openOptionArray, openOptionArray.length));
            Intrinsics.checkNotNullExpressionValue(inputStream, "newInputStream(...)");
            properties.load(inputStream);
            char[] cArray = new char[]{'_'};
            List languageAndCountry = StringsKt.split$default((CharSequence)PathsKt.getNameWithoutExtension(path), cArray, false, 0, 6, null);
            Locale locale = Locale.of((String)languageAndCountry.get(0), (String)languageAndCountry.get(1));
            Intrinsics.checkNotNullExpressionValue(locale, "of(...)");
            this.loadSingleProperties(locale, properties);
        }
    }

    public final void loadProperties(@NotNull Map<Locale, Properties> languages) {
        Intrinsics.checkNotNullParameter(languages, "languages");
        Map<Locale, Properties> $this$forEach$iv = languages;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<Locale, Properties>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<Locale, Properties> element$iv;
            Map.Entry<Locale, Properties> entry = element$iv = iterator2.next();
            boolean bl = false;
            Locale l = entry.getKey();
            Properties p = entry.getValue();
            INSTANCE.loadSingleProperties(l, p);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void loadSingleProperties(@NotNull Locale locale, @NotNull Properties properties) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(locale, "locale");
        Intrinsics.checkNotNullParameter(properties, "properties");
        Map<Locale, Map<String, String>> map = TRANSLATIONS;
        Map $this$map$iv = properties;
        boolean $i$f$map = false;
        Map map2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator2.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to(it.getKey().toString(), it.getValue().toString()));
        }
        Map map3 = MapsKt.toMutableMap(MapsKt.toMap((List)destination$iv$iv));
        map.put(locale, map3);
    }

    public final void loadMaps(@NotNull Map<Locale, Map<String, String>> maps) {
        Intrinsics.checkNotNullParameter(maps, "maps");
        Map<Locale, Map<String, String>> $this$forEach$iv = maps;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<Locale, Map<String, String>>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<Locale, Map<String, String>> element$iv;
            Map.Entry<Locale, Map<String, String>> it = element$iv = iterator2.next();
            boolean bl = false;
            INSTANCE.loadSingleMap(it.getKey(), it.getValue());
        }
    }

    public final void loadSingleMap(@NotNull Locale locale, @NotNull Map<String, String> map) {
        Intrinsics.checkNotNullParameter(locale, "locale");
        Intrinsics.checkNotNullParameter(map, "map");
        TRANSLATIONS.put(locale, map);
    }

    @NotNull
    public final String string(@NotNull Locale locale, @NotNull String key) {
        Intrinsics.checkNotNullParameter(locale, "locale");
        Intrinsics.checkNotNullParameter(key, "key");
        Map<String, String> map = TRANSLATIONS.get(TRANSLATIONS.containsKey(locale) ? locale : DEFAULT_LOCALE);
        if (map == null || (map = map.getOrDefault(key, key)) == null) {
            map = key;
        }
        return map;
    }

    @NotNull
    public final String string(@Nullable Locale locale, @Nullable String key, Object ... variables) {
        Intrinsics.checkNotNullParameter(variables, "variables");
        Locale locale2 = locale;
        Intrinsics.checkNotNull(locale2);
        String string = key;
        Intrinsics.checkNotNull(string);
        String string2 = MessageFormat.format(this.string(locale2, string), Arrays.copyOf(variables, variables.length));
        Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
        return string2;
    }

    public final boolean isKey(@Nullable String key) {
        return this.isTranslated(DEFAULT_LOCALE, key);
    }

    public final boolean isTranslated(@Nullable Locale locale, @Nullable String key) {
        Map<String, String> map = TRANSLATIONS.get(locale);
        return map != null ? map.containsKey(key) : false;
    }

    @Nullable
    public final Map<Locale, String> reverse(@NotNull String value) {
        Map map;
        Intrinsics.checkNotNullParameter(value, "value");
        Map result = new LinkedHashMap();
        for (Map.Entry<Locale, Map<String, String>> localeEntry : TRANSLATIONS.entrySet()) {
            for (Map.Entry<String, String> translation : localeEntry.getValue().entrySet()) {
                if (!Intrinsics.areEqual(value, translation.getValue())) continue;
                result.put(localeEntry.getKey(), translation.getKey());
            }
        }
        Map map2 = result;
        if (map2.isEmpty()) {
            boolean bl = false;
            map = null;
        } else {
            map = map2;
        }
        return map;
    }

    static {
        Locale locale = Locale.of("en", "US");
        Intrinsics.checkNotNullExpressionValue(locale, "of(...)");
        DEFAULT_LOCALE = locale;
        TRANSLATIONS = new LinkedHashMap();
    }
}

