/*
 * Decompiled with CFR 0.152.
 */
package com.marcpg.libpg.init;

import io.papermc.paper.plugin.loader.PluginClasspathBuilder;
import io.papermc.paper.plugin.loader.PluginLoader;
import io.papermc.paper.plugin.loader.library.ClassPathLibrary;
import io.papermc.paper.plugin.loader.library.impl.MavenLibraryResolver;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.repository.RemoteRepository;
import org.jetbrains.annotations.NotNull;

public abstract class PaperLoaderPG
implements PluginLoader {
    private final Map<String, String> dependencies = new HashMap<String, String>();
    private final Map<String, String> repositories = new HashMap<String, String>();

    public abstract String kotlinVersion();

    public boolean downloadKotlinStdLib() {
        return true;
    }

    public abstract void load();

    public final void classloader(@NotNull PluginClasspathBuilder classpathBuilder) {
        this.addRepository("https://maven-central.storage-download.googleapis.com/maven2", "maven-central");
        if (this.downloadKotlinStdLib()) {
            this.addDependency("kotlin.KotlinVersion", "org.jetbrains.kotlin:kotlin-stdlib:" + this.kotlinVersion());
        }
        this.load();
        MavenLibraryResolver resolver = new MavenLibraryResolver();
        for (Map.Entry<String, String> repo : this.repositories.entrySet()) {
            resolver.addRepository(new RemoteRepository.Builder(repo.getValue(), "default", repo.getKey()).build());
        }
        for (Map.Entry<String, String> dep : this.dependencies.entrySet()) {
            try {
                Class.forName(dep.getValue());
            }
            catch (ClassNotFoundException e) {
                resolver.addDependency(new Dependency((Artifact)new DefaultArtifact(dep.getKey()), null));
            }
        }
        classpathBuilder.addLibrary((ClassPathLibrary)resolver);
    }

    protected void addRepository(String url, String name) {
        this.repositories.putIfAbsent(url, name);
    }

    protected void addDependency(String className, String artifactId) {
        this.dependencies.put(artifactId, className);
    }
}

