/*
 * Decompiled with CFR 0.152.
 */
package com.marcpg.libpg.init;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.marcpg.libpg.MinecraftLibPG;
import com.marcpg.libpg.init.KotlinPluginCompanion;
import com.marcpg.libpg.lang.Translation;
import com.marcpg.libpg.log.SLF4JLogger;
import com.marcpg.libpg.util.ServerUtils;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.event.Listener;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010\u0011\n\u0002\b\u0006\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\r\u001a\u00020\u000eH&J\b\u0010\u000f\u001a\u00020\u000eH\u0016J\u0006\u0010\u0010\u001a\u00020\u000eJ\u0006\u0010\u0011\u001a\u00020\u000eJ\u000e\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014J\u001f\u0010\u0015\u001a\u00020\u00162\u0012\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\u0017\"\u00020\n\u00a2\u0006\u0002\u0010\u0018J\u0006\u0010\u0019\u001a\u00020\u000eJ\u001f\u0010\u001a\u001a\u00020\u00162\u0012\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u0017\"\u00020\f\u00a2\u0006\u0002\u0010\u001bJ\u0006\u0010\u001c\u001a\u00020\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/marcpg/libpg/init/KotlinPlugin;", "Lorg/bukkit/plugin/java/JavaPlugin;", "companion", "Lcom/marcpg/libpg/init/KotlinPluginCompanion;", "<init>", "(Lcom/marcpg/libpg/init/KotlinPluginCompanion;)V", "getCompanion", "()Lcom/marcpg/libpg/init/KotlinPluginCompanion;", "listeners", "", "Lorg/bukkit/event/Listener;", "commands", "Lcom/marcpg/libpg/util/ServerUtils$Cmd;", "enable", "", "disable", "onEnable", "onDisable", "loadTranslations", "uri", "Ljava/net/URI;", "addListeners", "", "", "([Lorg/bukkit/event/Listener;)Z", "clearListeners", "addCommands", "([Lcom/marcpg/libpg/util/ServerUtils$Cmd;)Z", "clearCommands", "KtLibPG-Paper"})
@SourceDebugExtension(value={"SMAP\nKotlinPlugin.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinPlugin.kt\ncom/marcpg/libpg/init/KotlinPlugin\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,104:1\n37#2:105\n36#2,3:106\n37#2:109\n36#2,3:110\n*S KotlinDebug\n*F\n+ 1 KotlinPlugin.kt\ncom/marcpg/libpg/init/KotlinPlugin\n*L\n49#1:105\n49#1:106,3\n50#1:109\n50#1:110,3\n*E\n"})
public abstract class KotlinPlugin
extends JavaPlugin {
    @NotNull
    private final KotlinPluginCompanion companion;
    @NotNull
    private final List<Listener> listeners;
    @NotNull
    private final List<ServerUtils.Cmd> commands;

    public KotlinPlugin(@NotNull KotlinPluginCompanion companion) {
        Intrinsics.checkNotNullParameter(companion, "companion");
        this.companion = companion;
        this.listeners = new ArrayList();
        this.commands = new ArrayList();
    }

    @NotNull
    public final KotlinPluginCompanion getCompanion() {
        return this.companion;
    }

    public abstract void enable();

    public void disable() {
    }

    public final void onEnable() {
        Logger logger = this.getSLF4JLogger();
        Intrinsics.checkNotNullExpressionValue(logger, "getSLF4JLogger(...)");
        this.companion.setLOG(new SLF4JLogger(logger));
        Path path = this.getDataPath();
        Intrinsics.checkNotNullExpressionValue(path, "getDataPath(...)");
        this.companion.setDATA_DIR(path);
        MinecraftLibPG.INSTANCE.init$KtLibPG_Paper(this);
        this.enable();
        Collection $this$toTypedArray$iv = this.listeners;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Object[] objectArray = thisCollection$iv.toArray(new Listener[0]);
        ServerUtils.INSTANCE.registerEvents(Arrays.copyOf(objectArray, objectArray.length));
        $this$toTypedArray$iv = this.commands;
        $i$f$toTypedArray = false;
        thisCollection$iv = $this$toTypedArray$iv;
        objectArray = thisCollection$iv.toArray(new ServerUtils.Cmd[0]);
        ServerUtils.INSTANCE.registerCommands((ServerUtils.Cmd[])Arrays.copyOf(objectArray, objectArray.length));
    }

    public final void onDisable() {
        this.disable();
    }

    public final void loadTranslations(@NotNull URI uri) {
        block6: {
            Object object;
            Object object2;
            Intrinsics.checkNotNullParameter(uri, "uri");
            Object object3 = this;
            try {
                KotlinPlugin $this$loadTranslations_u24lambda_u240 = object3;
                boolean bl = false;
                HttpRequest request = HttpRequest.newBuilder(uri).GET().build();
                String response = HttpClient.newHttpClient().send(request, HttpResponse.BodyHandlers.ofString()).body();
                Object object4 = new Gson().fromJson(response, new TypeToken<Map<Locale, ? extends Map<String, ? extends String>>>(){}.getType());
                Intrinsics.checkNotNullExpressionValue(object4, "fromJson(...)");
                Translation.INSTANCE.loadMaps((Map)object4);
                object2 = Result.constructor-impl(Unit.INSTANCE);
            }
            catch (Throwable bl) {
                object2 = Result.constructor-impl(ResultKt.createFailure(bl));
            }
            object3 = object2;
            object2 = Result.exceptionOrNull-impl(object3);
            if (object2 == null) {
                object = object3;
            } else {
                Object it;
                Object bl = object3;
                try {
                    it = object2;
                    boolean bl2 = false;
                    this.companion.getLOG().warn("Could not retrieve translations from " + uri + ".");
                    Properties properties = new Properties();
                    InputStream inputStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("en_US.properties");
                    Intrinsics.checkNotNull(inputStream);
                    properties.load(inputStream);
                    Locale locale = Locale.getDefault();
                    Intrinsics.checkNotNullExpressionValue(locale, "getDefault(...)");
                    Translation.INSTANCE.loadSingleProperties(locale, properties);
                    this.companion.getLOG().warn("Using fallback english language. The plugin will continue to work as usual, just without translations.");
                    it = Result.constructor-impl(Unit.INSTANCE);
                }
                catch (Throwable throwable) {
                    it = Result.constructor-impl(ResultKt.createFailure(throwable));
                }
                object = it;
            }
            object3 = object;
            Throwable throwable = Result.exceptionOrNull-impl(object3);
            if (throwable == null) break block6;
            Object it = object2 = throwable;
            boolean bl = false;
            this.companion.getLOG().error("No default translations attached in resources, text will be broken.");
        }
    }

    public final boolean addListeners(Listener ... listeners) {
        Intrinsics.checkNotNullParameter(listeners, "listeners");
        return CollectionsKt.addAll((Collection)this.listeners, listeners);
    }

    public final void clearListeners() {
        this.listeners.clear();
    }

    public final boolean addCommands(ServerUtils.Cmd ... commands) {
        Intrinsics.checkNotNullParameter(commands, "commands");
        return CollectionsKt.addAll((Collection)this.commands, commands);
    }

    public final void clearCommands() {
        this.commands.clear();
    }
}

