/*
 * Decompiled with CFR 0.152.
 */
package com.marcpg.libpg.display;

import com.marcpg.libpg.display.MinecraftReceiver;
import com.marcpg.libpg.display.PlayerMinecraftReceiverKt;
import com.marcpg.libpg.display.ScoreboardEntry;
import com.marcpg.libpg.display.SimpleDisplay;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.scoreboard.Criteria;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.ScoreboardManager;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0016\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0012\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\t\"\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\u0016\u001a\u00020\u0017H\u0014J\b\u0010\u0018\u001a\u00020\u0017H\u0014J\b\u0010\u0019\u001a\u00020\u0017H\u0014J\b\u0010\u001a\u001a\u00020\u0017H\u0014R\u001b\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\t\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001c"}, d2={"Lcom/marcpg/libpg/display/SimpleScoreboard;", "Lcom/marcpg/libpg/display/SimpleDisplay;", "receiver", "Lcom/marcpg/libpg/display/MinecraftReceiver;", "updateInterval", "", "title", "Lnet/kyori/adventure/text/Component;", "scores", "", "Lcom/marcpg/libpg/display/ScoreboardEntry;", "<init>", "(Lcom/marcpg/libpg/display/MinecraftReceiver;JLnet/kyori/adventure/text/Component;[Lcom/marcpg/libpg/display/ScoreboardEntry;)V", "getScores", "()[Lcom/marcpg/libpg/display/ScoreboardEntry;", "[Lcom/marcpg/libpg/display/ScoreboardEntry;", "scoreboard", "Lorg/bukkit/scoreboard/Scoreboard;", "objective", "Lorg/bukkit/scoreboard/Objective;", "getObjective", "()Lorg/bukkit/scoreboard/Objective;", "extraStart", "", "setup", "update", "remove", "Companion", "KtLibPG-Paper"})
@SourceDebugExtension(value={"SMAP\nScoreboard.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Scoreboard.kt\ncom/marcpg/libpg/display/SimpleScoreboard\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,127:1\n1869#2,2:128\n13472#3,2:130\n*S KotlinDebug\n*F\n+ 1 Scoreboard.kt\ncom/marcpg/libpg/display/SimpleScoreboard\n*L\n28#1:128,2\n43#1:130,2\n*E\n"})
public class SimpleScoreboard
extends SimpleDisplay {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final ScoreboardEntry[] scores;
    @NotNull
    private final Scoreboard scoreboard;
    @NotNull
    private final Objective objective;
    @NotNull
    private static final ScoreboardManager MANAGER;

    public SimpleScoreboard(@NotNull MinecraftReceiver receiver, long updateInterval, @NotNull Component title, ScoreboardEntry ... scores) {
        Scoreboard scoreboard;
        Intrinsics.checkNotNullParameter(receiver, "receiver");
        Intrinsics.checkNotNullParameter(title, "title");
        Intrinsics.checkNotNullParameter(scores, "scores");
        super(receiver, updateInterval);
        this.scores = scores;
        if (Intrinsics.areEqual(PlayerMinecraftReceiverKt.getScoreboard(receiver), MANAGER.getMainScoreboard())) {
            Scoreboard scoreboard2 = MANAGER.getNewScoreboard();
            scoreboard = scoreboard2;
            Intrinsics.checkNotNullExpressionValue(scoreboard2, "getNewScoreboard(...)");
        } else {
            scoreboard = PlayerMinecraftReceiverKt.getScoreboard(receiver);
        }
        this.scoreboard = scoreboard;
        Set set = this.scoreboard.getObjectives();
        Intrinsics.checkNotNullExpressionValue(set, "getObjectives(...)");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Objective it = (Objective)element$iv;
            boolean bl = false;
            it.unregister();
        }
        Objective objective = this.scoreboard.getObjective("libpg");
        if (objective == null) {
            Objective objective2 = this.scoreboard.registerNewObjective("libpg", Criteria.DUMMY, title);
            objective = objective2;
            Intrinsics.checkNotNullExpressionValue(objective2, "registerNewObjective(...)");
        }
        this.objective = objective;
        this.objective.setDisplaySlot(DisplaySlot.SIDEBAR);
    }

    @NotNull
    public final ScoreboardEntry[] getScores() {
        return this.scores;
    }

    @NotNull
    public final Objective getObjective() {
        return this.objective;
    }

    @Override
    protected void extraStart() {
        PlayerMinecraftReceiverKt.setScoreboard(this.getReceiver(), this.scoreboard);
    }

    @Override
    protected void setup() {
        ScoreboardEntry[] scoreboardEntryArray = this.scores;
        int n = scoreboardEntryArray.length;
        for (int i = 0; i < n; ++i) {
            int index = i;
            ScoreboardEntry score = scoreboardEntryArray[i];
            score.init(index, this);
        }
    }

    @Override
    protected void update() {
        ScoreboardEntry[] $this$forEach$iv = this.scores;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            ScoreboardEntry element$iv;
            ScoreboardEntry it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            it.update(this);
        }
    }

    @Override
    protected void remove() {
        this.scoreboard.clearSlot(DisplaySlot.SIDEBAR);
        this.objective.unregister();
        MinecraftReceiver minecraftReceiver = this.getReceiver();
        Scoreboard scoreboard = Bukkit.getScoreboardManager().getMainScoreboard();
        Intrinsics.checkNotNullExpressionValue(scoreboard, "getMainScoreboard(...)");
        PlayerMinecraftReceiverKt.setScoreboard(minecraftReceiver, scoreboard);
    }

    static {
        ScoreboardManager scoreboardManager = Bukkit.getScoreboardManager();
        Intrinsics.checkNotNullExpressionValue(scoreboardManager, "getScoreboardManager(...)");
        MANAGER = scoreboardManager;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/marcpg/libpg/display/SimpleScoreboard$Companion;", "", "<init>", "()V", "MANAGER", "Lorg/bukkit/scoreboard/ScoreboardManager;", "Lorg/jetbrains/annotations/NotNull;", "KtLibPG-Paper"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

