/*
 * Decompiled with CFR 0.152.
 */
package com.marcpg.libpg.display;

import com.marcpg.libpg.data.modifiable.ModifiableImpl;
import com.marcpg.libpg.display.MinecraftReceiver;
import com.marcpg.libpg.display.PlayerMinecraftReceiverKt;
import com.marcpg.libpg.storing.Cord;
import com.marcpg.libpg.util.AdventureExtensionsKt;
import com.marcpg.libpg.util.PaperExtensionsKt;
import java.util.Arrays;
import java.util.Locale;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.audience.ForwardingAudience;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0016\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\f\u001a\u00020\rJ\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0012\u001a\u00020\rJ0\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0006\u0010\u001e\u001a\u00020\u001fJA\u0010 \u001a\u00020\u00142\u0006\u0010!\u001a\u00020\r2\u0016\u0010\"\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\r0#\"\u0004\u0018\u00010\r2\b\u0010$\u001a\u0004\u0018\u00010%2\b\u0010&\u001a\u0004\u0018\u00010'H\u0016\u00a2\u0006\u0002\u0010(JA\u0010)\u001a\u00020\u00142\u0006\u0010!\u001a\u00020\r2\u0016\u0010\"\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\r0#\"\u0004\u0018\u00010\r2\b\u0010$\u001a\u0004\u0018\u00010%2\b\u0010&\u001a\u0004\u0018\u00010'H\u0016\u00a2\u0006\u0002\u0010(J\u0010\u0010*\u001a\u00020\u00142\b\u0010+\u001a\u0004\u0018\u00010,J\u0010\u0010-\u001a\u00020\u00142\b\u0010+\u001a\u0004\u0018\u00010,J\u0010\u0010.\u001a\u00020/2\b\u0010+\u001a\u0004\u0018\u00010,R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u00060"}, d2={"Lcom/marcpg/libpg/display/PlayerMinecraftReceiver;", "Lcom/marcpg/libpg/data/modifiable/ModifiableImpl;", "Lcom/marcpg/libpg/display/MinecraftReceiver;", "Lnet/kyori/adventure/audience/ForwardingAudience$Single;", "player", "Lorg/bukkit/entity/Player;", "<init>", "(Lorg/bukkit/entity/Player;)V", "getPlayer", "()Lorg/bukkit/entity/Player;", "audience", "Lnet/kyori/adventure/audience/Audience;", "name", "", "uuid", "Ljava/util/UUID;", "locale", "Ljava/util/Locale;", "toString", "playSound", "", "sound", "Lnet/kyori/adventure/key/Key;", "volume", "", "pitch", "source", "Lnet/kyori/adventure/sound/Sound$Source;", "emitter", "Lnet/kyori/adventure/sound/Sound$Emitter;", "cord", "Lcom/marcpg/libpg/storing/Cord;", "sendMessage", "key", "variables", "", "color", "Lnet/kyori/adventure/text/format/TextColor;", "decoration", "Lnet/kyori/adventure/text/format/TextDecoration;", "(Ljava/lang/String;[Ljava/lang/String;Lnet/kyori/adventure/text/format/TextColor;Lnet/kyori/adventure/text/format/TextDecoration;)V", "sendActionBar", "addModifier", "modifier", "", "removeModifier", "hasModifier", "", "KtLibPG-Paper"})
public class PlayerMinecraftReceiver
extends ModifiableImpl
implements MinecraftReceiver,
ForwardingAudience.Single {
    @NotNull
    private final Player player;

    public PlayerMinecraftReceiver(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        this.player = player;
    }

    @NotNull
    public final Player getPlayer() {
        return this.player;
    }

    @NotNull
    public final Audience audience() {
        return (Audience)this.player;
    }

    @Override
    @NotNull
    public final String name() {
        String string = this.player.getName();
        Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
        return string;
    }

    @Override
    @NotNull
    public final UUID uuid() {
        UUID uUID = this.player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        return uUID;
    }

    @Override
    @NotNull
    public final Locale locale() {
        Locale locale = this.player.locale();
        Intrinsics.checkNotNullExpressionValue(locale, "locale(...)");
        return locale;
    }

    @Override
    @NotNull
    public final String toString() {
        return this.name();
    }

    @Override
    public void playSound(@NotNull Key sound, float volume, float pitch, @NotNull Sound.Source source, @NotNull Sound.Emitter emitter) {
        Intrinsics.checkNotNullParameter(sound, "sound");
        Intrinsics.checkNotNullParameter(source, "source");
        Intrinsics.checkNotNullParameter(emitter, "emitter");
        this.player.playSound(Sound.sound((Key)sound, (Sound.Source)source, (float)volume, (float)pitch), emitter);
    }

    @Override
    @NotNull
    public final Cord cord() {
        return PaperExtensionsKt.toCord(PlayerMinecraftReceiverKt.location(this));
    }

    @Override
    public void sendMessage(@NotNull String key, @NotNull String[] variables, @Nullable TextColor color, @Nullable TextDecoration decoration) {
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(variables, "variables");
        this.player.sendMessage(AdventureExtensionsKt.component(this.locale(), key, Arrays.copyOf(variables, variables.length), color, decoration));
    }

    @Override
    public void sendActionBar(@NotNull String key, @NotNull String[] variables, @Nullable TextColor color, @Nullable TextDecoration decoration) {
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(variables, "variables");
        this.player.sendActionBar(AdventureExtensionsKt.component(this.locale(), key, Arrays.copyOf(variables, variables.length), color, decoration));
    }

    @Override
    public final void addModifier(@Nullable Object modifier) {
        super.addModifier(modifier);
    }

    @Override
    public final void removeModifier(@Nullable Object modifier) {
        super.removeModifier(modifier);
    }

    @Override
    public final boolean hasModifier(@Nullable Object modifier) {
        return super.hasModifier(modifier);
    }

    @Override
    public void eachReceiver(@NotNull Function1<? super MinecraftReceiver, Unit> action) {
        MinecraftReceiver.super.eachReceiver(action);
    }
}

