/*
 * Decompiled with CFR 0.152.
 */
package com.marcpg.libpg.data.length;

import com.marcpg.libpg.data.Quantity;
import com.marcpg.libpg.data.QuantityUnit;
import com.marcpg.libpg.data.QuantityUtils;
import java.util.List;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0004\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u001c2\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u001c\u001dB\u001b\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bB\u0011\b\u0016\u0012\u0006\u0010\t\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0007\u0010\nB#\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\rJ\u0010\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0004H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0013\u0010\u0019\u001a\u00020\u00062\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0096\u0002R\u0014\u0010\u000e\u001a\u00020\u0000X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001e"}, d2={"Lcom/marcpg/libpg/data/length/Length;", "Lcom/marcpg/libpg/data/Quantity;", "Lcom/marcpg/libpg/data/length/Length$Unit;", "data", "", "allowNegatives", "", "<init>", "(JZ)V", "quantity", "(Lcom/marcpg/libpg/data/length/Length;)V", "", "unit", "(Ljava/lang/Number;Lcom/marcpg/libpg/data/length/Length$Unit;Z)V", "thisInst", "getThisInst", "()Lcom/marcpg/libpg/data/length/Length;", "units", "", "Lcom/marcpg/libpg/data/QuantityUnit;", "getUnits", "()Ljava/util/List;", "construct", "hashCode", "", "equals", "other", "", "Companion", "Unit", "base"})
public final class Length
extends Quantity<Length, Unit> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Length thisInst;
    @NotNull
    private final List<QuantityUnit> units;

    public Length(long data, boolean allowNegatives) {
        super(data, allowNegatives);
        this.thisInst = this;
        this.units = Unit.getEntries();
    }

    public /* synthetic */ Length(long l, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            l = 0L;
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        this(l, bl);
    }

    public Length(@NotNull Length quantity) {
        Intrinsics.checkNotNullParameter(quantity, "quantity");
        this(quantity.getData(), quantity.getAllowNegatives());
    }

    public Length(@NotNull Number data, @NotNull Unit unit, boolean allowNegatives) {
        Intrinsics.checkNotNullParameter(data, "data");
        Intrinsics.checkNotNullParameter(unit, "unit");
        this(data instanceof Integer || data instanceof Double ? data.longValue() * unit.getBaseEquivalent() : (long)(data.doubleValue() * (double)unit.getBaseEquivalent()), allowNegatives);
    }

    public /* synthetic */ Length(Number number, Unit unit, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = false;
        }
        this(number, unit, bl);
    }

    @Override
    @NotNull
    protected Length getThisInst() {
        return this.thisInst;
    }

    @Override
    @NotNull
    public List<QuantityUnit> getUnits() {
        return this.units;
    }

    @Override
    @NotNull
    public Length construct(long data) {
        return new Length(data, false, 2, null);
    }

    @Override
    public int hashCode() {
        return 31 * Long.hashCode(this.getData()) + Boolean.hashCode(this.getAllowNegatives());
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Length)) {
            return false;
        }
        return this.getData() == ((Length)other).getData();
    }

    public Length() {
        this(0L, false, 3, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/marcpg/libpg/data/length/Length$Companion;", "", "<init>", "()V", "parse", "Lcom/marcpg/libpg/data/length/Length;", "input", "", "base"})
    @SourceDebugExtension(value={"SMAP\nLength.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Length.kt\ncom/marcpg/libpg/data/length/Length$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,74:1\n1#2:75\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Length parse(@NotNull String input) {
            Length length;
            Intrinsics.checkNotNullParameter(input, "input");
            Long l = QuantityUtils.INSTANCE.parse(input, (List<? extends QuantityUnit>)Unit.getEntries());
            if (l != null) {
                long it = ((Number)l).longValue();
                boolean bl = false;
                length = new Length(it, false, 2, null);
            } else {
                length = null;
            }
            return length;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000e\b\u0086\u0081\u0002\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002B\u0019\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u0013\u001a\u00020\u0006H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012\u00a8\u0006\u0014"}, d2={"Lcom/marcpg/libpg/data/length/Length$Unit;", "Lcom/marcpg/libpg/data/QuantityUnit;", "", "baseEquivalent", "", "abb", "", "<init>", "(Ljava/lang/String;IJLjava/lang/String;)V", "getBaseEquivalent", "()J", "getAbb", "()Ljava/lang/String;", "NANOMETERS", "MICROMETERS", "MILLIMETERS", "CENTIMETERS", "METERS", "KILOMETERS", "toString", "base"})
    public static final class Unit
    extends Enum<Unit>
    implements QuantityUnit {
        private final long baseEquivalent;
        @NotNull
        private final String abb;
        public static final /* enum */ Unit NANOMETERS = new Unit(1L, "nm");
        public static final /* enum */ Unit MICROMETERS = new Unit(NANOMETERS.getBaseEquivalent() * 1000L, "\u00b5m");
        public static final /* enum */ Unit MILLIMETERS = new Unit(MICROMETERS.getBaseEquivalent() * 1000L, "mm");
        public static final /* enum */ Unit CENTIMETERS = new Unit(MILLIMETERS.getBaseEquivalent() * 10L, "cm");
        public static final /* enum */ Unit METERS = new Unit(CENTIMETERS.getBaseEquivalent() * 100L, "m");
        public static final /* enum */ Unit KILOMETERS = new Unit(METERS.getBaseEquivalent() * 1000L, "km");
        private static final /* synthetic */ Unit[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private Unit(long baseEquivalent, String abb) {
            this.baseEquivalent = baseEquivalent;
            this.abb = abb;
        }

        @Override
        public long getBaseEquivalent() {
            return this.baseEquivalent;
        }

        @Override
        @NotNull
        public String getAbb() {
            return this.abb;
        }

        @NotNull
        public String toString() {
            return this.eng();
        }

        public static Unit[] values() {
            return (Unit[])$VALUES.clone();
        }

        public static Unit valueOf(String value) {
            return Enum.valueOf(Unit.class, value);
        }

        @NotNull
        public static EnumEntries<Unit> getEntries() {
            return $ENTRIES;
        }

        @Override
        @NotNull
        public String eng() {
            return QuantityUnit.super.eng();
        }

        @Override
        @NotNull
        public String pluralEng() {
            return QuantityUnit.super.pluralEng();
        }

        static {
            $VALUES = unitArray = new Unit[]{Unit.NANOMETERS, Unit.MICROMETERS, Unit.MILLIMETERS, Unit.CENTIMETERS, Unit.METERS, Unit.KILOMETERS};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

