/*
 * Decompiled with CFR 0.152.
 */
package com.marcpg.libpg.data;

import com.marcpg.libpg.data.Quantity;
import com.marcpg.libpg.data.QuantityUnit;
import com.marcpg.libpg.util.ExtensionsKt;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\u0016\u0010\u0004\u001a\u00020\u00052\u000e\u0010\u000b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\fJ\u001c\u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\u0016\u0010\r\u001a\u00020\u00052\u000e\u0010\u000b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\fJ(\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00070\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\"\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00070\u000f2\u000e\u0010\u000b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\fJ#\u0010\u0010\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0011\u001a\u00020\u00052\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lcom/marcpg/libpg/data/QuantityUtils;", "", "<init>", "()V", "oneUnitFormat", "", "data", "", "units", "", "Lcom/marcpg/libpg/data/QuantityUnit;", "quantity", "Lcom/marcpg/libpg/data/Quantity;", "preciselyFormat", "preciseUnits", "", "parse", "input", "(Ljava/lang/String;Ljava/util/List;)Ljava/lang/Long;", "base"})
@SourceDebugExtension(value={"SMAP\nQuantity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Quantity.kt\ncom/marcpg/libpg/data/QuantityUtils\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,291:1\n216#2,2:292\n*S KotlinDebug\n*F\n+ 1 Quantity.kt\ncom/marcpg/libpg/data/QuantityUtils\n*L\n193#1:292,2\n*E\n"})
public final class QuantityUtils {
    @NotNull
    public static final QuantityUtils INSTANCE = new QuantityUtils();

    private QuantityUtils() {
    }

    @NotNull
    public final String oneUnitFormat(long data, @NotNull List<? extends QuantityUnit> units) {
        Intrinsics.checkNotNullParameter(units, "units");
        for (int i = units.size(); 0 < i; --i) {
            QuantityUnit unit = units.get(i - 1);
            if (data < unit.getBaseEquivalent()) continue;
            return data / unit.getBaseEquivalent() + unit.getAbb();
        }
        return data + CollectionsKt.first(units).getAbb();
    }

    @NotNull
    public final String oneUnitFormat(@NotNull Quantity<?, ?> quantity) {
        Intrinsics.checkNotNullParameter(quantity, "quantity");
        return this.oneUnitFormat(quantity.get(), quantity.getUnits());
    }

    @NotNull
    public final String preciselyFormat(long data, @NotNull List<? extends QuantityUnit> units) {
        Intrinsics.checkNotNullParameter(units, "units");
        StringBuilder result = new StringBuilder();
        Map<QuantityUnit, Long> $this$forEach$iv = this.preciseUnits(data, units);
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<QuantityUnit, Long>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<QuantityUnit, Long> element$iv;
            Map.Entry<QuantityUnit, Long> entry = element$iv = iterator2.next();
            boolean bl = false;
            QuantityUnit u = entry.getKey();
            long v = ((Number)entry.getValue()).longValue();
            result.append(v).append(u.getAbb());
        }
        String string = result.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    @NotNull
    public final String preciselyFormat(@NotNull Quantity<?, ?> quantity) {
        Intrinsics.checkNotNullParameter(quantity, "quantity");
        return this.preciselyFormat(quantity.get(), quantity.getUnits());
    }

    @NotNull
    public final Map<QuantityUnit, Long> preciseUnits(long data, @NotNull List<? extends QuantityUnit> units) {
        Intrinsics.checkNotNullParameter(units, "units");
        long data2 = data;
        Map result = new LinkedHashMap();
        for (int i = units.size(); 0 < i; --i) {
            QuantityUnit unit = units.get(i - 1);
            if (data2 < unit.getBaseEquivalent()) continue;
            long quotient = data2 / unit.getBaseEquivalent();
            data2 %= unit.getBaseEquivalent();
            result.put(unit, quotient);
        }
        if (data2 > 0L) {
            result.put(CollectionsKt.first(units), data2);
        }
        return result;
    }

    @NotNull
    public final Map<QuantityUnit, Long> preciseUnits(@NotNull Quantity<?, ?> quantity) {
        Intrinsics.checkNotNullParameter(quantity, "quantity");
        return this.preciseUnits(quantity.get(), quantity.getUnits());
    }

    @Nullable
    public final Long parse(@NotNull String input, @NotNull List<? extends QuantityUnit> units) {
        Intrinsics.checkNotNullParameter(input, "input");
        Intrinsics.checkNotNullParameter(units, "units");
        Matcher matcher = Pattern.compile("(\\d+)|([a-zA-Z]+)").matcher(input);
        String text = null;
        String number = null;
        while (matcher.find()) {
            if (matcher.group(1) != null) {
                number = matcher.group(1);
                continue;
            }
            text = matcher.group(2);
        }
        QuantityUtils quantityUtils = this;
        try {
            QuantityUtils $this$parse_u24lambda_u241 = quantityUtils;
            boolean bl = false;
            if (text != null && number != null) {
                return Long.parseLong(number) * ExtensionsKt.match((Collection<? extends QuantityUnit>)units, text).getBaseEquivalent();
            }
            Object object = Result.constructor-impl(Unit.INSTANCE);
        }
        catch (Throwable throwable) {
            Object object = Result.constructor-impl(ResultKt.createFailure(throwable));
        }
        return null;
    }
}

