/*
 * Decompiled with CFR 0.152.
 */
package com.marcpg.libpg.data;

import com.marcpg.libpg.data.QuantityUnit;
import com.marcpg.libpg.data.QuantityUtils;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0004\n\u0002\b\u000e\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\r\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0002\b\u0002\b&\u0018\u0000*\u0014\b\u0000\u0010\u0001*\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0000*\b\b\u0001\u0010\u0002*\u00020\u00032\b\u0012\u0004\u0012\u0002H\u00010\u0004B\u001b\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nB\u0011\b\u0016\u0012\u0006\u0010\u000b\u001a\u00028\u0000\u00a2\u0006\u0004\b\t\u0010\fB#\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00028\u0001\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\u000fJ\u0015\u0010\u001f\u001a\u00028\u00002\u0006\u0010\u0005\u001a\u00020\u0006H&\u00a2\u0006\u0002\u0010 J\u0016\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010.J\u0016\u0010/\u001a\u00028\u00002\u0006\u0010-\u001a\u00028\u0000H\u0086\u0006\u00a2\u0006\u0002\u00100J\u0011\u00101\u001a\u0002022\u0006\u0010\u000b\u001a\u00020\u0006H\u0086\u0002J\u0016\u00101\u001a\u0002022\u0006\u0010\u000b\u001a\u00028\u0000H\u0086\u0002\u00a2\u0006\u0002\u0010\fJ\u000e\u00103\u001a\u00028\u0000H\u0086\u0002\u00a2\u0006\u0002\u0010\u001aJ\u0016\u00104\u001a\u00028\u00002\u0006\u0010-\u001a\u00028\u0000H\u0086\u0006\u00a2\u0006\u0002\u00100J\u0011\u00105\u001a\u0002022\u0006\u0010\u000b\u001a\u00020\u0006H\u0086\u0002J\u0016\u00105\u001a\u0002022\u0006\u0010\u000b\u001a\u00028\u0000H\u0086\u0002\u00a2\u0006\u0002\u0010\fJ\u000e\u00106\u001a\u00028\u0000H\u0086\u0002\u00a2\u0006\u0002\u0010\u001aJ\u0016\u00107\u001a\u00028\u00002\u0006\u0010-\u001a\u00028\u0000H\u0086\u0006\u00a2\u0006\u0002\u00100J\u0011\u00108\u001a\u0002022\u0006\u0010\u000b\u001a\u00020\u0006H\u0086\u0002J\u0016\u00108\u001a\u0002022\u0006\u0010\u000b\u001a\u00028\u0000H\u0086\u0002\u00a2\u0006\u0002\u0010\fJ\u0016\u00109\u001a\u00028\u00002\u0006\u0010-\u001a\u00028\u0000H\u0086\u0006\u00a2\u0006\u0002\u00100J\u0011\u0010:\u001a\u0002022\u0006\u0010\u000b\u001a\u00020\u0006H\u0086\u0002J\u0016\u0010:\u001a\u0002022\u0006\u0010\u000b\u001a\u00028\u0000H\u0086\u0002\u00a2\u0006\u0002\u0010\fJ\u0016\u0010;\u001a\u00028\u00002\u0006\u0010-\u001a\u00028\u0000H\u0086\u0006\u00a2\u0006\u0002\u00100J\u0011\u0010<\u001a\u0002022\u0006\u0010\u000b\u001a\u00020\u0006H\u0086\u0002J\u0016\u0010<\u001a\u0002022\u0006\u0010\u000b\u001a\u00028\u0000H\u0086\u0002\u00a2\u0006\u0002\u0010\fJ\u0006\u0010=\u001a\u00020\u0006J\u0016\u0010=\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00028\u0001H\u0086\u0002\u00a2\u0006\u0002\u0010>J\u0013\u0010?\u001a\u00020@2\u0006\u0010\u000e\u001a\u00028\u0001\u00a2\u0006\u0002\u0010AJ\u001b\u0010B\u001a\u0002022\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00028\u0001\u00a2\u0006\u0002\u0010CJ\u000e\u0010B\u001a\u0002022\u0006\u0010\u000b\u001a\u00020\u0006J\u001b\u0010D\u001a\u0002022\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00028\u0001\u00a2\u0006\u0002\u0010CJ\u000e\u0010D\u001a\u0002022\u0006\u0010\u000b\u001a\u00020\u0006J\u001b\u0010E\u001a\u0002022\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00028\u0001\u00a2\u0006\u0002\u0010CJ\u000e\u0010E\u001a\u0002022\u0006\u0010\u000b\u001a\u00020\u0006J\u0013\u0010E\u001a\u0002022\u0006\u0010\u000b\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\fJ\b\u0010F\u001a\u00020,H&J\u0013\u0010G\u001a\u00020\b2\b\u0010-\u001a\u0004\u0018\u00010HH\u00a6\u0002J\b\u0010I\u001a\u00020\"H\u0016R\u001a\u0010\u0005\u001a\u00020\u0006X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0012\u0010\u0018\u001a\u00028\u0000X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0018\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00030\u001cX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010!\u001a\u00020\"8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0011\u0010%\u001a\u00020\"8F\u00a2\u0006\u0006\u001a\u0004\b&\u0010$R\u001d\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060(8F\u00a2\u0006\u0006\u001a\u0004\b)\u0010*\u00a8\u0006J"}, d2={"Lcom/marcpg/libpg/data/Quantity;", "T", "U", "Lcom/marcpg/libpg/data/QuantityUnit;", "", "data", "", "allowNegatives", "", "<init>", "(JZ)V", "quantity", "(Lcom/marcpg/libpg/data/Quantity;)V", "", "unit", "(Ljava/lang/Number;Lcom/marcpg/libpg/data/QuantityUnit;Z)V", "getData", "()J", "setData", "(J)V", "getAllowNegatives", "()Z", "setAllowNegatives", "(Z)V", "thisInst", "getThisInst", "()Lcom/marcpg/libpg/data/Quantity;", "units", "", "getUnits", "()Ljava/util/List;", "construct", "(J)Lcom/marcpg/libpg/data/Quantity;", "oneUnitFormatted", "", "getOneUnitFormatted", "()Ljava/lang/String;", "preciselyFormatted", "getPreciselyFormatted", "preciseUnits", "", "getPreciseUnits", "()Ljava/util/Map;", "compareTo", "", "other", "(Lcom/marcpg/libpg/data/Quantity;)I", "plus", "(Lcom/marcpg/libpg/data/Quantity;)Lcom/marcpg/libpg/data/Quantity;", "plusAssign", "", "inc", "minus", "minusAssign", "dec", "times", "timesAssign", "div", "divAssign", "rem", "remAssign", "get", "(Lcom/marcpg/libpg/data/QuantityUnit;)J", "getAsExact", "", "(Lcom/marcpg/libpg/data/QuantityUnit;)D", "increment", "(JLcom/marcpg/libpg/data/QuantityUnit;)V", "decrement", "set", "hashCode", "equals", "", "toString", "base"})
public abstract class Quantity<T extends Quantity<T, U>, U extends QuantityUnit>
implements Comparable<T> {
    private long data;
    private boolean allowNegatives;

    public Quantity(long data, boolean allowNegatives) {
        this.data = data;
        this.allowNegatives = allowNegatives;
    }

    public /* synthetic */ Quantity(long l, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            l = 0L;
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        this(l, bl);
    }

    protected final long getData() {
        return this.data;
    }

    protected final void setData(long l) {
        this.data = l;
    }

    public final boolean getAllowNegatives() {
        return this.allowNegatives;
    }

    public final void setAllowNegatives(boolean bl) {
        this.allowNegatives = bl;
    }

    public Quantity(@NotNull T quantity) {
        Intrinsics.checkNotNullParameter(quantity, "quantity");
        this(((Quantity)quantity).data, ((Quantity)quantity).allowNegatives);
    }

    public Quantity(@NotNull Number data, @NotNull U unit, boolean allowNegatives) {
        Intrinsics.checkNotNullParameter(data, "data");
        Intrinsics.checkNotNullParameter(unit, "unit");
        this(data instanceof Integer || data instanceof Double ? data.longValue() * unit.getBaseEquivalent() : (long)(data.doubleValue() * (double)unit.getBaseEquivalent()), allowNegatives);
    }

    public /* synthetic */ Quantity(Number number, QuantityUnit quantityUnit, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = false;
        }
        this(number, quantityUnit, bl);
    }

    @NotNull
    protected abstract T getThisInst();

    @NotNull
    public abstract List<QuantityUnit> getUnits();

    @NotNull
    public abstract T construct(long var1);

    @NotNull
    public final String getOneUnitFormatted() {
        return QuantityUtils.INSTANCE.oneUnitFormat(this.data, this.getUnits());
    }

    @NotNull
    public final String getPreciselyFormatted() {
        return QuantityUtils.INSTANCE.preciselyFormat(this.data, this.getUnits());
    }

    @NotNull
    public final Map<QuantityUnit, Long> getPreciseUnits() {
        return QuantityUtils.INSTANCE.preciseUnits(this.data, this.getUnits());
    }

    @Override
    public int compareTo(@NotNull T other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return Intrinsics.compare(this.data, ((Quantity)other).data);
    }

    @NotNull
    public final T plus(@NotNull T other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return this.construct(this.data + ((Quantity)other).data);
    }

    public final void plusAssign(long quantity) {
        this.data += quantity;
    }

    public final void plusAssign(@NotNull T quantity) {
        Intrinsics.checkNotNullParameter(quantity, "quantity");
        this.data += ((Quantity)quantity).data;
    }

    @NotNull
    public final T inc() {
        this.increment(1L);
        Intrinsics.checkNotNull(this, "null cannot be cast to non-null type T of com.marcpg.libpg.data.Quantity");
        return (T)this;
    }

    @NotNull
    public final T minus(@NotNull T other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return this.construct(this.data - ((Quantity)other).data);
    }

    public final void minusAssign(long quantity) {
        this.data = Math.max(this.allowNegatives ? Long.MIN_VALUE : 0L, this.data - quantity);
    }

    public final void minusAssign(@NotNull T quantity) {
        Intrinsics.checkNotNullParameter(quantity, "quantity");
        this.data = Math.max(this.allowNegatives ? Long.MIN_VALUE : 0L, this.data - ((Quantity)quantity).data);
    }

    @NotNull
    public final T dec() {
        this.decrement(1L);
        Intrinsics.checkNotNull(this, "null cannot be cast to non-null type T of com.marcpg.libpg.data.Quantity");
        return (T)this;
    }

    @NotNull
    public final T times(@NotNull T other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return this.construct(this.data * ((Quantity)other).data);
    }

    public final void timesAssign(long quantity) {
        this.data *= quantity;
    }

    public final void timesAssign(@NotNull T quantity) {
        Intrinsics.checkNotNullParameter(quantity, "quantity");
        this.data *= ((Quantity)quantity).data;
    }

    @NotNull
    public final T div(@NotNull T other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return this.construct(this.data / ((Quantity)other).data);
    }

    public final void divAssign(long quantity) {
        this.data /= quantity;
    }

    public final void divAssign(@NotNull T quantity) {
        Intrinsics.checkNotNullParameter(quantity, "quantity");
        this.data /= ((Quantity)quantity).data;
    }

    @NotNull
    public final T rem(@NotNull T other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return this.construct(this.data % ((Quantity)other).data);
    }

    public final void remAssign(long quantity) {
        this.data %= quantity;
    }

    public final void remAssign(@NotNull T quantity) {
        Intrinsics.checkNotNullParameter(quantity, "quantity");
        this.data %= ((Quantity)quantity).data;
    }

    public final long get() {
        return this.data;
    }

    public final long get(@NotNull U unit) {
        Intrinsics.checkNotNullParameter(unit, "unit");
        return this.data / unit.getBaseEquivalent();
    }

    public final double getAsExact(@NotNull U unit) {
        Intrinsics.checkNotNullParameter(unit, "unit");
        return (double)this.data / (double)unit.getBaseEquivalent();
    }

    public final void increment(long quantity, @NotNull U unit) {
        Intrinsics.checkNotNullParameter(unit, "unit");
        this.plusAssign(quantity * unit.getBaseEquivalent());
    }

    public final void increment(long quantity) {
        this.plusAssign(quantity);
    }

    public final void decrement(long quantity, @NotNull U unit) {
        Intrinsics.checkNotNullParameter(unit, "unit");
        this.minusAssign(quantity * unit.getBaseEquivalent());
    }

    public final void decrement(long quantity) {
        this.minusAssign(quantity);
    }

    public final void set(long quantity, @NotNull U unit) {
        Intrinsics.checkNotNullParameter(unit, "unit");
        this.data = quantity * unit.getBaseEquivalent();
    }

    public final void set(long quantity) {
        this.data = quantity;
    }

    public final void set(@NotNull T quantity) {
        Intrinsics.checkNotNullParameter(quantity, "quantity");
        this.data = ((Quantity)quantity).get();
    }

    public abstract int hashCode();

    public abstract boolean equals(@Nullable Object var1);

    @NotNull
    public String toString() {
        return this.getPreciselyFormatted();
    }

    public Quantity() {
        this(0L, false, 3, null);
    }
}

