/*
 * Decompiled with CFR 0.152.
 */
package tw.maoyue.catchball.libs.updatechecker;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import tw.maoyue.catchball.libs.updatechecker.UpdateCheckEvent;
import tw.maoyue.catchball.libs.updatechecker.UpdateCheckResult;
import tw.maoyue.catchball.libs.updatechecker.UpdateCheckSuccess;
import tw.maoyue.catchball.libs.updatechecker.UpdateChecker;

class UpdateCheckerMessages {
    UpdateCheckerMessages() {
    }

    @NotNull
    private static TextComponent createLink(@NotNull String text, @NotNull String link) {
        ComponentBuilder lore = new ComponentBuilder("Link: ").bold(true).append(link).bold(false);
        TextComponent component = new TextComponent(text);
        component.setBold(Boolean.valueOf(true));
        component.setColor(net.md_5.bungee.api.ChatColor.GOLD);
        component.setClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, link));
        component.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, lore.create()));
        return component;
    }

    protected static void printCheckResultToConsole(UpdateCheckEvent event) {
        UpdateChecker instance = UpdateChecker.getInstance();
        Plugin plugin = instance.getPlugin();
        if (event.getSuccess() == UpdateCheckSuccess.FAIL || event.getResult() == UpdateCheckResult.UNKNOWN) {
            plugin.getLogger().warning("Could not check for updates.");
            return;
        }
        if (event.getResult() == UpdateCheckResult.RUNNING_LATEST_VERSION) {
            if (UpdateChecker.getInstance().isSuppressUpToDateMessage()) {
                return;
            }
            plugin.getLogger().info(String.format("You are using the latest version of %s.", plugin.getName()));
            return;
        }
        ArrayList<String> lines = new ArrayList<String>();
        lines.add(String.format("There is a new version of %s available!", plugin.getName()));
        lines.add(" ");
        lines.add(String.format("Your version:   %s%s", instance.isColoredConsoleOutput() ? ChatColor.RED : "", event.getUsedVersion()));
        lines.add(String.format("Latest version: %s%s", instance.isColoredConsoleOutput() ? ChatColor.GREEN : "", event.getLatestVersion()));
        List<String> downloadLinks = instance.getAppropriateDownloadLinks();
        if (downloadLinks.size() > 0) {
            lines.add(" ");
            lines.add("Please update to the newest version.");
            lines.add(" ");
            if (downloadLinks.size() == 1) {
                lines.add("Download:");
                lines.add("  " + downloadLinks.get(0));
            } else if (downloadLinks.size() == 2) {
                lines.add(String.format("Download (%s)", instance.getNamePaidVersion()));
                lines.add("  " + downloadLinks.get(0));
                lines.add(" ");
                lines.add(String.format("Download (%s)", instance.getNameFreeVersion()));
                lines.add("  " + downloadLinks.get(1));
            }
        }
        if (instance.getSupportLink() != null) {
            lines.add(" ");
            lines.add("Support:");
            lines.add("  " + instance.getSupportLink());
        }
        if (instance.getDonationLink() != null) {
            lines.add(" ");
            lines.add("Donate:");
            lines.add("  " + instance.getDonationLink());
        }
        UpdateCheckerMessages.printNiceBoxToConsole(plugin.getLogger(), lines);
    }

    protected static void printCheckResultToPlayer(Player player, boolean showMessageWhenLatestVersion) {
        UpdateChecker instance = UpdateChecker.getInstance();
        if (instance.getLastCheckResult() == UpdateCheckResult.NEW_VERSION_AVAILABLE) {
            player.sendMessage(ChatColor.GRAY + "There is a new version of " + ChatColor.GOLD + instance.getPlugin().getName() + ChatColor.GRAY + " available.");
            UpdateCheckerMessages.sendLinks(player);
            player.sendMessage(ChatColor.DARK_GRAY + "Latest version: " + ChatColor.GREEN + instance.getLatestVersion() + ChatColor.DARK_GRAY + " | Your version: " + ChatColor.RED + instance.getUsedVersion());
            player.sendMessage("");
        } else if (instance.getLastCheckResult() == UpdateCheckResult.UNKNOWN) {
            player.sendMessage(ChatColor.GOLD + instance.getPlugin().getName() + ChatColor.RED + " could not check for updates.");
        } else if (showMessageWhenLatestVersion) {
            player.sendMessage(ChatColor.GREEN + "You are running the latest version of " + ChatColor.GOLD + instance.getPlugin().getName());
        }
    }

    private static void printNiceBoxToConsole(Logger logger, List<String> lines) {
        int longestLine = 0;
        for (String line : lines) {
            longestLine = Math.max(line.length(), longestLine);
        }
        if ((longestLine += 2) > 120) {
            longestLine = 120;
        }
        StringBuilder dash = new StringBuilder(longestLine += 2);
        Stream.generate(() -> "*").limit(longestLine).forEach(dash::append);
        logger.log(Level.WARNING, dash.toString());
        for (String line : lines) {
            logger.log(Level.WARNING, "* " + line);
        }
        logger.log(Level.WARNING, dash.toString());
    }

    private static void sendLinks(Player ... players) {
        UpdateChecker instance = UpdateChecker.getInstance();
        ArrayList<TextComponent> links = new ArrayList<TextComponent>();
        List<String> downloadLinks = instance.getAppropriateDownloadLinks();
        if (downloadLinks.size() == 2) {
            links.add(UpdateCheckerMessages.createLink(String.format("Download (%s)", instance.getNamePaidVersion()), downloadLinks.get(0)));
            links.add(UpdateCheckerMessages.createLink(String.format("Download (%s)", instance.getNameFreeVersion()), downloadLinks.get(1)));
        } else if (downloadLinks.size() == 1) {
            links.add(UpdateCheckerMessages.createLink("Download", downloadLinks.get(0)));
        }
        if (instance.getDonationLink() != null) {
            links.add(UpdateCheckerMessages.createLink("Donate", instance.getDonationLink()));
        }
        if (instance.getChangelogLink() != null) {
            links.add(UpdateCheckerMessages.createLink("Changelog", instance.getChangelogLink()));
        }
        if (instance.getSupportLink() != null) {
            links.add(UpdateCheckerMessages.createLink("Support", instance.getSupportLink()));
        }
        TextComponent placeholder = new TextComponent(" | ");
        placeholder.setColor(net.md_5.bungee.api.ChatColor.GRAY);
        TextComponent text = new TextComponent("");
        Iterator iterator2 = links.iterator();
        while (iterator2.hasNext()) {
            TextComponent next = (TextComponent)iterator2.next();
            text.addExtra((BaseComponent)next);
            if (!iterator2.hasNext()) continue;
            text.addExtra((BaseComponent)placeholder);
        }
        for (Player player : players) {
            player.spigot().sendMessage((BaseComponent)text);
        }
    }
}

