/*
 * Decompiled with CFR 0.152.
 */
package com.github.nutt1101.event;

import cn.handyplus.lib.adapter.PlayerSchedulerUtil;
import com.github.nutt1101.CatchBall;
import com.github.nutt1101.ConfigSetting;
import com.github.nutt1101.event.HitEvent;
import com.github.nutt1101.utils.NBTHandler;
import com.github.nutt1101.utils.TranslationFileReader;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class SkullClick
implements Listener {
    private final Plugin plugin = CatchBall.plugin;

    private EntityType getEntityType(String entityTypeString) {
        try {
            return EntityType.valueOf((String)entityTypeString.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            this.plugin.getLogger().warning("Invalid entity type: " + entityTypeString + ", using CHICKEN as fallback");
            return EntityType.CHICKEN;
        }
    }

    @EventHandler
    public void skullClick(PlayerInteractEvent event) {
        ItemStack item;
        Player player = event.getPlayer();
        ItemStack itemStack = item = event.getItem() != null ? event.getItem() : new ItemStack(Material.AIR);
        if (event.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK)) {
            if (!item.getType().equals((Object)Material.PLAYER_HEAD)) {
                return;
            }
            ItemMeta itemMeta = item.getItemMeta();
            PersistentDataContainer data = itemMeta.getPersistentDataContainer();
            if (data.has(new NamespacedKey(this.plugin, "skullData"), PersistentDataType.STRING)) {
                String path = ((String)data.get(new NamespacedKey(this.plugin, "skullData"), PersistentDataType.STRING)).toString();
                if (path == null) {
                    player.sendMessage(ConfigSetting.toChat(TranslationFileReader.skullDoesNotFound, "", ""));
                    event.setCancelled(true);
                } else {
                    if (!new HitEvent().resCheck(player, event.getClickedBlock().getLocation())) {
                        event.setCancelled(true);
                        return;
                    }
                    if (!new HitEvent().gfCheck(player, event.getClickedBlock().getLocation())) {
                        event.setCancelled(true);
                        return;
                    }
                    try {
                        String entityTypeString = (String)data.get(new NamespacedKey(this.plugin, "entityType"), PersistentDataType.STRING);
                        EntityType entityType = this.getEntityType(entityTypeString);
                        Location clickLocation = event.getClickedBlock().getLocation();
                        clickLocation.setX((double)clickLocation.getBlockX() + 0.5);
                        clickLocation.setZ((double)clickLocation.getBlockZ() + 0.5);
                        for (int i = 0; i < 3 && !clickLocation.getBlock().getType().equals((Object)Material.AIR) && !clickLocation.getBlock().getType().equals((Object)Material.WATER); ++i) {
                            clickLocation.setY(clickLocation.getY() + 1.0);
                            if (i != 2) continue;
                            player.sendMessage(ConfigSetting.toChat(TranslationFileReader.locationUnsafe, "", ""));
                            event.setCancelled(true);
                            return;
                        }
                        Entity entity = player.getWorld().spawnEntity(clickLocation, entityType);
                        Location location = clickLocation.clone();
                        location.setX((double)location.getBlockX() + 0.5);
                        location.setZ((double)location.getBlockZ() + 0.5);
                        NBTHandler.loadEntityNBT(this.plugin, entity, data);
                        PlayerSchedulerUtil.teleport(entity, location);
                        event.getItem().setAmount(0);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }
}

