/*
 * Decompiled with CFR 0.152.
 */
package com.github.nutt1101.event;

import br.net.fabiozumbi12.RedProtect.Bukkit.RedProtect;
import br.net.fabiozumbi12.RedProtect.Bukkit.Region;
import com.bekvon.bukkit.residence.api.ResidenceApi;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import com.github.nutt1101.CatchBall;
import com.github.nutt1101.ConfigSetting;
import com.github.nutt1101.HeadDrop;
import com.github.nutt1101.items.Ball;
import com.github.nutt1101.utils.NBTHandler;
import com.github.nutt1101.utils.TranslationFileReader;
import com.palmergames.bukkit.towny.object.TownyPermission;
import com.palmergames.bukkit.towny.utils.PlayerCacheUtil;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import me.angeschossen.lands.api.flags.Flags;
import me.angeschossen.lands.api.land.LandWorld;
import me.ryanhamshire.GriefPrevention.Claim;
import me.ryanhamshire.GriefPrevention.ClaimPermission;
import me.ryanhamshire.GriefPrevention.GriefPrevention;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Snowball;
import org.bukkit.entity.Tameable;
import org.bukkit.entity.ThrowableProjectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.BlockProjectileSource;
import org.bukkit.projectiles.ProjectileSource;

public class HitEvent
implements Listener {
    private List<String> catchableEntity = ConfigSetting.catchableEntity;
    private Location hitLocation;
    private final Plugin plugin = CatchBall.plugin;
    private final String[] mmPackage = new String[]{"io.lumine.mythic.bukkit.BukkitAPIHelper", "io.lumine.xikage.mythicmobs.api.bukkit.BukkitAPIHelper"};

    private boolean isEntityCatchable(EntityType entityType) {
        String entityName = entityType.name();
        return this.catchableEntity.contains(entityName);
    }

    @EventHandler
    public void CatchBallHitEvent(ProjectileHitEvent event) {
        ProjectileSource projectileSource = event.getEntity().getShooter();
        if (projectileSource instanceof Player) {
            Player player = (Player)projectileSource;
            if (!this.checkCatchBall(event.getEntity())) {
                return;
            }
            if (!player.hasPermission("catchball.use")) {
                player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)ConfigSetting.toChat(TranslationFileReader.noPermissionToUse, HitEvent.getCoordinate(event.getHitBlock() == null ? Objects.requireNonNull(event.getHitEntity()).getLocation() : event.getHitBlock().getLocation()), "").replace("{BALL}", TranslationFileReader.catchBallName)));
                event.getEntity().remove();
                if (event.getHitEntity() != null) {
                    hitEntity = event.getHitEntity();
                    this.hitLocation = hitEntity.getLocation();
                    event.getHitEntity().getWorld().dropItem(event.getHitEntity().getLocation(), Ball.makeBall());
                } else {
                    event.getHitBlock().getWorld().dropItem(event.getHitBlock().getLocation(), Ball.makeBall());
                }
                event.setCancelled(true);
                return;
            }
            event.setCancelled(true);
            event.getEntity().remove();
            if (event.getHitEntity() != null) {
                this.handleEntityCatch(player, event.getHitEntity(), true);
            } else if (event.getHitBlock() != null) {
                event.getEntity().remove();
                this.hitLocation = event.getHitBlock().getLocation();
                player.sendMessage(ConfigSetting.toChat(TranslationFileReader.ballHitBlock, HitEvent.getCoordinate(this.hitLocation), ""));
                event.getHitBlock().getWorld().dropItem(event.getHitBlock().getLocation(), Ball.makeBall());
                return;
            }
        } else if (event.getEntity().getShooter() instanceof BlockProjectileSource) {
            if (!this.checkCatchBall(event.getEntity())) {
                return;
            }
            event.setCancelled(true);
            event.getEntity().remove();
            if (event.getHitEntity() != null) {
                hitEntity = event.getHitEntity();
                this.hitLocation = hitEntity.getLocation();
                String checkCustom = this.getIsCustomEntity(hitEntity);
                if (this.isEntityCatchable(hitEntity.getType()) && !(hitEntity instanceof Player) && !checkCustom.equals("CUSTOM")) {
                    hitEntity.remove();
                    hitEntity.getWorld().dropItem(this.hitLocation, new HeadDrop().getEntityHead(event.getHitEntity(), null));
                    return;
                }
                hitEntity.getWorld().dropItem(this.hitLocation, Ball.makeBall());
            } else if (event.getHitBlock() != null) {
                this.hitLocation = event.getHitBlock().getLocation();
                event.getHitBlock().getWorld().dropItem(event.getHitBlock().getLocation(), Ball.makeBall());
                return;
            }
        }
    }

    @EventHandler
    public void onPlayerInteractEntity(PlayerInteractEntityEvent event) {
        Player player = event.getPlayer();
        Entity targetEntity = event.getRightClicked();
        ItemStack itemInHand = player.getInventory().getItemInMainHand();
        if (!this.isCatchBall(itemInHand)) {
            return;
        }
        if (!player.hasPermission("catchball.use")) {
            player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)ConfigSetting.toChat(TranslationFileReader.noPermissionToUse, HitEvent.getCoordinate(targetEntity.getLocation()), "").replace("{BALL}", TranslationFileReader.catchBallName)));
            return;
        }
        event.setCancelled(true);
        if (itemInHand.getAmount() > 1) {
            itemInHand.setAmount(itemInHand.getAmount() - 1);
        } else {
            player.getInventory().setItemInMainHand(new ItemStack(Material.AIR));
        }
        this.handleEntityCatch(player, targetEntity, false);
    }

    private void handleEntityCatch(Player player, Entity hitEntity, boolean isProjectile) {
        Tameable tameable;
        this.hitLocation = hitEntity.getLocation();
        if (!this.resCheck(player, hitEntity.getLocation()) && ConfigSetting.UseRes) {
            hitEntity.getWorld().dropItem(hitEntity.getLocation(), Ball.makeBall());
            player.sendMessage(ConfigSetting.toChat(TranslationFileReader.canNotCatchable, HitEvent.getCoordinate(hitEntity.getLocation()), ""));
            return;
        }
        if (!this.mmCheck(player, hitEntity) && ConfigSetting.UseMM) {
            hitEntity.getWorld().dropItem(hitEntity.getLocation(), Ball.makeBall());
            player.sendMessage(ConfigSetting.toChat(TranslationFileReader.canNotCatchable, HitEvent.getCoordinate(hitEntity.getLocation()), ""));
            return;
        }
        if (!this.gfCheck(player, hitEntity.getLocation()) && ConfigSetting.UseGF) {
            hitEntity.getWorld().dropItem(hitEntity.getLocation(), Ball.makeBall());
            player.sendMessage(ConfigSetting.toChat(TranslationFileReader.canNotCatchable, HitEvent.getCoordinate(hitEntity.getLocation()), ""));
            return;
        }
        if (!this.landsCheck(player, hitEntity.getLocation()) && ConfigSetting.UseLands) {
            hitEntity.getWorld().dropItem(hitEntity.getLocation(), Ball.makeBall());
            player.sendMessage(ConfigSetting.toChat(TranslationFileReader.canNotCatchable, HitEvent.getCoordinate(hitEntity.getLocation()), ""));
            return;
        }
        if (!this.rpCheck(player, hitEntity.getLocation()) && ConfigSetting.UseRP) {
            hitEntity.getWorld().dropItem(hitEntity.getLocation(), Ball.makeBall());
            player.sendMessage(ConfigSetting.toChat(TranslationFileReader.canNotCatchable, HitEvent.getCoordinate(hitEntity.getLocation()), ""));
            return;
        }
        if (!this.scsCheck(player, hitEntity.getLocation()) && ConfigSetting.UseSCS) {
            hitEntity.getWorld().dropItem(hitEntity.getLocation(), Ball.makeBall());
            player.sendMessage(ConfigSetting.toChat(TranslationFileReader.canNotCatchable, HitEvent.getCoordinate(hitEntity.getLocation()), ""));
            return;
        }
        if (!this.townyCheck(player, hitEntity.getLocation()) && ConfigSetting.UseTowny) {
            hitEntity.getWorld().dropItem(hitEntity.getLocation(), Ball.makeBall());
            player.sendMessage(ConfigSetting.toChat(TranslationFileReader.canNotCatchable, HitEvent.getCoordinate(hitEntity.getLocation()), ""));
            return;
        }
        if (hitEntity instanceof Tameable && (tameable = (Tameable)hitEntity).isTamed()) {
            boolean sameOwner;
            boolean isNullOwnerValue = tameable.getOwner() == null;
            boolean bl = sameOwner = isNullOwnerValue ? true : tameable.getOwner().getName().equals(player.getName());
            if (isNullOwnerValue && !ConfigSetting.allowCatchableTamedOwnerIsNull || !sameOwner) {
                hitEntity.getWorld().dropItem(hitEntity.getLocation(), Ball.makeBall());
                player.sendMessage(ConfigSetting.toChat(TranslationFileReader.canNotCatchable, HitEvent.getCoordinate(hitEntity.getLocation()), ""));
                return;
            }
        }
        String checkCustom = this.getIsCustomEntity(hitEntity);
        if (this.isEntityCatchable(hitEntity.getType()) && !(hitEntity instanceof Player) && !checkCustom.equals("CUSTOM")) {
            if (Math.random() < ConfigSetting.catchFailRate) {
                hitEntity.getWorld().dropItem(this.hitLocation, Ball.makeBall());
                player.sendMessage(ConfigSetting.toChat(TranslationFileReader.catchFail, HitEvent.getCoordinate(this.hitLocation), hitEntity.getType().name()));
                return;
            }
            if (!ConfigSetting.catchSuccessSound.equals("FALSE")) {
                player.playSound(player.getLocation(), Sound.valueOf((String)ConfigSetting.catchSuccessSound), 1.0f, 1.0f);
            }
            hitEntity.remove();
            hitEntity.getWorld().dropItem(this.hitLocation, new HeadDrop().getEntityHead(hitEntity, player));
            if (ConfigSetting.ShowParticles) {
                hitEntity.getWorld().spawnParticle(Particle.valueOf((String)ConfigSetting.CustomParticles), this.hitLocation, 1);
            }
            player.sendMessage(ConfigSetting.toChat(TranslationFileReader.catchSuccess, HitEvent.getCoordinate(this.hitLocation), hitEntity.getType().name()));
            return;
        }
        player.sendMessage(ConfigSetting.toChat(TranslationFileReader.canNotCatchable, HitEvent.getCoordinate(this.hitLocation), ""));
        hitEntity.getWorld().dropItem(this.hitLocation, Ball.makeBall());
    }

    private boolean isCatchBall(ItemStack item) {
        if (item == null || item.getType() == Material.AIR) {
            return false;
        }
        ItemStack catchBall = Ball.makeBall();
        return item.isSimilar(catchBall);
    }

    public static String getCoordinate(Location location) {
        return location.getBlockX() + ", " + location.getBlockY() + ", " + location.getBlockZ();
    }

    public boolean resCheck(Player player, Location location) {
        if (!CatchBall.hasResidence) {
            return true;
        }
        if (ResidenceApi.getResidenceManager().getByLoc(location) == null) {
            return true;
        }
        ClaimedResidence residence = ResidenceApi.getResidenceManager().getByLoc(location);
        if (residence.getOwnerUUID().equals(player.getUniqueId()) || player.isOp() || player.hasPermission("catchball.op")) {
            return true;
        }
        for (String flags : ConfigSetting.residenceFlag) {
            if (residence.getPermissions().playerHas(player, com.bekvon.bukkit.residence.containers.Flags.valueOf((String)flags.toLowerCase()), true)) continue;
            player.sendMessage(ConfigSetting.toChat(TranslationFileReader.noResidencePermissions, "", "").replace("{FLAG}", flags));
            return false;
        }
        return true;
    }

    public boolean mmCheck(Player player, Entity entity) {
        if (!CatchBall.hasMythicMobs) {
            return true;
        }
        for (int i = 0; i < 2; ++i) {
            try {
                Class<?> api = Class.forName(this.mmPackage[i]);
                Object ins = api.getConstructor(new Class[0]).newInstance(new Object[0]);
                Method isMythicMob = api.getDeclaredMethod("isMythicMob", Entity.class);
                return (Boolean)isMythicMob.invoke(ins, entity) == false;
            }
            catch (Exception exception) {
                continue;
            }
        }
        return true;
    }

    public boolean landsCheck(Player player, Location location) {
        if (!CatchBall.hasLands) {
            return true;
        }
        LandWorld world = CatchBall.landsAPI.getWorld(this.hitLocation.getWorld());
        if (world != null) {
            return world.hasFlag(player, this.hitLocation, null, Flags.ATTACK_ANIMAL, false);
        }
        return true;
    }

    public boolean gfCheck(Player player, Location location) {
        if (!CatchBall.hasGriefPrevention) {
            return true;
        }
        Claim claim = GriefPrevention.instance.dataStore.getClaimAt(location, false, null);
        if (claim == null) {
            return true;
        }
        UUID ownerId = claim.getOwnerID();
        if (ownerId != null && ownerId.equals(player.getUniqueId()) || player.hasPermission("catchball.op") || player.isOp()) {
            return true;
        }
        for (String flags : ConfigSetting.griefPreventionFlag) {
            if (claim.hasExplicitPermission(player, ClaimPermission.valueOf((String)flags))) continue;
            player.sendMessage(ConfigSetting.toChat(TranslationFileReader.noResidencePermissions, "", "").replace("{FLAG}", flags));
            return false;
        }
        return true;
    }

    public boolean rpCheck(Player player, Location location) {
        if (!CatchBall.hasRedProtect) {
            return true;
        }
        Region r = RedProtect.get().getAPI().getRegion(player.getLocation());
        return r != null && r.canSpawnPassives((Entity)player);
    }

    public boolean scsCheck(Player player, Location location) {
        if (!CatchBall.hasSimpleClaimSystem) {
            return true;
        }
        fr.xyness.SCS.Types.Claim claim = CatchBall.scsAPI.getClaimAtChunk(this.getChunkFromLocation(location));
        if (claim != null) {
            return claim.getPermission(player.getName(), null);
        }
        return true;
    }

    public Chunk getChunkFromLocation(Location location) {
        int chunkX = location.getBlockX() >> 4;
        int chunkZ = location.getBlockZ() >> 4;
        return location.getWorld().getChunkAt(chunkX, chunkZ);
    }

    public boolean townyCheck(Player player, Location location) {
        if (!CatchBall.hasTowny) {
            return true;
        }
        boolean bBuild = PlayerCacheUtil.getCachePermission((Player)player, (Location)location, (Material)Material.valueOf((String)"dirt"), (TownyPermission.ActionType)TownyPermission.ActionType.BUILD);
        return bBuild;
    }

    public boolean checkCatchBall(Projectile projectile) {
        ThrowableProjectile throwableProjectile;
        if (!(projectile instanceof Snowball)) {
            return false;
        }
        return !(projectile instanceof ThrowableProjectile) || Objects.requireNonNull((throwableProjectile = (ThrowableProjectile)projectile).getItem().getItemMeta()).equals((Object)Ball.makeBall().getItemMeta());
    }

    public String getIsCustomEntity(Entity hitEntity) {
        String checkCustom = null;
        checkCustom = NBTHandler.isCustomEntity(hitEntity);
        return checkCustom;
    }
}

