/*
 * Decompiled with CFR 0.152.
 */
package com.github.nutt1101.GUI;

import com.github.nutt1101.ConfigSetting;
import com.github.nutt1101.HeadDrop;
import com.github.nutt1101.utils.TranslationFileReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class CatchableList {
    private List<ItemStack> head = new ArrayList<ItemStack>();
    private ItemStack prevPage = new ItemStack(Material.PAPER);
    private ItemStack nextPage = new ItemStack(Material.PAPER);
    private ItemStack currentPage = new ItemStack(Material.OAK_SIGN);

    private ItemStack itemSet(ItemStack item, String displayName, int page) {
        displayName = displayName.replace("{PAGE}", String.valueOf(page));
        ItemMeta itemMeta = item.getItemMeta();
        itemMeta.setDisplayName(ConfigSetting.toChat(displayName, "", ""));
        item.setItemMeta(itemMeta);
        return item;
    }

    private boolean isEntityCatchable(String entityName) {
        for (String catchableEntity : ConfigSetting.catchableEntity) {
            String catchableEntityName = catchableEntity instanceof String ? catchableEntity : catchableEntity.toString();
            if (!catchableEntityName.equalsIgnoreCase(entityName)) continue;
            return true;
        }
        return false;
    }

    public void openCatchableList(Player player, int page) {
        YamlConfiguration entityFile = ConfigSetting.entityFile;
        Set entityList = entityFile.getConfigurationSection("EntityList").getKeys(false);
        Inventory catchableInventory = Bukkit.createInventory((InventoryHolder)player, (int)54, (String)ConfigSetting.toChat(TranslationFileReader.catchableListTitle, "", ""));
        this.head.clear();
        for (String entity : entityList) {
            ItemStack skull = new HeadDrop().skullTextures(new ItemStack(Material.PLAYER_HEAD), entityFile, entity);
            ItemMeta skullMeta = skull.getItemMeta();
            String catchable = this.isEntityCatchable(entity) ? "&aTRUE" : "&cFALSE";
            skullMeta.setDisplayName(String.valueOf(ChatColor.WHITE) + entity);
            ArrayList<String> lore = new ArrayList<String>();
            for (String line : TranslationFileReader.guiSkullLore) {
                lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)line.replace("{ENTITY}", String.valueOf(ChatColor.AQUA) + entityFile.getString("EntityList." + entity + ".DisplayName")).replace("{CATCHABLE}", catchable)));
            }
            skullMeta.setLore(lore);
            skull.setItemMeta(skullMeta);
            this.head.add(skull);
        }
        int totalHeads = this.head.size();
        page = Math.min(page, (int)Math.ceil((double)totalHeads / 45.0));
        page = Math.max(page, 1);
        int start = (page - 1) * 45;
        int finish = Math.min(page * 45, totalHeads);
        catchableInventory.addItem(this.head.subList(start, finish).toArray(new ItemStack[0]));
        catchableInventory.setItem(45, this.itemSet(this.prevPage, TranslationFileReader.prevPage, page));
        catchableInventory.setItem(49, this.itemSet(this.currentPage, TranslationFileReader.currentPage, page));
        catchableInventory.setItem(53, this.itemSet(this.nextPage, TranslationFileReader.nextPage, page));
        player.openInventory(catchableInventory);
    }
}

