/*
 * Decompiled with CFR 0.152.
 */
package com.github.nutt1101;

import cn.handyplus.lib.adapter.HandySchedulerUtil;
import com.github.nutt1101.ConfigSetting;
import com.github.nutt1101.command.Command;
import com.github.nutt1101.command.TabComplete;
import com.github.nutt1101.event.BlockDrop;
import com.github.nutt1101.event.ChickenDrop;
import com.github.nutt1101.event.EntityDrop;
import com.github.nutt1101.event.GUIClick;
import com.github.nutt1101.event.HitEvent;
import com.github.nutt1101.event.SkullClick;
import fr.xyness.SCS.API.SimpleClaimSystemAPI;
import fr.xyness.SCS.API.SimpleClaimSystemAPI_Provider;
import java.util.logging.Level;
import me.angeschossen.lands.api.LandsIntegration;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import tw.maoyue.catchball.libs.bstats.bukkit.Metrics;
import tw.maoyue.catchball.libs.updatechecker.UpdateCheckSource;
import tw.maoyue.catchball.libs.updatechecker.UpdateChecker;

public class CatchBall
extends JavaPlugin {
    private FileConfiguration config = this.getConfig();
    public static Plugin plugin;
    public static boolean hasResidence;
    public static boolean hasMythicMobs;
    public static boolean hasGriefPrevention;
    public static boolean hasLands;
    public static boolean hasPlaceholderAPI;
    public static boolean hasRedProtect;
    public static boolean hasSimpleClaimSystem;
    public static boolean hasTowny;
    public static boolean hasWorldGuard;
    public static LandsIntegration landsAPI;
    public static SimpleClaimSystemAPI scsAPI;
    private Metrics metrics;

    private boolean checkAndInitializePlugin(String pluginName) {
        boolean hasPlugin;
        boolean bl = hasPlugin = this.getServer().getPluginManager().getPlugin(pluginName) != null;
        if (hasPlugin) {
            plugin.getLogger().log(Level.INFO, String.valueOf(ChatColor.GREEN) + pluginName + " Hook!");
        }
        return hasPlugin;
    }

    public void onEnable() {
        plugin = this;
        ConfigSetting.checkConfig();
        Metrics metrics = new Metrics((Plugin)this, 12380);
        this.initializePluginIntegrations();
        this.registerEvent();
        this.registerCommand();
        new UpdateChecker(this, UpdateCheckSource.GITHUB_RELEASE_TAG, "MagicTeaMC/CatchBall2").checkEveryXHours(1.0).setDownloadLink("https://modrinth.com/plugin/catchball/version/latest").setChangelogLink("https://modrinth.com/plugin/catchball/version/latest").checkNow();
        HandySchedulerUtil.init((Plugin)this);
    }

    private void initializePluginIntegrations() {
        hasResidence = this.checkAndInitializePlugin("Residence");
        hasMythicMobs = this.checkAndInitializePlugin("MythicMobs");
        hasGriefPrevention = this.checkAndInitializePlugin("GriefPrevention");
        hasLands = this.checkAndInitializePlugin("Lands");
        if (hasLands) {
            try {
                landsAPI = LandsIntegration.of((Plugin)plugin);
            }
            catch (Exception e) {
                plugin.getLogger().log(Level.WARNING, "Failed to initialize Lands API: " + e.getMessage());
                hasLands = false;
            }
        }
        hasPlaceholderAPI = this.checkAndInitializePlugin("PlaceholderAPI");
        hasRedProtect = this.checkAndInitializePlugin("RedProtect");
        hasSimpleClaimSystem = this.checkAndInitializePlugin("SimpleClaimSystem");
        if (hasSimpleClaimSystem) {
            try {
                scsAPI = SimpleClaimSystemAPI_Provider.getAPI();
            }
            catch (Exception e) {
                plugin.getLogger().log(Level.WARNING, "Failed to initialize SimpleClaimSystem API: " + e.getMessage());
                hasSimpleClaimSystem = false;
            }
        }
        hasTowny = this.checkAndInitializePlugin("Towny");
        hasWorldGuard = this.checkAndInitializePlugin("WorldGuard");
    }

    public void onDisable() {
        if (this.metrics != null) {
            this.metrics.shutdown();
        }
        this.getServer().getScheduler().cancelTasks((Plugin)this);
    }

    public void registerEvent() {
        PluginManager registerEvent = this.getServer().getPluginManager();
        registerEvent.registerEvents((Listener)new HitEvent(), (Plugin)this);
        if (ConfigSetting.DropEnable) {
            registerEvent.registerEvents((Listener)new EntityDrop(), (Plugin)this);
            registerEvent.registerEvents((Listener)new BlockDrop(), (Plugin)this);
            registerEvent.registerEvents((Listener)new ChickenDrop(), (Plugin)this);
        }
        registerEvent.registerEvents((Listener)new SkullClick(), (Plugin)this);
        registerEvent.registerEvents((Listener)new GUIClick(), (Plugin)this);
    }

    public void registerCommand() {
        PluginCommand ctbCommand = this.getCommand("ctb");
        if (ctbCommand != null) {
            ctbCommand.setExecutor((CommandExecutor)new Command());
            ctbCommand.setTabCompleter((TabCompleter)new TabComplete());
        }
    }

    public static String getServerVersion() {
        return plugin.getServer().getBukkitVersion();
    }

    static {
        hasResidence = false;
        hasMythicMobs = false;
        hasGriefPrevention = false;
        hasLands = false;
        hasPlaceholderAPI = false;
        hasRedProtect = false;
        hasSimpleClaimSystem = false;
        hasTowny = false;
        hasWorldGuard = false;
    }
}

