/*
 * Decompiled with CFR 0.152.
 */
package me.maledict.itWillBreak;

import me.maledict.itWillBreak.Main;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerItemDamageEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;

public record AboutToBreak(Main plugin) implements Listener
{
    private static final float DURABILITY_THRESHOLD = 0.1f;

    private boolean isItemAboutToBreak(ItemStack item) {
        ItemMeta itemMeta;
        if (item.getItemMeta() == null || !((itemMeta = item.getItemMeta()) instanceof Damageable)) {
            return false;
        }
        Damageable damageable = (Damageable)itemMeta;
        int damage = damageable.getDamage();
        int maxDamage = damageable.hasMaxDamage() ? damageable.getMaxDamage() : (int)item.getType().getMaxDurability();
        int durabilityLeft = maxDamage - damage;
        float percent = (float)durabilityLeft / (float)maxDamage;
        return percent < 0.1f;
    }

    @EventHandler
    public void onPlayerItemDamage(PlayerItemDamageEvent event) {
        ItemStack item = event.getItem();
        Player player = event.getPlayer();
        if (this.isItemAboutToBreak(item)) {
            Component itemName = item.effectiveName();
            player.sendActionBar(Component.translatable((String)"itwillbreak.about_to_break", (ComponentLike[])new ComponentLike[]{itemName.color((TextColor)NamedTextColor.RED)}).color((TextColor)NamedTextColor.RED));
        }
    }
}

