/*
 * Decompiled with CFR 0.152.
 */
package org.maboroshi.partyanimals.util;

import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;
import org.maboroshi.partyanimals.PartyAnimals;
import org.maboroshi.partyanimals.config.ConfigManager;

public class Logger {
    private final ConfigManager config;

    public Logger(PartyAnimals plugin) {
        this.config = plugin.getConfiguration();
    }

    private void log(String colorTag, String message) {
        String prefix = this.config != null && this.config.getMessageConfig() != null ? this.config.getMessageConfig().prefix : "<color:#51CF66><bold>Party Animals</bold> \u279f </color>";
        Bukkit.getConsoleSender().sendMessage(MiniMessage.miniMessage().deserialize((Object)(prefix + colorTag + message)));
    }

    public void debug(String message) {
        if (this.config != null && this.config.getMainConfig().debug) {
            this.log("<gray>[DEBUG] </gray>", message);
        }
    }

    public void info(String message) {
        this.log("", message);
    }

    public void warn(String message) {
        this.log("<yellow>", message);
    }

    public void error(String message) {
        this.log("<red>", message);
    }
}

